/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLPrettyPrinter {
    private static final Log log = LogFactory.getLog(XMLPrettyPrinter.class);
    private static final String PRETTIFIED_SUFFIX = ".prettyfied";

    public static void prettify(File file) {
        try {
            Class clazz = Loader.loadClass("org.w3c.tidy.Tidy");
            Object prettifier = clazz.newInstance();
            Method setXmlInFlagMethod = clazz.getMethod("setXmlTags", Boolean.TYPE);
            setXmlInFlagMethod.invoke(prettifier, Boolean.TRUE);
            Method setXmlOutFlagMethod = clazz.getMethod("setXmlOut", Boolean.TYPE);
            setXmlOutFlagMethod.invoke(prettifier, Boolean.TRUE);
            FileInputStream input = new FileInputStream(file);
            String existingFileName = file.getAbsolutePath();
            String tempFileName = existingFileName + PRETTIFIED_SUFFIX;
            File tempFile = new File(tempFileName);
            FileOutputStream tempFileOutputStream = new FileOutputStream(tempFile);
            Method parsr = clazz.getMethod("parse", InputStream.class, OutputStream.class);
            parsr.invoke(prettifier, input, tempFileOutputStream);
            ((InputStream)input).close();
            tempFileOutputStream.close();
            file.delete();
            if (!tempFile.renameTo(new File(existingFileName))) {
                throw new Exception("File renaming failed!" + existingFileName);
            }
            log.debug("Pretty printed file : " + file);
        }
        catch (ClassNotFoundException e) {
            log.debug("Tidy not found - unable to pretty print " + file);
        }
        catch (Exception e) {
            log.warn("Exception occurred while trying to pretty print file " + file, e);
        }
        catch (Throwable t) {
            log.debug("Exception occurred while trying to pretty print file " + file, t);
        }
    }
}

