/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.util.MultipleEntryHashMap;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaUtil {
    private static final Log log = LogFactory.getLog(SchemaUtil.class);

    public static XmlSchema[] getAllSchemas(XmlSchema schema) {
        HashMap map = new HashMap();
        SchemaUtil.traverseSchemas(schema, map);
        return map.values().toArray(new XmlSchema[map.values().size()]);
    }

    private static void traverseSchemas(XmlSchema schema, HashMap map) {
        String key = schema.getTargetNamespace() + ":" + schema.getSourceURI();
        if (map.containsKey(key)) {
            return;
        }
        map.put(key, schema);
        XmlSchemaObjectCollection includes = schema.getIncludes();
        if (includes != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                XmlSchema schema1;
                Object o = tempIterator.next();
                if (o instanceof XmlSchemaImport && (schema1 = ((XmlSchemaImport)o).getSchema()) != null) {
                    SchemaUtil.traverseSchemas(schema1, map);
                }
                if (!(o instanceof XmlSchemaInclude) || (schema1 = ((XmlSchemaInclude)o).getSchema()) == null) continue;
                SchemaUtil.traverseSchemas(schema1, map);
            }
        }
    }

    public static SOAPEnvelope handleMediaTypeURLEncoded(MessageContext msgCtxt, HttpServletRequest request, XmlSchemaElement xmlSchemaElement, SOAPFactory soapFactory) throws AxisFault {
        SOAPEnvelope soapEnvelope;
        block12: {
            XmlSchemaComplexType complexType2;
            XmlSchemaParticle particle2;
            Map requestParameterMap;
            AxisBindingOperation axisBindingOperation;
            String queryParameterSeparator;
            SOAPBody body;
            block11: {
                soapEnvelope = soapFactory.getDefaultEnvelope();
                body = soapEnvelope.getBody();
                queryParameterSeparator = null;
                axisBindingOperation = (AxisBindingOperation)msgCtxt.getProperty("AxisBindingOperation");
                if (axisBindingOperation != null) {
                    queryParameterSeparator = (String)axisBindingOperation.getProperty("whttp:queryParameterSeparator");
                }
                requestParameterMap = SchemaUtil.getParameterMap(request, queryParameterSeparator);
                if (xmlSchemaElement != null) break block11;
                OMElement bodyFirstChild = soapFactory.createOMElement(msgCtxt.getAxisOperation().getName(), body);
                if (requestParameterMap == null) break block12;
                Iterator requestParamMapIter = requestParameterMap.keySet().iterator();
                while (requestParamMapIter.hasNext()) {
                    String key = (String)requestParamMapIter.next();
                    String value = (String)((Object[])requestParameterMap.get(key))[0];
                    soapFactory.createOMElement(key, null, bodyFirstChild).setText(value);
                }
                break block12;
            }
            String targetNamespace = xmlSchemaElement.getQName().getNamespaceURI();
            QName bodyFirstChildQName = targetNamespace != null && !"".equals(targetNamespace) ? new QName(targetNamespace, xmlSchemaElement.getName()) : new QName(xmlSchemaElement.getName());
            OMElement bodyFirstChild = soapFactory.createOMElement(bodyFirstChildQName, body);
            XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
            if (schemaType instanceof XmlSchemaComplexType && (particle2 = (complexType2 = (XmlSchemaComplexType)schemaType).getParticle()) instanceof XmlSchemaSequence) {
                XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)particle2;
                Iterator iterator = xmlSchemaSequence.getItems().getIterator();
                MultipleEntryHashMap httpLocationParameterMap = new MultipleEntryHashMap();
                if (axisBindingOperation != null) {
                    String httpLocation = (String)axisBindingOperation.getProperty("whttp:location");
                    httpLocationParameterMap = SchemaUtil.createHttpLocationParameterMap(httpLocation, queryParameterSeparator, request, requestParameterMap);
                }
                while (iterator.hasNext()) {
                    XmlSchemaElement innerElement = (XmlSchemaElement)iterator.next();
                    QName qName = innerElement.getQName();
                    boolean nillable = innerElement.isNillable();
                    for (long minOccurs = innerElement.getMinOccurs(); minOccurs != 0L; --minOccurs) {
                        OMNamespace ns;
                        String name = qName != null ? qName.getLocalPart() : innerElement.getName();
                        String value = (String)httpLocationParameterMap.get(name);
                        OMNamespace oMNamespace = ns = qName == null || qName.getNamespaceURI() == null || qName.getNamespaceURI().length() == 0 ? null : soapFactory.createOMNamespace(qName.getNamespaceURI(), null);
                        if (value == null) {
                            String[] parameterValuesArray = (String[])requestParameterMap.get(name);
                            if (parameterValuesArray != null && !"".equals(parameterValuesArray[0]) && parameterValuesArray[0] != null) {
                                value = parameterValuesArray[0];
                                for (int i = 0; i < parameterValuesArray.length; ++i) {
                                    soapFactory.createOMElement(name, ns, bodyFirstChild).setText(parameterValuesArray[i]);
                                }
                            }
                        } else {
                            soapFactory.createOMElement(name, ns, bodyFirstChild).setText(value);
                        }
                        if (value != null) continue;
                        if (nillable) {
                            OMNamespace xsi = soapFactory.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
                            OMAttribute omAttribute = soapFactory.createOMAttribute("nil", xsi, "true");
                            soapFactory.createOMElement(name, ns, bodyFirstChild).addAttribute(omAttribute);
                            continue;
                        }
                        throw new AxisFault("Required element " + qName + " defined in the schema can not be found in the request");
                    }
                }
            }
        }
        return soapEnvelope;
    }

    protected static MultipleEntryHashMap createHttpLocationParameterMap(String httpLocation, String queryParameterSeparator, HttpServletRequest request, Map parameterMap) throws AxisFault {
        MultipleEntryHashMap httpLocationParameterMap = new MultipleEntryHashMap();
        if (httpLocation != null) {
            String[] urlParts = httpLocation.split("\\?");
            String templatedPath = urlParts[0];
            if (urlParts.length > 1) {
                String templatedQueryParams = urlParts[1];
                SchemaUtil.extractParametersFromQueryPart(templatedQueryParams, queryParameterSeparator, httpLocationParameterMap, parameterMap);
            }
            SchemaUtil.extractParametersFromPath(templatedPath, httpLocationParameterMap, request.getRequestURI());
        }
        return httpLocationParameterMap;
    }

    protected static void extractParametersFromQueryPart(String templatedQueryParams, String queryParameterSeparator, MultipleEntryHashMap httpLocationParameterMap, Map parameterMap) {
        String[] nameValuePairs = templatedQueryParams.split(queryParameterSeparator);
        for (int i = 0; i < nameValuePairs.length; ++i) {
            String value;
            StringBuffer buffer = new StringBuffer(nameValuePairs[i]);
            if (buffer.indexOf("{") <= 0 || buffer.indexOf("}") <= 0) continue;
            String parameterName = buffer.substring(0, buffer.indexOf("="));
            String schemaElementName = buffer.substring(buffer.indexOf("=") + 2, buffer.length() - 1);
            String[] parameterValues = (String[])parameterMap.get(parameterName);
            if (parameterValues == null || (value = parameterValues[0]) == null) continue;
            httpLocationParameterMap.put(schemaElementName, value);
        }
    }

    protected static void extractParametersFromPath(String templatedPath, MultipleEntryHashMap httpLocationParameterMap, String requestURL) throws AxisFault {
        if (templatedPath != null && !"".equals(templatedPath) && templatedPath.indexOf("{") > -1) {
            StringBuffer requestURIBuffer;
            StringBuffer pathTemplate = new StringBuffer(templatedPath);
            int startIndex = 0;
            int templateStartIndex = 0;
            int templateEndIndex = 0;
            int indexOfNextConstant = 0;
            try {
                requestURIBuffer = new StringBuffer(URLDecoder.decode(requestURL, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("Could not decode the query String in the HttpServletRequest");
                throw new AxisFault("Could not decode the query String in the HttpServletRequest");
            }
            while (startIndex < requestURIBuffer.length()) {
                if ((templateStartIndex = pathTemplate.indexOf("{", templateStartIndex)) <= 0) continue;
                String constantPart = pathTemplate.substring(templateEndIndex + 1, templateStartIndex);
                templateEndIndex = pathTemplate.indexOf("}", templateStartIndex);
                String parameterName = pathTemplate.substring(templateStartIndex + 1, templateEndIndex);
                templateStartIndex = pathTemplate.indexOf("{", templateEndIndex);
                int endIndexOfConstant = requestURIBuffer.indexOf(constantPart, indexOfNextConstant) + constantPart.length();
                if (templateEndIndex == pathTemplate.length() - 1 || templateStartIndex == -1) {
                    constantPart = pathTemplate.substring(templateEndIndex + 1, pathTemplate.length());
                    indexOfNextConstant = requestURIBuffer.indexOf(constantPart, endIndexOfConstant);
                    httpLocationParameterMap.put(parameterName, requestURIBuffer.substring(endIndexOfConstant, indexOfNextConstant));
                    startIndex = requestURIBuffer.length();
                    continue;
                }
                constantPart = pathTemplate.substring(templateEndIndex + 1, templateStartIndex);
                indexOfNextConstant = requestURIBuffer.indexOf(constantPart, endIndexOfConstant);
                httpLocationParameterMap.put(parameterName, requestURIBuffer.substring(endIndexOfConstant, indexOfNextConstant));
                startIndex = indexOfNextConstant;
            }
        }
    }

    private static Map getParameterMap(HttpServletRequest request, String queryParamSeparator) throws AxisFault {
        String contentType;
        String encodedQueryString = request.getQueryString();
        Map<String, String[]> parameterMap = new HashMap();
        if (encodedQueryString != null) {
            String queryString;
            try {
                queryString = URLDecoder.decode(encodedQueryString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("Could not decode the query String in the HttpServletRequest");
                throw new AxisFault("Could not decode the query String in the HttpServletRequest");
            }
            if (queryParamSeparator == null || queryParamSeparator.equals("&")) {
                parameterMap = HttpUtils.parseQueryString(queryString);
            } else {
                String[] parts = queryString.split(queryParamSeparator);
                for (int i = 0; i < parts.length; ++i) {
                    int separator = parts[i].indexOf("=");
                    String[] value = new String[]{parts[i].substring(separator + 1)};
                    parameterMap.put(parts[i].substring(0, separator), value);
                }
            }
        }
        if ((contentType = request.getContentType()) != null && contentType.indexOf("multipart/form-data") > -1) {
            ServletRequestContext servletRequestContext = new ServletRequestContext(request);
            try {
                List items = SchemaUtil.parseRequest(servletRequestContext);
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    String[] value = new String[1];
                    DiskFileItem diskFileItem = (DiskFileItem)iter.next();
                    value[0] = diskFileItem.getString();
                    parameterMap.put(diskFileItem.getFieldName(), value);
                }
            }
            catch (FileUploadException e) {
                log.error("Unable to extract data from Multipart request");
                throw new AxisFault("Unable to extract data from Multipart request");
            }
        } else {
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String paramName = (String)enumeration.nextElement();
                if (parameterMap.get(paramName) != null) continue;
                parameterMap.put(paramName, request.getParameterValues(paramName));
            }
        }
        return parameterMap;
    }

    private static List parseRequest(ServletRequestContext requestContext) throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload(factory);
        return upload.parseRequest(requestContext);
    }
}

