/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.apache.woden.internal.util.dom.DOM2Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolicyUtil {
    protected static final Log log = LogFactory.getLog(PolicyUtil.class);

    public static String getSafeString(String unsafeString) {
        StringBuffer sbuf = new StringBuffer();
        char[] chars = unsafeString.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    sbuf.append('\\');
                    sbuf.append('\\');
                    continue block6;
                }
                case '\"': {
                    sbuf.append('\\');
                    sbuf.append('\"');
                    continue block6;
                }
                case '\n': {
                    sbuf.append('\\');
                    sbuf.append('n');
                    continue block6;
                }
                case '\r': {
                    sbuf.append('\\');
                    sbuf.append('r');
                    continue block6;
                }
                default: {
                    sbuf.append(c);
                }
            }
        }
        return sbuf.toString();
    }

    public static OMElement getPolicyComponentAsOMElement(PolicyComponent policyComponent, ExternalPolicySerializer externalPolicySerializer) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (policyComponent instanceof Policy) {
            externalPolicySerializer.serialize((Policy)policyComponent, baos);
        } else {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
            policyComponent.serialize(writer);
            writer.flush();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return (OMElement)XMLUtils.toOM(bais);
    }

    public static OMElement getPolicyComponentAsOMElement(PolicyComponent component) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
        component.serialize(writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return (OMElement)XMLUtils.toOM(bais);
    }

    public static PolicyComponent getPolicyComponentFromOMElement(OMElement policyComponent) throws IllegalArgumentException {
        if (policyComponent instanceof Policy) {
            return PolicyEngine.getPolicy(policyComponent);
        }
        if (policyComponent instanceof PolicyReference) {
            return PolicyEngine.getPolicyReference(policyComponent);
        }
        throw new IllegalArgumentException("Agrument is neither a <wsp:Policy> nor a <wsp:PolicyReference> element");
    }

    public static PolicyComponent getPolicyComponent(Element element) {
        try {
            if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(element.getNamespaceURI())) {
                if ("Policy".equals(element.getLocalName())) {
                    String xmlString = DOM2Writer.nodeToString((Node)element);
                    ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                    return PolicyEngine.getPolicy(bais);
                }
                if ("PolicyReference".equals(element.getLocalName())) {
                    String xmlString = DOM2Writer.nodeToString((Node)element);
                    ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                    return PolicyEngine.getPolicyReferene(bais);
                }
            }
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("An error occurred while processing policy elements in the WSDL. These elements will be ignored and processing of the WSDL will continue");
                log.debug("Policy element processing error: " + t.toString());
            }
            return null;
        }
        throw new IllegalArgumentException("Agrument is neither a <wsp:Policy> nor a <wsp:PolicyReference> element");
    }

    public static String policyComponentToString(PolicyComponent policyComponent) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
        policyComponent.serialize(writer);
        writer.flush();
        return baos.toString();
    }

    public static String generateId(AxisDescription description) {
        PolicyInclude policyInclude = description.getPolicyInclude();
        String identifier = "-policy-1";
        if (description instanceof AxisMessage) {
            identifier = "msg-" + ((AxisMessage)description).getName() + identifier;
            description = description.getParent();
        }
        if (description instanceof AxisOperation) {
            identifier = "op-" + ((AxisOperation)description).getName() + identifier;
            description = description.getParent();
        }
        if (description instanceof AxisService) {
            identifier = "service-" + ((AxisService)description).getName() + identifier;
        }
        int index = 49;
        while (policyInclude.getPolicy(identifier) != null) {
            identifier = identifier.replace((char)index, (char)(index + 1));
            ++index;
        }
        return identifier;
    }
}

