/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;

public class MetaDataEntry
implements Externalizable,
SafeSerializable {
    private static final long serialVersionUID = 8978361069526299875L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    private String className = null;
    private String qnameAsString = null;
    private String extraName = null;
    private ArrayList list = null;
    public static String END_OF_LIST = "LAST_ENTRY";
    private static final String UNSUPPORTED_SUID = "Serialization version ID is not supported.";
    private static final String UNSUPPORTED_REVID = "Revision ID is not supported.";

    public MetaDataEntry() {
    }

    public MetaDataEntry(String c, String n) {
        this.className = c;
        this.qnameAsString = n;
    }

    public MetaDataEntry(String c, String n, String e) {
        this.className = c;
        this.qnameAsString = n;
        this.extraName = e;
    }

    public MetaDataEntry(String c, String n, ArrayList l) {
        this.className = c;
        this.qnameAsString = n;
        this.list = l;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String c) {
        this.className = c;
    }

    public QName getQName() {
        if (this.qnameAsString != null) {
            return QName.valueOf(this.qnameAsString);
        }
        return null;
    }

    public void setQName(QName q) {
        this.qnameAsString = q != null ? q.toString() : null;
    }

    public void setQName(String n) {
        this.qnameAsString = n;
    }

    public String getQNameAsString() {
        return this.qnameAsString;
    }

    public String getName() {
        return this.qnameAsString;
    }

    public String getExtraName() {
        return this.extraName;
    }

    public void setExtraName(String e) {
        this.extraName = e;
    }

    public boolean isListEmpty() {
        if (this.list == null) {
            return true;
        }
        return this.list.isEmpty();
    }

    public ArrayList getList() {
        return this.list;
    }

    public void setList(ArrayList L) {
        this.list = L;
    }

    public void addToList(MetaDataEntry e) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(e);
    }

    public void removeList() {
        this.list = null;
    }

    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeLong(8978361069526299875L);
        out.writeInt(2);
        out.writeObject(this.className);
        out.writeObject(this.qnameAsString);
        out.writeObject(this.extraName);
        out.writeList(this.list);
    }

    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != 8978361069526299875L) {
            throw new ClassNotFoundException(UNSUPPORTED_SUID);
        }
        if (revID != 2) {
            throw new ClassNotFoundException(UNSUPPORTED_REVID);
        }
        this.className = (String)in.readObject();
        this.qnameAsString = (String)in.readObject();
        this.extraName = (String)in.readObject();
        this.list = in.readArrayList();
    }
}

