/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallbackReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(CallbackReceiver.class);
    public static String SERVICE_NAME = "ClientService";
    private Map callbackStore = new ConcurrentHashMap();

    public void addCallback(String MsgID, Callback callback) {
        this.callbackStore.put(MsgID, callback);
    }

    public Callback lookupCallback(String msgID) {
        return (Callback)this.callbackStore.get(msgID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageContext messageCtx) throws AxisFault {
        RelatesTo relatesTO = messageCtx.getOptions().getRelatesTo();
        if (relatesTO == null) {
            throw new AxisFault("Cannot identify correct Callback object. RelatesTo is null");
        }
        String messageID = relatesTO.getValue();
        Callback callback = (Callback)this.callbackStore.get(messageID);
        AsyncResult result = new AsyncResult(messageCtx);
        if (callback != null) {
            try {
                SOAPEnvelope envelope = result.getResponseEnvelope();
                SOAPFault fault = envelope.getBody().getFault();
                if (fault == null) {
                    callback.onComplete(result);
                }
                AxisFault axisFault = Utils.getInboundFaultFromMessageContext(messageCtx);
                callback.onError(axisFault);
            }
            finally {
                callback.setComplete(true);
                Object obj = this.callbackStore.remove(messageID);
                if (obj != null && log.isDebugEnabled()) {
                    log.debug("Removing object from callback store: " + obj + " because of RelatesTo value: " + messageID);
                }
                obj = null;
            }
        } else {
            throw new AxisFault("The Callback related to MessageID " + messageID + " is not found");
        }
    }

    public Map getCallbackStore() {
        return this.callbackStore;
    }
}

