/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.mail.PasswordAuthentication;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.transport.mail.EMailSender;
import org.apache.axis2.transport.mail.MailToInfo;
import org.apache.axis2.util.Utils;

public class MailTransportSender
extends AbstractHandler
implements TransportSender {
    private final Properties smtpProperties = new Properties();
    private PasswordAuthentication passwordAuthentication;
    private ByteArrayOutputStream byteArrayOutputStream;
    private final OMOutputFormat format = new OMOutputFormat();
    private final MailToInfo mailToInfo = new MailToInfo();
    private static final String NAME = "MailTransportSender";

    public MailTransportSender() {
        this.init(new HandlerDescription(NAME));
    }

    public void init(ConfigurationContext configurationContext, TransportOutDescription transportOut) throws AxisFault {
        ArrayList mailParameters = transportOut.getParameters();
        String password = "";
        String username = "";
        Iterator iterator = mailParameters.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            String paramKey = param.getName();
            String paramValue = Utils.getParameterValue(param);
            if (paramKey == null || paramValue == null) {
                throw new AxisFault(Messages.getMessage("canNotBeNull", "Parameter name and value"));
            }
            this.smtpProperties.setProperty(paramKey, paramValue);
            if (paramKey.equals("mail.smtp.user")) {
                username = paramValue;
            }
            if (paramKey.equals("transport.mail.smtp.password")) {
                password = paramValue;
            }
            if (!paramKey.equals("transport.mail.replyToAddress")) continue;
            this.mailToInfo.setFromAddress(paramValue);
        }
        this.passwordAuthentication = new PasswordAuthentication(username, password);
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    private void runtimeMailParameterSetting(MessageContext msgContext) {
        Object obj = msgContext.getProperty("_MAIL_SMTP_");
        if (obj != null && obj instanceof HttpTransportProperties.MailProperties) {
            HttpTransportProperties.MailProperties props = (HttpTransportProperties.MailProperties)obj;
            this.smtpProperties.clear();
            this.smtpProperties.putAll((Map<?, ?>)props.getProperties());
            String username = (String)this.smtpProperties.get("mail.smtp.user");
            String passwd = props.getPassword();
            this.passwordAuthentication = new PasswordAuthentication(username, passwd);
        }
    }

    public void sendMimeMessage(MessageContext msgContext) throws AxisFault {
        try {
            this.runtimeMailParameterSetting(msgContext);
            EMailSender sender = new EMailSender();
            sender.setOutputStream(this.byteArrayOutputStream);
            sender.setMessageContext(msgContext);
            sender.setProperties(this.smtpProperties);
            sender.setPasswordAuthentication(this.passwordAuthentication);
            String charSet = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSet == null) {
                charSet = "UTF-8";
            }
            this.format.setSOAP11(msgContext.isSOAP11());
            this.format.setCharSetEncoding(charSet);
            this.parseMailToAddress(msgContext.getTo());
            sender.send(this.mailToInfo, this.format);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    private void parseMailToAddress(EndpointReference epr) {
        String eprAddress = epr.getAddress();
        int mailToIndex = eprAddress.indexOf("mailto:");
        if (mailToIndex > -1) {
            eprAddress = eprAddress.substring(mailToIndex + 7);
        }
        int index = eprAddress.indexOf(63);
        String contentDescription = "";
        boolean xServicePath = false;
        String email = index > -1 ? eprAddress.substring(0, index) : eprAddress;
        if (eprAddress.indexOf("x-service-path".toLowerCase()) > -1) {
            index = eprAddress.indexOf(61);
            if (index > -1) {
                xServicePath = true;
                contentDescription = eprAddress.substring(index + 1);
            }
        } else {
            contentDescription = eprAddress.substring(index + 1);
        }
        this.mailToInfo.setContentDescription(contentDescription);
        this.mailToInfo.setEmailAddress(email);
        this.mailToInfo.setxServicePath(xServicePath);
    }

    public void writeMimeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        SOAPEnvelope envelope = msgContext.getEnvelope();
        OMElement outputMessage = envelope;
        if (envelope != null && msgContext.isDoingREST()) {
            outputMessage = envelope.getBody().getFirstElement();
        }
        if (outputMessage != null) {
            try {
                OMOutputFormat format = new OMOutputFormat();
                format.setDoOptimize(msgContext.isDoingMTOM());
                format.setCharSetEncoding(null);
                outputMessage.serializeAndConsume(out, format);
                out.flush();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            throw new AxisFault(Messages.getMessage("outMessageNull"));
        }
    }

    public void stop() {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
        EndpointReference epr = null;
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            epr = msgContext.getTo();
        }
        if (epr != null) {
            if (!epr.hasNoneAddress()) {
                this.byteArrayOutputStream = new ByteArrayOutputStream();
                this.writeMimeMessage(msgContext, this.byteArrayOutputStream);
                this.sendMimeMessage(msgContext);
            }
        } else if (msgContext.isServerSide()) {
            // empty if block
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

