/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.MailcapCommandMap;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.mail.MailToInfo;
import org.apache.axis2.transport.mail.MimeBase64BodyPart;

public class EMailSender {
    private Properties properties;
    private MessageContext messageContext;
    private PasswordAuthentication passwordAuthentication;
    private OutputStream outputStream;

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setPasswordAuthentication(PasswordAuthentication passwordAuthentication) {
        this.passwordAuthentication = passwordAuthentication;
    }

    public void send(MailToInfo mailToInfo, OMOutputFormat format) throws AxisFault {
        try {
            Session session = Session.getInstance(this.properties, new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return EMailSender.this.passwordAuthentication;
                }
            });
            MimeMessage msg = new MimeMessage(session);
            msg.addRecipient(Message.RecipientType.TO, new InternetAddress(mailToInfo.getEmailAddress()));
            msg.setSubject("__ Axis2/Java Mail Message __");
            if (mailToInfo.isxServicePath()) {
                msg.setHeader("X-Service-Path", "\"" + mailToInfo.getContentDescription() + "\"");
            }
            this.createMailMimeMessage(msg, mailToInfo, format);
            Transport.send(msg);
        }
        catch (AddressException e) {
            throw new AxisFault(e);
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }

    private void createMailMimeMessage(MimeMessage msg, MailToInfo mailToInfo, OMOutputFormat format) throws MessagingException {
        String contentType;
        MimeBase64BodyPart messageBodyPart = new MimeBase64BodyPart();
        messageBodyPart.setText("");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart(messageBodyPart);
        ByteArrayDataSource source = null;
        if (this.outputStream instanceof ByteArrayOutputStream) {
            source = new ByteArrayDataSource(((ByteArrayOutputStream)this.outputStream).toByteArray());
        }
        messageBodyPart = new MimeBase64BodyPart();
        messageBodyPart.setDataHandler(new DataHandler(source));
        messageBodyPart.setDisposition("attachment");
        messageBodyPart.addHeader("Content-Description", "\"" + mailToInfo.getContentDescription() + "\"");
        String string = contentType = format.getContentType() != null ? format.getContentType() : "text/xml";
        if (contentType.indexOf("text/xml") > -1 && this.messageContext.getSoapAction() != null) {
            messageBodyPart.setHeader("mail.soapaction", this.messageContext.getSoapAction());
        }
        if (contentType.indexOf("application/soap+xml") > -1) {
            if (this.messageContext.getSoapAction() != null) {
                messageBodyPart.setHeader("Content-Type", contentType + "; charset=" + format.getCharSetEncoding() + " ; action=\"" + this.messageContext.getSoapAction() + "\"");
            }
        } else {
            messageBodyPart.setHeader("Content-Type", contentType + "; charset=" + format.getCharSetEncoding());
        }
        multipart.addBodyPart(messageBodyPart);
        msg.setContent(multipart);
    }

    static {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("application/soap+xml;;x-java-content-handler=com.sun.mail.handlers.text_xml");
        CommandMap.setDefaultCommandMap(mc);
    }
}

