/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSSender
extends AbstractHandler
implements TransportSender {
    private static final Log log = LogFactory.getLog(JMSSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        log.debug("JMSSender invoke()");
        JMSOutTransportInfo transportInfo = null;
        String targetAddress = null;
        targetAddress = (String)msgContext.getProperty("TransportURL");
        if (targetAddress != null) {
            transportInfo = new JMSOutTransportInfo(targetAddress);
        } else if (targetAddress == null && msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            targetAddress = msgContext.getTo().getAddress();
            if (msgContext.getTo().hasNoneAddress()) return Handler.InvocationResponse.CONTINUE;
            transportInfo = new JMSOutTransportInfo(targetAddress);
        } else if (msgContext.isServerSide()) {
            transportInfo = (JMSOutTransportInfo)msgContext.getProperty("OutTransportInfo");
        }
        boolean waitForResponse = false;
        Object seprLisn = msgContext.getProperty("IsUsingSeparateListener");
        if (Boolean.TRUE.equals(seprLisn)) {
            waitForResponse = false;
        } else if (!msgContext.isServerSide()) {
            waitForResponse = !msgContext.getOptions().isUseSeparateListener();
        }
        ConnectionFactory connectionFac = transportInfo.getConnectionFactory();
        Connection con = null;
        try {
            con = connectionFac.createConnection();
            Session session = con.createSession(false, 1);
            Message message = this.createJMSMessage(msgContext, session);
            Destination dest = transportInfo.getDestination();
            if (dest == null) {
                String name = JMSUtils.getDestination(targetAddress);
                try {
                    dest = session.createQueue(name);
                }
                catch (JMSException e) {
                    JMSSender.handleException("Error creating destination Queue : " + name, e);
                }
            }
            MessageProducer producer = session.createProducer(dest);
            TemporaryQueue replyDest = null;
            if (waitForResponse) {
                try {
                    replyDest = session.createTemporaryQueue();
                    message.setJMSReplyTo(replyDest);
                }
                catch (JMSException e) {
                    JMSSender.handleException("Error creating temporary queue for response");
                }
            }
            try {
                log.debug("[" + (msgContext.isServerSide() ? "Server" : "Client") + "]Sending message to destination : " + dest);
                producer.send(message);
                producer.close();
            }
            catch (JMSException e) {
                JMSSender.handleException("Error sending JMS message to destination : " + dest.toString(), e);
            }
            if (!waitForResponse) return Handler.InvocationResponse.CONTINUE;
            try {
                MessageConsumer consumer = session.createConsumer(replyDest);
                long timeout = 30000L;
                Long waitReply = (Long)msgContext.getProperty("JMS_WAIT_REPLY");
                if (waitReply != null) {
                    timeout = waitReply;
                }
                log.debug("Waiting for a maximum of " + timeout + "ms for a response message to destination : " + replyDest);
                con.start();
                Message reply = consumer.receive(timeout);
                if (reply != null) {
                    msgContext.setProperty("TRANSPORT_IN", JMSUtils.getInputStream(reply));
                    return Handler.InvocationResponse.CONTINUE;
                }
                log.warn("Did not receive a JMS response within " + timeout + " ms to destination : " + dest);
                return Handler.InvocationResponse.CONTINUE;
            }
            catch (JMSException e) {
                JMSSender.handleException("Error reading response from temporary queue : " + replyDest, e);
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (JMSException e) {
            JMSSender.handleException("Error preparing to send message to destination", e);
            return Handler.InvocationResponse.CONTINUE;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (JMSException e) {}
            }
        }
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }

    private Message createJMSMessage(MessageContext msgContext, Session session) throws JMSException {
        Message message = null;
        String msgType = this.getProperty(msgContext, "JMS_MESSAGE_TYPE");
        OMElement msgElement = msgContext.getEnvelope();
        if (msgContext.isDoingREST()) {
            msgElement = msgContext.getEnvelope().getBody().getFirstElement();
        }
        if (msgType != null && "JMS_BYTE_MESSAGE".equals(msgType)) {
            message = session.createBytesMessage();
            BytesMessage bytesMsg = (BytesMessage)message;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OMOutputFormat format = new OMOutputFormat();
            format.setCharSetEncoding(this.getProperty(msgContext, "CHARACTER_SET_ENCODING"));
            format.setDoOptimize(msgContext.isDoingMTOM());
            try {
                msgElement.serializeAndConsume(baos, format);
                baos.flush();
            }
            catch (XMLStreamException e) {
                JMSSender.handleException("XML serialization error creating BytesMessage", e);
            }
            catch (IOException e) {
                JMSSender.handleException("IO Error while creating BytesMessage", e);
            }
            bytesMsg.writeBytes(baos.toByteArray());
        } else {
            message = session.createTextMessage();
            TextMessage txtMsg = message;
            txtMsg.setText(((Object)msgElement).toString());
        }
        String correlationId = this.getProperty(msgContext, "JMS_COORELATION_ID");
        if (correlationId != null) {
            message.setJMSCorrelationID(correlationId);
        }
        if (msgContext.isServerSide()) {
            this.setProperty(message, msgContext, "SOAPAction");
            this.setProperty(message, msgContext, "contentType");
        } else {
            String action = msgContext.getOptions().getAction();
            if (action != null) {
                message.setStringProperty("SOAPAction", action);
            }
        }
        return message;
    }

    private void setProperty(Message message, MessageContext msgCtx, String key) {
        String value = this.getProperty(msgCtx, key);
        if (value != null) {
            try {
                message.setStringProperty(key, value);
            }
            catch (JMSException e) {
                log.warn("Couldn't set message property : " + key + " = " + value, e);
            }
        }
    }

    private String getProperty(MessageContext mc, String key) {
        return (String)mc.getProperty(key);
    }

    private static void handleException(String s) {
        log.error(s);
        throw new AxisJMSException(s);
    }

    private static void handleException(String s, Exception e) {
        log.error(s, e);
        throw new AxisJMSException(s, e);
    }
}

