/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.InputStream;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSConstants;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSMessageReceiver
implements MessageListener {
    private static final Log log = LogFactory.getLog(JMSMessageReceiver.class);
    private Executor workerPool = null;
    private ConfigurationContext axisConf = null;
    private JMSConnectionFactory jmsConFac = null;

    JMSMessageReceiver(JMSConnectionFactory jmsConFac, Executor workerPool, ConfigurationContext axisConf) {
        this.jmsConFac = jmsConFac;
        this.workerPool = workerPool;
        this.axisConf = axisConf;
    }

    public ConfigurationContext getAxisConf() {
        return this.axisConf;
    }

    public void setWorkerPool(Executor workerPool) {
        this.workerPool = workerPool;
    }

    public void onMessage(Message message) {
        try {
            log.debug("Received JMS message to destination : " + message.getJMSDestination());
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        this.workerPool.execute(new Worker(message));
    }

    private MessageContext createMessageContext(Message message) {
        InputStream in = JMSUtils.getInputStream(message);
        try {
            String provider;
            MessageContext msgContext = ContextFactory.createMessageContext(this.axisConf);
            Destination dest = message.getJMSDestination();
            String destinationName = null;
            if (dest instanceof Queue) {
                destinationName = ((Queue)dest).getQueueName();
            } else if (dest instanceof Topic) {
                destinationName = ((Topic)dest).getTopicName();
            }
            String serviceName = this.jmsConFac.getServiceNameForDestination(destinationName);
            if (serviceName == null && (provider = (String)this.jmsConFac.getProperties().get("java.naming.factory.initial")).indexOf("activemq") != -1) {
                serviceName = this.jmsConFac.getServiceNameForDestination((dest instanceof Queue ? "dynamicQueues/" : "dynamicTopics/") + destinationName);
            }
            if (serviceName != null) {
                msgContext.setAxisService(this.axisConf.getAxisConfiguration().getService(serviceName));
            }
            msgContext.setIncomingTransportName("jms");
            msgContext.setTransportIn(this.axisConf.getAxisConfiguration().getTransportIn(JMSConstants.JMS_QNAME));
            msgContext.setTransportOut(this.axisConf.getAxisConfiguration().getTransportOut(JMSConstants.JMS_QNAME));
            msgContext.setProperty("OutTransportInfo", new JMSOutTransportInfo(this.jmsConFac.getConFactory(), message.getJMSReplyTo()));
            msgContext.setServerSide(true);
            msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
            String soapAction = JMSUtils.getProperty(message, "SOAPAction");
            if (soapAction != null) {
                msgContext.setSoapAction(soapAction);
            }
            msgContext.setEnvelope(JMSUtils.getSOAPEnvelope(message, msgContext, in));
            return msgContext;
        }
        catch (JMSException e) {
            this.handleException("JMS Exception reading the destination name", e);
        }
        catch (AxisFault e) {
            this.handleException("Axis fault creating the MessageContext", e);
        }
        catch (XMLStreamException e) {
            this.handleException("Error reading the SOAP envelope", e);
        }
        return null;
    }

    private void handleException(String msg, Exception e) {
        log.error(msg, e);
        throw new AxisJMSException(msg, e);
    }

    class Worker
    implements Runnable {
        private Message message = null;

        Worker(Message message) {
            this.message = message;
        }

        public void run() {
            MessageContext msgCtx = JMSMessageReceiver.this.createMessageContext(this.message);
            AxisEngine engine2 = new AxisEngine(msgCtx.getConfigurationContext());
            try {
                log.debug("Delegating JMS message for processing to the Axis engine");
                if (msgCtx.getEnvelope().getBody().hasFault()) {
                    engine2.receiveFault(msgCtx);
                } else {
                    engine2.receive(msgCtx);
                }
            }
            catch (AxisFault af) {
                log.error("JMS Worker [" + Thread.currentThread().getName() + "] Encountered an Axis Fault : " + af.getMessage(), af);
            }
        }
    }
}

