/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.util.JavaUtils;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;

public class URLTemplatingUtil {
    private static String applyURITemplating(MessageContext messageContext, String rawURLString, boolean detach) throws AxisFault {
        OMElement firstElement = detach ? messageContext.getEnvelope().getBody().getFirstElement() : messageContext.getEnvelope().getBody().getFirstElement().cloneOMElement();
        HTTPLocation httpLocation = new HTTPLocation(rawURLString);
        String[] localNames = httpLocation.getLocalNames();
        String[] values = new String[localNames.length];
        for (int i = 0; i < localNames.length; ++i) {
            String localName = localNames[i];
            try {
                values[i] = URLEncoder.encode(URLTemplatingUtil.getOMElementValue(localName, firstElement), "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new AxisFault("Unable to encode Query String");
            }
        }
        httpLocation.substitute(values);
        return httpLocation.toString();
    }

    private static String appendQueryParameters(MessageContext messageContext, String query) {
        String queryParameterSeparator = (String)messageContext.getProperty("whttp:queryParameterSeparator");
        if (queryParameterSeparator == null) {
            queryParameterSeparator = WSDL20DefaultValueHolder.getDefaultValue("whttp:queryParameterSeparator");
        }
        OMElement firstElement = messageContext.getEnvelope().getBody().getFirstElement();
        ArrayList<String> values = new ArrayList<String>();
        if (firstElement != null) {
            Iterator iter = firstElement.getChildElements();
            while (iter.hasNext()) {
                OMElement element = (OMElement)iter.next();
                values.add(element.getLocalName() + "=" + element.getText());
            }
        }
        if (values.size() > 0) {
            query = query.indexOf("?") == query.length() - 1 ? query + values.get(0) : query + "?" + values.get(0);
            for (int i = 1; i < values.size(); ++i) {
                query = query + queryParameterSeparator + values.get(i);
            }
        }
        return query;
    }

    private static String getOMElementValue(String elementName, OMElement parentElement) {
        OMElement httpURLParam = parentElement.getFirstChildWithName(new QName(elementName));
        if (httpURLParam != null) {
            httpURLParam.detach();
            if (parentElement.getFirstOMChild() == null) {
                parentElement.detach();
            }
        }
        return httpURLParam.getText();
    }

    public static URL getTemplatedURL(URL targetURL, MessageContext messageContext, boolean detach) throws AxisFault {
        String urlString = targetURL.toString();
        String replacedQuery = "";
        String path = "";
        int separator = urlString.indexOf(123);
        if (separator > 0) {
            path = urlString.substring(0, separator - 1);
            String query = urlString.substring(separator - 1);
            replacedQuery = URLTemplatingUtil.applyURITemplating(messageContext, query, detach);
            try {
                targetURL = new URL(path + replacedQuery);
            }
            catch (MalformedURLException e) {
                throw new AxisFault("An error occured while trying to create request URL");
            }
        }
        return targetURL;
    }

    public static URL appendParametersToURL(MessageContext messageContext, URL targetURL) throws AxisFault {
        String url = targetURL.toString();
        String ignoreUncited = (String)messageContext.getProperty("whttp:ignoreUncited");
        if (ignoreUncited == null || !JavaUtils.isTrueExplicitly(ignoreUncited)) {
            url = URLTemplatingUtil.appendQueryParameters(messageContext, url);
            try {
                targetURL = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new AxisFault("Unable to create target URL from template");
            }
        } else if ("GET".equalsIgnoreCase((String)messageContext.getProperty("HTTP_METHOD"))) {
            messageContext.getEnvelope().getBody().getFirstElement().detach();
        }
        return targetURL;
    }
}

