/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.HTTPLocationBasedDispatcher;
import org.apache.axis2.engine.RequestURIBasedDispatcher;
import org.apache.axis2.engine.RequestURIOperationDispatcher;
import org.apache.axis2.engine.SOAPActionBasedDispatcher;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.SchemaUtil;
import org.apache.ws.commons.schema.XmlSchemaElement;

public class RESTUtil {
    protected ConfigurationContext configurationContext;

    public RESTUtil(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public boolean processPostRequest(MessageContext msgContext, HttpServletRequest request, HttpServletResponse response) throws AxisFault {
        try {
            SOAPEnvelope soapEnvelope;
            String contentType = request.getContentType();
            if ("".equals(contentType) || contentType == null) {
                throw new AxisFault("ContentType should be given to proceed, according to WSDL 2.0 HTTP binding rules");
            }
            if (contentType.indexOf("text/xml") > -1 || contentType.indexOf("multipart/related") > -1 || contentType.indexOf("application/xml") > -1) {
                soapEnvelope = this.handleNonURLEncodedContentTypes(msgContext, request, OMAbstractFactory.getSOAP12Factory());
            } else if (contentType.indexOf("application/x-www-form-urlencoded") > -1 || contentType.indexOf("multipart/form-data") > -1) {
                this.dispatchAndVerify(msgContext);
                AxisOperation axisOperation = msgContext.getAxisOperation();
                XmlSchemaElement xmlSchemaElement = axisOperation.getMessage("In").getSchemaElement();
                soapEnvelope = SchemaUtil.handleMediaTypeURLEncoded(msgContext, request, xmlSchemaElement, OMAbstractFactory.getSOAP12Factory());
            } else {
                throw new AxisFault("Content type should be one of /n text/xml/n application/x-www-form-urlencoded/n application/xml/n multipart/related");
            }
            msgContext.setEnvelope(soapEnvelope);
            msgContext.setProperty("HTTP_METHOD_OBJECT", "POST");
            msgContext.setProperty("ContentType", contentType);
            msgContext.setDoingREST(true);
            msgContext.setProperty("TRANSPORT_OUT", response.getOutputStream());
            this.invokeAxisEngine(msgContext);
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (IOException ioException) {
            throw new AxisFault(ioException);
        }
        return true;
    }

    public boolean processGetRequest(MessageContext msgContext, HttpServletRequest request, HttpServletResponse response) throws AxisFault {
        try {
            int index;
            String contentType = request.getContentType();
            if (contentType != null && (index = contentType.indexOf("action")) > -1) {
                String transientString = contentType.substring(index, contentType.length());
                int equal = transientString.indexOf("=");
                int firstSemiColon = transientString.indexOf(";");
                String soapAction = firstSemiColon > -1 ? transientString.substring(equal + 1, firstSemiColon) : transientString.substring(equal + 1, transientString.length());
                if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                    soapAction = soapAction.substring(1, soapAction.length() - 1);
                }
                msgContext.setSoapAction(soapAction);
            }
            msgContext.setDoingREST(true);
            msgContext.setProperty("TRANSPORT_OUT", response.getOutputStream());
            this.dispatchAndVerify(msgContext);
            AxisOperation axisOperation = msgContext.getAxisOperation();
            XmlSchemaElement xmlSchemaElement = null;
            if (axisOperation != null) {
                AxisMessage axisMessage = axisOperation.getMessage("In");
                xmlSchemaElement = axisMessage.getSchemaElement();
            }
            SOAPEnvelope soapEnvelope = SchemaUtil.handleMediaTypeURLEncoded(msgContext, request, xmlSchemaElement, OMAbstractFactory.getSOAP12Factory());
            msgContext.setEnvelope(soapEnvelope);
            this.invokeAxisEngine(msgContext);
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
        return true;
    }

    private void invokeAxisEngine(MessageContext messageContext) throws AxisFault {
        AxisEngine axisEngine = new AxisEngine(this.configurationContext);
        axisEngine.receive(messageContext);
    }

    private void dispatchAndVerify(MessageContext msgContext) throws AxisFault {
        RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();
        requestDispatcher.invoke(msgContext);
        AxisService axisService = msgContext.getAxisService();
        if (axisService != null) {
            AxisOperation axisOperation;
            RequestURIOperationDispatcher requestURIOperationDispatcher = new RequestURIOperationDispatcher();
            requestURIOperationDispatcher.invoke(msgContext);
            if (msgContext.getAxisOperation() == null) {
                HTTPLocationBasedDispatcher httpLocationBasedDispatcher = new HTTPLocationBasedDispatcher();
                httpLocationBasedDispatcher.invoke(msgContext);
            }
            if (msgContext.getAxisOperation() == null) {
                SOAPActionBasedDispatcher soapActionBasedDispatcher = new SOAPActionBasedDispatcher();
                soapActionBasedDispatcher.invoke(msgContext);
            }
            if ((axisOperation = msgContext.getAxisOperation()) != null) {
                AxisEndpoint axisEndpoint = (AxisEndpoint)msgContext.getProperty("endpoint");
                if (axisEndpoint != null) {
                    AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisEndpoint.getBinding().getChild(axisOperation.getName());
                    msgContext.setProperty("AxisBindingOperation", axisBindingOperation);
                }
                msgContext.setAxisOperation(axisOperation);
            }
            if (msgContext.getAxisOperation() == null) {
                throw new AxisFault("I can not find a service for this request to be serviced. Check the WSDL and the request URI");
            }
        } else {
            throw new AxisFault("I can not find a service for this request to be serviced. Check the WSDL and the request URI");
        }
    }

    private SOAPEnvelope handleNonURLEncodedContentTypes(MessageContext msgCtxt, HttpServletRequest request, SOAPFactory soapFactory) throws AxisFault {
        try {
            String contentType;
            SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
            SOAPBody body = soapEnvelope.getBody();
            FilterInputStream inputStream = new BufferedInputStream(request.getInputStream());
            Map headers = (Map)msgCtxt.getProperty("TRANSPORT_HEADERS");
            if (headers != null && ("gzip".equals(headers.get("Content-Encoding")) || "gzip".equals(headers.get(HTTPConstants.HEADER_CONTENT_ENCODING_LOWERCASE)))) {
                inputStream = new GZIPInputStream(inputStream);
            }
            if (this.checkContentType("multipart/related", contentType = request.getContentType())) {
                body.addChild(BuilderUtil.getAttachmentsBuilder(msgCtxt, inputStream, contentType, false).getDocumentElement());
            } else if (this.checkContentType("text/xml", contentType) || this.checkContentType("application/xml", contentType)) {
                String charSetEnc = BuilderUtil.getCharSetEncoding(contentType);
                if (charSetEnc == null) {
                    charSetEnc = "UTF-8";
                }
                msgCtxt.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
                if (request.getContentLength() != 0) {
                    StAXBuilder builder = BuilderUtil.getPOXBuilder(inputStream, charSetEnc);
                    OMNodeEx documentElement = (OMNodeEx)((Object)builder.getDocumentElement());
                    documentElement.setParent(null);
                    body.addChild(documentElement);
                }
            }
            return soapEnvelope;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AxisFault("Error in creating a SOAPEnvelope from the REST request");
        }
    }

    private boolean checkContentType(String contentType, String contentTypeStringFromRequest) {
        if (contentTypeStringFromRequest == null) {
            return false;
        }
        return contentTypeStringFromRequest.indexOf(contentType) > -1;
    }

    public static String getConstantFromHTTPLocation(String httpLocation) {
        int index;
        if (httpLocation.charAt(0) != '?') {
            httpLocation = "/" + httpLocation;
        }
        if ((index = httpLocation.indexOf("{")) > -1) {
            httpLocation = httpLocation.substring(0, index);
        }
        return httpLocation;
    }
}

