/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

public class LoggingProcessorDecorator
implements HttpProcessor {
    private static final Log HEADERLOG = LogFactory.getLog("org.apache.axis2.transport.http.server.wire");
    private final HttpProcessor httpProcessor;

    public LoggingProcessorDecorator(HttpProcessor httpProcessor) {
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        this.httpProcessor = httpProcessor;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        this.httpProcessor.process(request, context);
        if (HEADERLOG.isDebugEnabled()) {
            HEADERLOG.debug(">> " + request.getRequestLine().toString());
            Header[] headers = request.getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                HEADERLOG.debug(">> " + headers[i].toString());
            }
        }
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        this.httpProcessor.process(response, context);
        if (HEADERLOG.isDebugEnabled()) {
            HEADERLOG.debug("<< " + response.getStatusLine().toString());
            Header[] headers = response.getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                HEADERLOG.debug("<< " + headers[i].toString());
            }
        }
    }
}

