/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.axis2.transport.http.server.ConnectionListenerFailureHandler;
import org.apache.axis2.transport.http.server.DefaultConnectionListenerFailureHandler;
import org.apache.axis2.transport.http.server.HttpConnectionFactory;
import org.apache.axis2.transport.http.server.HttpConnectionManager;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpServerConnection;

public class DefaultConnectionListener
implements IOProcessor {
    private static Log LOG = LogFactory.getLog(DefaultConnectionListener.class);
    private volatile boolean destroyed = false;
    private final int port;
    private final HttpConnectionFactory connfactory;
    private final HttpConnectionManager connmanager;
    private ServerSocket serversocket = null;
    private final ConnectionListenerFailureHandler failureHandler;

    public DefaultConnectionListener(int port, HttpConnectionFactory connfactory, HttpConnectionManager connmanager) throws IOException {
        this(port, connfactory, connmanager, new DefaultConnectionListenerFailureHandler());
    }

    public DefaultConnectionListener(int port, HttpConnectionFactory connfactory, HttpConnectionManager connmanager, ConnectionListenerFailureHandler failureHandler) throws IOException {
        if (connfactory == null) {
            throw new IllegalArgumentException("Connection factory may not be null");
        }
        if (connmanager == null) {
            throw new IllegalArgumentException("Connection manager may not be null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("Failure handler may not be null");
        }
        this.port = port;
        this.connmanager = connmanager;
        this.connfactory = connfactory;
        this.failureHandler = failureHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!Thread.interrupted()) {
                try {
                    if (this.serversocket == null || this.serversocket.isClosed()) {
                        this.serversocket = new ServerSocket(this.port);
                        this.serversocket.setReuseAddress(true);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Listening on port " + this.serversocket.getLocalPort());
                        }
                    }
                    LOG.debug("Waiting for incoming HTTP connection");
                    Socket socket = this.serversocket.accept();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Incoming HTTP connection from " + socket.getRemoteSocketAddress());
                    }
                    HttpServerConnection conn = this.connfactory.newConnection(socket);
                    this.connmanager.process(conn);
                }
                catch (Throwable ex) {
                    if (Thread.interrupted()) {
                    } else if (this.failureHandler.failed(this, ex)) continue;
                    break;
                }
            }
        }
        finally {
            this.destroy();
        }
    }

    public void close() throws IOException {
        if (this.serversocket != null) {
            this.serversocket.close();
        }
    }

    public void destroy() {
        block2: {
            this.destroyed = true;
            try {
                this.close();
            }
            catch (IOException ex) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("I/O error closing listener", ex);
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }
}

