/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.server.OutputBuffer;
import org.apache.axis2.transport.http.server.SessionManager;
import org.apache.axis2.transport.http.server.Worker;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.HttpVersion;
import org.apache.http.RequestLine;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpService;

public class AxisHttpService
extends HttpService {
    private static final Log LOG = LogFactory.getLog(AxisHttpService.class);
    private final MessageContext msgContext;
    private final ConfigurationContext configurationContext;
    private final SessionManager sessionManager;
    private final Worker worker;

    public AxisHttpService(HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, ConfigurationContext configurationContext, SessionManager sessionManager, Worker worker) {
        super(httpProcessor, connStrategy, responseFactory);
        if (worker == null) {
            throw new IllegalArgumentException("Worker may not be null");
        }
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context may not be null");
        }
        if (sessionManager == null) {
            throw new IllegalArgumentException("Session manager may not be null");
        }
        this.configurationContext = configurationContext;
        this.sessionManager = sessionManager;
        this.worker = worker;
        this.msgContext = ContextFactory.createMessageContext(configurationContext);
        this.msgContext.setIncomingTransportName("http");
    }

    protected void doService(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        block12: {
            HttpVersion ver;
            RequestLine reqline = request.getRequestLine();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request method: " + reqline.getMethod());
                LOG.debug("Target URI: " + reqline.getUri());
            }
            if (!(ver = reqline.getHttpVersion()).lessEquals(HttpVersion.HTTP_1_1)) {
                throw new UnsupportedHttpVersionException("Unsupported HTTP version: " + ver);
            }
            try {
                TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut(new QName("http"));
                TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn(new QName("http"));
                String sessionKey = (String)context.getAttribute("Cookie");
                this.msgContext.setTransportIn(transportIn);
                this.msgContext.setTransportOut(transportOut);
                this.msgContext.setServerSide(true);
                this.msgContext.setProperty("Cookie", sessionKey);
                this.msgContext.setProperty("TransportInURL", reqline.getUri());
                HashMap<String, String> headerMap = new HashMap<String, String>();
                Iterator it = request.headerIterator();
                while (it.hasNext()) {
                    Header header = (Header)it.next();
                    headerMap.put(header.getName(), header.getValue());
                }
                this.msgContext.setProperty("TRANSPORT_HEADERS", headerMap);
                this.worker.service(request, response, this.msgContext);
            }
            catch (SocketException ex) {
                throw ex;
            }
            catch (HttpException ex) {
                throw ex;
            }
            catch (Throwable e) {
                try {
                    AxisEngine engine2 = new AxisEngine(this.configurationContext);
                    OutputBuffer outbuffer = new OutputBuffer();
                    this.msgContext.setProperty("TRANSPORT_OUT", outbuffer.getOutputStream());
                    this.msgContext.setProperty("OutTransportInfo", outbuffer);
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(this.msgContext, e);
                    if (AddressingHelper.isFaultRedirected(this.msgContext)) {
                        response.setStatusLine(new BasicStatusLine(ver, 202, "Accepted"));
                    } else {
                        response.setStatusLine(new BasicStatusLine(ver, 500, "Internal server error"));
                    }
                    engine2.sendFault(faultContext);
                    response.setEntity(outbuffer);
                }
                catch (Exception ex) {
                    if (AddressingHelper.isFaultRedirected(this.msgContext)) {
                        response.setStatusLine(new BasicStatusLine(ver, 202, "Accepted"));
                        break block12;
                    }
                    response.setStatusLine(new BasicStatusLine(ver, 500, "Internal server error"));
                    String msg = ex.getMessage();
                    StringEntity entity = msg != null && msg.trim().length() != 0 ? new StringEntity(msg) : new StringEntity("Exception message unknown");
                    entity.setContentType("text/plain");
                    response.setEntity(entity);
                }
            }
        }
    }

    public void handleRequest(HttpServerConnection conn, HttpContext context) throws IOException, HttpException {
        if (conn instanceof HttpInetConnection) {
            HttpInetConnection inetconn = (HttpInetConnection)((Object)conn);
            InetAddress address = inetconn.getRemoteAddress();
            this.msgContext.setProperty("REMOTE_ADDR", address.getHostAddress());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remote address of the connection : " + address);
            }
        }
        super.handleRequest(conn, context);
    }
}

