/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(SOAPMessageFormatter.class);

    public void writeTo(MessageContext msgCtxt, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("start writeTo()");
            log.debug("  preserve=" + preserve);
            log.debug("  isOptimized=" + format.isOptimized());
            log.debug("  isDoingSWA=" + format.isDoingSWA());
        }
        SOAPEnvelope element = msgCtxt.getEnvelope();
        try {
            if (!format.isOptimized() & format.isDoingSWA()) {
                StringWriter bufferedSOAPBody = new StringWriter();
                if (preserve) {
                    element.serialize(bufferedSOAPBody, format);
                } else {
                    element.serializeAndConsume(bufferedSOAPBody, format);
                }
                this.writeSwAMessage(msgCtxt, bufferedSOAPBody, out, format);
            } else if (preserve) {
                element.serialize(out, format);
            } else {
                element.serializeAndConsume(out, format);
            }
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("end writeTo()");
            }
        }
    }

    public byte[] getBytes(MessageContext msgCtxt, OMOutputFormat format) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("start getBytes()");
            log.debug("  isOptimized=" + format.isOptimized());
            log.debug("  isDoingSWA=" + format.isDoingSWA());
        }
        SOAPEnvelope element = msgCtxt.getEnvelope();
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            if (!format.isOptimized()) {
                if (format.isDoingSWA()) {
                    OMOutputFormat format2 = new OMOutputFormat();
                    format2.setCharSetEncoding(format.getCharSetEncoding());
                    StringWriter bufferedSOAPBody = new StringWriter();
                    element.serializeAndConsume(bufferedSOAPBody, format2);
                    this.writeSwAMessage(msgCtxt, bufferedSOAPBody, bytesOut, format);
                } else {
                    element.serializeAndConsume(bytesOut, format);
                }
                byte[] byArray = bytesOut.toByteArray();
                return byArray;
            }
            element.serializeAndConsume(bytesOut, format);
            byte[] byArray = bytesOut.toByteArray();
            return byArray;
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw new AxisFault(e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("end getBytes()");
            }
        }
    }

    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String encoding = format.getCharSetEncoding();
        String contentType = format.getContentType();
        if (log.isDebugEnabled()) {
            log.debug("contentType from the OMOutputFormat =" + contentType);
        }
        if (encoding != null && contentType != null && !contentType.contains("multipart/related")) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (!(msgCtxt.isSOAP11() || soapActionString == null || "".equals(soapActionString.trim()) || "\"\"".equals(soapActionString.trim()))) {
            contentType = contentType + ";action=\"" + soapActionString + "\"";
        }
        if ((contentType = contentType.trim()).lastIndexOf(";") == contentType.length() - 1) {
            contentType = contentType.substring(0, contentType.length() - 1);
        }
        if (log.isDebugEnabled()) {
            log.debug("contentType returned =" + contentType);
        }
        return contentType;
    }

    public String formatSOAPAction(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        if (msgCtxt.isSOAP11()) {
            if ("".equals(soapActionString)) {
                return "\"\"";
            }
            if (soapActionString != null && !soapActionString.startsWith("\"")) {
                soapActionString = "\"" + soapActionString + "\"";
            }
            return soapActionString;
        }
        return null;
    }

    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, msgCtxt, false);
        return targetURL;
    }

    private void writeSwAMessage(MessageContext msgCtxt, StringWriter bufferedSOAPBody, OutputStream outputStream, OMOutputFormat format) {
        if (log.isDebugEnabled()) {
            log.debug("start writeSwAMessage()");
        }
        Object property = msgCtxt.getProperty("MM7Compatible");
        boolean MM7CompatMode = false;
        if (property != null) {
            MM7CompatMode = JavaUtils.isTrueExplicitly(property);
        }
        if (!MM7CompatMode) {
            MIMEOutputUtils.writeSOAPWithAttachmentsMessage(bufferedSOAPBody, outputStream, msgCtxt.getAttachmentMap(), format);
        } else {
            Object innerBoundaryProperty = msgCtxt.getProperty("MM7InnerBoundary");
            String innerBoundary = innerBoundaryProperty != null ? (String)innerBoundaryProperty : "innerBoundary" + UUIDGenerator.getUUID().replace(':', '_');
            Object partCIDProperty = msgCtxt.getProperty("MM7PartCID");
            String partCID = partCIDProperty != null ? (String)partCIDProperty : "innerCID" + UUIDGenerator.getUUID().replace(':', '_');
            MIMEOutputUtils.writeMM7Message(bufferedSOAPBody, outputStream, msgCtxt.getAttachmentMap(), format, partCID, innerBoundary);
        }
        if (log.isDebugEnabled()) {
            log.debug("end writeSwAMessage()");
        }
    }
}

