/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.transport.http.server.OutputBuffer;
import org.apache.axis2.transport.http.server.Worker;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicStatusLine;
import org.apache.ws.commons.schema.XmlSchema;

public class HTTPWorker
implements Worker {
    public void service(HttpRequest request, HttpResponse response, MessageContext msgContext) throws HttpException, IOException {
        OutputBuffer outbuffer;
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        final String servicePath = configurationContext.getServiceContextPath();
        String contextPath = (servicePath.startsWith("/") ? servicePath : "/" + servicePath) + "/";
        HttpVersion ver = request.getRequestLine().getHttpVersion();
        String uri = request.getRequestLine().getUri();
        String method = request.getRequestLine().getMethod();
        String soapAction = HttpUtils.getSoapAction(request);
        if (method.equals("GET")) {
            AxisService service;
            HashMap services;
            String serviceName;
            if (uri.equals("/favicon.ico")) {
                response.setStatusLine(new BasicStatusLine(ver, 301, "Redirect"));
                response.addHeader(new BasicHeader("Location", "http://ws.apache.org/favicon.ico"));
                return;
            }
            if (!uri.startsWith(contextPath)) {
                response.setStatusLine(new BasicStatusLine(ver, 301, "Redirect"));
                response.addHeader(new BasicHeader("Location", contextPath));
                return;
            }
            if (uri.indexOf("?") < 0 && !uri.endsWith(contextPath) && (serviceName = uri.replaceAll(contextPath, "")).indexOf("/") < 0) {
                String res = HTTPTransportReceiver.printServiceHTML(serviceName, configurationContext);
                StringEntity entity = new StringEntity(res);
                entity.setContentType("text/html");
                response.setEntity(entity);
                return;
            }
            if (uri.endsWith("?wsdl2")) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 6);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName);
                if (service != null) {
                    final String ip = this.getHostAddress(request);
                    EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                        public void writeTo(OutputStream outstream) throws IOException {
                            service.printWSDL2(outstream, ip, servicePath);
                        }
                    });
                    entity.setContentType("text/xml");
                    response.setEntity(entity);
                    return;
                }
            }
            if (uri.endsWith("?wsdl")) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 5);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName);
                if (service != null) {
                    final String ip = this.getHostAddress(request);
                    EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                        public void writeTo(OutputStream outstream) throws IOException {
                            service.printWSDL(outstream, ip, servicePath);
                        }
                    });
                    entity.setContentType("text/xml");
                    response.setEntity(entity);
                    return;
                }
            }
            if (uri.endsWith("?xsd")) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 4);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName);
                if (service != null) {
                    EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                        public void writeTo(OutputStream outstream) throws IOException {
                            service.printSchema(outstream);
                        }
                    });
                    entity.setContentType("text/xml");
                    response.setEntity(entity);
                    return;
                }
            }
            if (uri.indexOf("?xsd=") > 0) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.lastIndexOf("?xsd="));
                String schemaName = uri.substring(uri.lastIndexOf("=") + 1);
                HashMap services2 = configurationContext.getAxisConfiguration().getServices();
                AxisService service2 = (AxisService)services2.get(serviceName);
                if (service2 != null) {
                    service2.populateSchemaMappings();
                    Map schemaTable = service2.getSchemaMappingTable();
                    final XmlSchema schema = (XmlSchema)schemaTable.get(schemaName);
                    if (schema != null) {
                        EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                            public void writeTo(OutputStream outstream) {
                                schema.write(outstream);
                            }
                        });
                        entity.setContentType("text/xml");
                        response.setEntity(entity);
                        return;
                    }
                    response.setStatusLine(new BasicStatusLine(ver, 404, "Schema Not Found!"));
                    return;
                }
            }
            outbuffer = new OutputBuffer();
            msgContext.setProperty("TRANSPORT_OUT", outbuffer);
            msgContext.setProperty("OutTransportInfo", outbuffer);
            boolean processed = HTTPTransportUtils.processHTTPGetRequest(msgContext, outbuffer.getOutputStream(), soapAction, uri, configurationContext, HTTPTransportReceiver.getGetRequestParameters(uri));
            if (processed) {
                response.setEntity(outbuffer);
            } else {
                response.setStatusLine(new BasicStatusLine(ver, 200, "OK"));
                String s = HTTPTransportReceiver.getServicesHTML(configurationContext);
                StringEntity entity = new StringEntity(s);
                entity.setContentType("text/html");
                response.setEntity(entity);
            }
        } else if (method.equals("POST")) {
            outbuffer = new OutputBuffer();
            msgContext.setProperty("TRANSPORT_OUT", outbuffer);
            msgContext.setProperty("OutTransportInfo", outbuffer);
            SimpleHTTPRequestResponseTransport requestResponseTransportControl = new SimpleHTTPRequestResponseTransport();
            msgContext.setProperty("RequestResponseTransportControl", requestResponseTransportControl);
            HttpEntity inentity = ((HttpEntityEnclosingRequest)request).getEntity();
            String contenttype = null;
            if (inentity.getContentType() != null) {
                contenttype = inentity.getContentType().getValue();
            }
            msgContext.setProperty("ContentType", contenttype);
            Handler.InvocationResponse pi = HTTPTransportUtils.processHTTPPostRequest(msgContext, inentity.getContent(), outbuffer.getOutputStream(), contenttype, soapAction, uri);
            Boolean holdResponse = (Boolean)msgContext.getProperty("HoldResponse");
            if (pi.equals(Handler.InvocationResponse.SUSPEND) || holdResponse != null && Boolean.TRUE.equals(holdResponse)) {
                try {
                    requestResponseTransportControl.awaitResponse();
                }
                catch (InterruptedException e) {
                    throw new IOException("We were interrupted, so this may not function correctly:" + e.getMessage());
                }
            }
            response.setEntity(outbuffer);
        } else {
            throw new MethodNotSupportedException(method + " method not supported");
        }
        RequestResponseTransport requestResponseTransportControl = (RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl");
        if (TransportUtils.isResponseWritten(msgContext) || requestResponseTransportControl != null && requestResponseTransportControl.getStatus().equals(RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED)) {
            response.setStatusLine(new BasicStatusLine(ver, 200, "OK"));
        } else {
            response.setStatusLine(new BasicStatusLine(ver, 202, "OK"));
        }
    }

    public String getHostAddress(HttpRequest request) throws SocketException {
        try {
            Header hostHeader = request.getFirstHeader("host");
            if (hostHeader != null) {
                String host = hostHeader.getValue();
                return new URI("http://" + host).getHost();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return HttpUtils.getIpAddress();
    }

    class SimpleHTTPRequestResponseTransport
    implements RequestResponseTransport {
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        private boolean responseWritten = false;
        RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;

        SimpleHTTPRequestResponseTransport() {
        }

        public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            this.responseReadySignal.countDown();
        }

        public void awaitResponse() throws InterruptedException {
            this.responseReadySignal.await();
        }

        public void signalResponseReady() {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public boolean isResponseWritten() {
            return this.responseWritten;
        }

        public void setResponseWritten(boolean responseWritten) {
            this.responseWritten = responseWritten;
        }
    }
}

