/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;

public class HTTPTransportUtils {
    private static final int VERSION_UNKNOWN = 0;
    private static final int VERSION_SOAP11 = 1;
    private static final int VERSION_SOAP12 = 2;

    public static SOAPEnvelope createEnvelopeFromGetRequest(String requestUrl, Map map, ConfigurationContext configCtx) throws AxisFault {
        String[] values = Utils.parseRequestURLForServiceAndOperation(requestUrl, configCtx.getServiceContextPath());
        if (values == null) {
            return new SOAP11Factory().getDefaultEnvelope();
        }
        if (values[1] != null && values[0] != null) {
            String srvice = values[0];
            AxisService service = configCtx.getAxisConfiguration().getService(srvice);
            if (service == null) {
                throw new AxisFault("service not found: " + srvice);
            }
            String operation = values[1];
            SOAP11Factory soapFactory = new SOAP11Factory();
            SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
            OMNamespace omNs = soapFactory.createOMNamespace(service.getSchematargetNamespace(), service.getSchematargetNamespacePrefix());
            soapFactory.createOMNamespace(service.getSchematargetNamespace(), service.getSchematargetNamespacePrefix());
            OMElement opElement = soapFactory.createOMElement(operation, omNs);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                String value = (String)map.get(name);
                OMElement omEle = soapFactory.createOMElement(name, omNs);
                omEle.setText(value);
                opElement.addChild(omEle);
            }
            envelope.getBody().addChild(opElement);
            return envelope;
        }
        return null;
    }

    public static boolean doWriteMTOM(MessageContext msgContext) {
        Object property;
        boolean enableMTOM = false;
        Parameter parameter = msgContext.getParameter("enableMTOM");
        if (parameter != null) {
            enableMTOM = JavaUtils.isTrueExplicitly(parameter.getValue());
        }
        if ((property = msgContext.getProperty("enableMTOM")) != null) {
            enableMTOM = JavaUtils.isTrueExplicitly(property);
        }
        return enableMTOM;
    }

    public static boolean doWriteSwA(MessageContext msgContext) {
        Object property;
        boolean enableSwA = false;
        Parameter parameter = msgContext.getParameter("enableSwA");
        if (parameter != null) {
            enableSwA = JavaUtils.isTrueExplicitly(parameter.getValue());
        }
        if ((property = msgContext.getProperty("enableSwA")) != null) {
            enableSwA = JavaUtils.isTrueExplicitly(property);
        }
        return enableSwA;
    }

    public static String getCharSetEncoding(MessageContext msgContext) {
        String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charSetEnc == null) {
            OperationContext opctx = msgContext.getOperationContext();
            if (opctx != null) {
                charSetEnc = (String)opctx.getProperty("CHARACTER_SET_ENCODING");
            }
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
        }
        return charSetEnc;
    }

    public static boolean processHTTPGetRequest(MessageContext msgContext, OutputStream out, String soapAction, String requestURI, ConfigurationContext configurationContext, Map requestParameters) throws AxisFault {
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        msgContext.setSoapAction(soapAction);
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("TRANSPORT_OUT", out);
        msgContext.setServerSide(true);
        SOAPEnvelope envelope = HTTPTransportUtils.createEnvelopeFromGetRequest(requestURI, requestParameters, configurationContext);
        if (envelope == null) {
            return false;
        }
        msgContext.setDoingREST(true);
        msgContext.setEnvelope(envelope);
        AxisEngine engine2 = new AxisEngine(configurationContext);
        engine2.receive(msgContext);
        return true;
    }

    public static Handler.InvocationResponse processHTTPPostRequest(MessageContext msgContext, InputStream in, OutputStream out, String contentType, String soapActionHeader, String requestURI) throws AxisFault {
        int soapVersion = 0;
        Handler.InvocationResponse pi = Handler.InvocationResponse.CONTINUE;
        try {
            Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
            if (headers != null && ("gzip".equals(headers.get("Content-Encoding")) || "gzip".equals(headers.get(HTTPConstants.HEADER_CONTENT_ENCODING_LOWERCASE)))) {
                in = new GZIPInputStream(in);
            }
            if (soapActionHeader != null && soapActionHeader.charAt(0) == '\"' && soapActionHeader.endsWith("\"")) {
                soapActionHeader = soapActionHeader.substring(1, soapActionHeader.length() - 1);
            }
            msgContext.setSoapAction(soapActionHeader);
            msgContext.setTo(new EndpointReference(requestURI));
            msgContext.setProperty("TRANSPORT_OUT", out);
            msgContext.setServerSide(true);
            SOAPEnvelope envelope = null;
            boolean isMIME = false;
            String charSetEnc = BuilderUtil.getCharSetEncoding(contentType);
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            if (contentType != null) {
                if (contentType.indexOf("application/soap+xml") > -1) {
                    soapVersion = 2;
                    HTTPTransportUtils.processContentTypeForAction(contentType, msgContext);
                } else if (contentType.indexOf("text/xml") > -1) {
                    soapVersion = 1;
                } else if (HTTPTransportUtils.isRESTRequest(contentType)) {
                    soapVersion = 1;
                    msgContext.setDoingREST(true);
                }
                if (soapVersion == 1) {
                    Parameter enableREST = msgContext.getParameter("enableREST");
                    if (soapActionHeader == null && enableREST != null && "true".equals(enableREST.getValue())) {
                        msgContext.setDoingREST(true);
                    }
                }
            }
            envelope = TransportUtils.createSOAPMessage(msgContext, in, contentType);
            msgContext.setEnvelope(envelope);
            AxisEngine engine2 = new AxisEngine(msgContext.getConfigurationContext());
            pi = envelope.getBody().hasFault() ? engine2.receiveFault(msgContext) : engine2.receive(msgContext);
            Handler.InvocationResponse invocationResponse = pi;
            return invocationResponse;
        }
        catch (SOAPProcessingException e) {
            throw new AxisFault(e);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
        catch (OMException e) {
            throw new AxisFault(e);
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw new AxisFault(e);
        }
        finally {
            if (msgContext.getEnvelope() == null && soapVersion != 1) {
                msgContext.setEnvelope(new SOAP12Factory().getDefaultEnvelope());
            }
        }
    }

    private static void processContentTypeForAction(String contentType, MessageContext msgContext) {
        int index = contentType.indexOf("action");
        if (index > -1) {
            String transientString = contentType.substring(index, contentType.length());
            int equal = transientString.indexOf("=");
            int firstSemiColon = transientString.indexOf(";");
            String soapAction = firstSemiColon > -1 ? transientString.substring(equal + 1, firstSemiColon) : transientString.substring(equal + 1, transientString.length());
            if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            msgContext.setSoapAction(soapAction);
        }
    }

    public static boolean isDoingREST(MessageContext msgContext) {
        boolean enableREST = false;
        if (msgContext.isDoingREST()) {
            return true;
        }
        Object enableRESTProperty = msgContext.getProperty("enableREST");
        if (enableRESTProperty != null) {
            enableREST = JavaUtils.isTrueExplicitly(enableRESTProperty);
        }
        msgContext.setDoingREST(enableREST);
        return enableREST;
    }

    private static boolean isRESTRequest(String contentType) {
        return contentType == null || contentType.indexOf("application/xml") > -1 || contentType.indexOf("application/x-www-form-urlencoded") > -1 || contentType.indexOf("multipart/form-data") > -1;
    }
}

