/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationXMLFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(ApplicationXMLFormatter.class);

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        return this.getBytes(messageContext, format, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("start getBytes()");
            log.debug("  fault flow=" + (messageContext.getFLOW() == 4));
        }
        try {
            byte[] byArray;
            OMElement omElement;
            if (messageContext.getFLOW() == 4) {
                SOAPFault fault = messageContext.getEnvelope().getBody().getFault();
                SOAPFaultDetail soapFaultDetail = fault.getDetail();
                omElement = soapFaultDetail.getFirstElement();
                if (omElement == null) {
                    omElement = fault.getReason();
                }
            } else {
                omElement = messageContext.getEnvelope().getBody().getFirstElement();
            }
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            if (omElement != null) {
                try {
                    if (preserve) {
                        omElement.serialize(bytesOut, format);
                    } else {
                        omElement.serializeAndConsume(bytesOut, format);
                    }
                }
                catch (XMLStreamException e) {
                    throw new AxisFault(e);
                }
                byArray = bytesOut.toByteArray();
                return byArray;
            }
            byArray = new byte[]{};
            return byArray;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("end getBytes()");
            }
        }
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("start writeTo()");
        }
        try {
            byte[] b = this.getBytes(messageContext, format, preserve);
            if (b != null && b.length > 0) {
                outputStream.write(b);
            } else {
                outputStream.flush();
            }
        }
        catch (IOException e) {
            throw new AxisFault("An error occured while writing the request", e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("end writeTo()");
            }
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String encoding = format.getCharSetEncoding();
        String contentType = (String)messageContext.getProperty("ContentType");
        if (log.isDebugEnabled()) {
            log.debug("contentType set from messageContext =" + contentType);
            log.debug("(NOTE) contentType from format is=" + format.getContentType());
        }
        if (contentType == null) {
            contentType = "application/xml";
        } else if (this.isSOAPContentType(contentType)) {
            contentType = "application/xml";
            if (log.isDebugEnabled()) {
                log.debug("contentType is set incorrectly for Application XML.");
                log.debug("It is changed to " + contentType);
            }
        }
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (soapAction != null && !"".equals(soapAction.trim()) && !"\"\"".equals(soapAction.trim())) {
            contentType = contentType + ";action=\"" + soapAction + "\";";
        }
        if (log.isDebugEnabled()) {
            log.debug("contentType returned =" + contentType);
        }
        return contentType;
    }

    private boolean isSOAPContentType(String contentType) {
        if (JavaUtils.indexOfIgnoreCase(contentType, "application/soap+xml") > -1) {
            return true;
        }
        return JavaUtils.indexOfIgnoreCase(contentType, "text/xml") > -1;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, messageContext, false);
        return targetURL;
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }
}

