/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.CachedFileDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.http.ApplicationXMLFormatter;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.SOAPMessageFormatter;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportUtils {
    private static final Log log = LogFactory.getLog(TransportUtils.class);

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext) throws AxisFault {
        try {
            InputStream inStream = (InputStream)msgContext.getProperty("TRANSPORT_IN");
            msgContext.setProperty("TRANSPORT_IN", null);
            if (inStream == null) {
                throw new AxisFault(Messages.getMessage("inputstreamNull"));
            }
            String contentType = (String)msgContext.getProperty("ContentType");
            String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEnc == null && contentType != null) {
                charSetEnc = BuilderUtil.getCharSetEncoding(contentType);
            } else if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            return TransportUtils.createSOAPMessage(msgContext, inStream, contentType);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (OMException e) {
            throw new AxisFault(e);
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw new AxisFault(e);
        }
    }

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext, InputStream inStream, String contentType) throws AxisFault, OMException, XMLStreamException, FactoryConfigurationError {
        SOAPEnvelope envelope;
        int index;
        Object builder;
        String charSetEnc;
        OMElement documentElement = null;
        String charsetEncoding = null;
        String type = null;
        if (msgContext.isDoingREST()) {
            if (log.isDebugEnabled()) {
                log.debug("createSOAPEnvelope that represents a REST message");
            }
            charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            builder = BuilderUtil.getPOXBuilder(inStream, charSetEnc);
            documentElement = builder.getDocumentElement();
            charsetEncoding = ((StAXBuilder)builder).getDocument().getCharsetEncoding();
        } else if (contentType != null && (builder = BuilderUtil.getBuilderFromSelector(type = (index = contentType.indexOf(59)) > 0 ? contentType.substring(0, index) : contentType, msgContext)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("createSOAPEnvelope using Builder (" + builder.getClass().getCanonicalName() + ") selected from type (" + type + ")");
            }
            documentElement = builder.processDocument(inStream, contentType, msgContext);
        }
        if (documentElement == null) {
            if (log.isDebugEnabled()) {
                log.debug("Could not find a Builder for type (" + type + ") defaulting to SOAP");
            }
            charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            builder = BuilderUtil.getSOAPBuilder(inStream, charSetEnc);
            documentElement = builder.getDocumentElement();
            charsetEncoding = ((StAXBuilder)builder).getDocument().getCharsetEncoding();
        }
        if (documentElement instanceof SOAPEnvelope) {
            envelope = (SOAPEnvelope)documentElement;
        } else {
            SOAP11Factory soapFactory = new SOAP11Factory();
            envelope = soapFactory.getDefaultEnvelope();
            envelope.getBody().addChild(documentElement);
        }
        return envelope;
    }

    public static String getCharSetEncoding(String contentType) {
        int index;
        if (log.isDebugEnabled()) {
            log.debug("Input contentType (" + contentType + ")");
        }
        if ((index = contentType.indexOf(HTTPConstants.CHAR_SET_ENCODING)) == -1) {
            if (log.isDebugEnabled()) {
                log.debug("CharSetEncoding defaulted (UTF-8)");
            }
            return "UTF-8";
        }
        int indexOfEq = contentType.indexOf("=", index);
        int indexOfSemiColon = contentType.indexOf(";", indexOfEq);
        String value = indexOfSemiColon > 0 ? contentType.substring(indexOfEq + 1, indexOfSemiColon) : contentType.substring(indexOfEq + 1, contentType.length()).trim();
        if (value.indexOf(34) != -1) {
            value = value.replaceAll("\"", "");
        }
        value = value.trim();
        if (log.isDebugEnabled()) {
            log.debug("CharSetEncoding from content-type (" + value + ")");
        }
        return value;
    }

    public static void writeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        SOAPEnvelope envelope = msgContext.getEnvelope();
        OMElement outputMessage = envelope;
        if (envelope != null && msgContext.isDoingREST()) {
            outputMessage = envelope.getBody().getFirstElement();
        }
        if (outputMessage != null) {
            try {
                OMOutputFormat format = new OMOutputFormat();
                String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                format.setDoOptimize(false);
                format.setDoingSWA(false);
                format.setCharSetEncoding(charSetEnc);
                outputMessage.serializeAndConsume(out, format);
                out.flush();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            throw new AxisFault(Messages.getMessage("outMessageNull"));
        }
    }

    public static MessageFormatter getMessageFormatter(MessageContext msgContext) throws AxisFault {
        MessageFormatter messageFormatter = null;
        String messageFormatString = TransportUtils.getMessageFormatterProperty(msgContext);
        if (messageFormatString != null) {
            messageFormatter = msgContext.getConfigurationContext().getAxisConfiguration().getMessageFormatter(messageFormatString);
            if (log.isDebugEnabled()) {
                log.debug("MessageFormatter selected from MessageFormatterProperty (" + messageFormatString + ")");
                String formatter = messageFormatter == null ? "null" : messageFormatter.getClass().getCanonicalName();
                log.debug("The MessageFormatter is:" + formatter);
            }
        }
        if (messageFormatter == null) {
            if (msgContext.isDoingREST()) {
                messageFormatter = new ApplicationXMLFormatter();
                if (log.isDebugEnabled()) {
                    log.debug("MessageFormatter for REST processing: " + messageFormatter.getClass().getCanonicalName());
                }
            } else {
                messageFormatter = new SOAPMessageFormatter();
                if (log.isDebugEnabled()) {
                    log.debug("MessageFormatter defaulted to " + messageFormatter.getClass().getCanonicalName());
                }
            }
        }
        return messageFormatter;
    }

    private static String getSOAPNamespaceFromContentType(String contentType, String defaultSOAPNamespace) {
        String returnNS = defaultSOAPNamespace;
        if (contentType != null) {
            if (JavaUtils.indexOfIgnoreCase(contentType, "application/soap+xml") > -1) {
                returnNS = "http://www.w3.org/2003/05/soap-envelope";
            } else if (JavaUtils.indexOfIgnoreCase(contentType, "text/xml") > -1) {
                returnNS = "http://schemas.xmlsoap.org/soap/envelope/";
            }
        }
        if (returnNS == null) {
            if (log.isDebugEnabled()) {
                log.debug("No content-type or \"type=\" parameter was found in the content-type header and no default was specified, thus defaulting to SOAP 1.1.");
            }
            returnNS = "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if (log.isDebugEnabled()) {
            log.debug("content-type: " + contentType);
            log.debug("defaultSOAPNamespace: " + defaultSOAPNamespace);
            log.debug("Returned namespace: " + returnNS);
        }
        return returnNS;
    }

    private static String getMessageFormatterProperty(MessageContext msgContext) {
        Parameter parameter;
        String messageFormatterProperty = null;
        Object property = msgContext.getProperty("messageType");
        if (property != null) {
            messageFormatterProperty = (String)property;
        }
        if (messageFormatterProperty == null && (parameter = msgContext.getParameter("messageType")) != null) {
            messageFormatterProperty = (String)parameter.getValue();
        }
        return messageFormatterProperty;
    }

    public static boolean isResponseWritten(MessageContext messageContext) {
        RequestResponseTransport reqResTransport = TransportUtils.getRequestResponseTransport(messageContext);
        if (reqResTransport != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found RequestResponseTransport returning isResponseWritten()");
            }
            return reqResTransport.isResponseWritten();
        }
        if (log.isDebugEnabled()) {
            log.debug("Did not find RequestResponseTransport returning false from getResponseWritten()");
        }
        return false;
    }

    public static void setResponseWritten(MessageContext messageContext, boolean responseWritten) {
        RequestResponseTransport reqResTransport = TransportUtils.getRequestResponseTransport(messageContext);
        if (reqResTransport != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found RequestResponseTransport setting response written");
            }
            reqResTransport.setResponseWritten(responseWritten);
        } else if (log.isDebugEnabled()) {
            log.debug("Did not find RequestResponseTransport cannot set response written");
        }
    }

    private static RequestResponseTransport getRequestResponseTransport(MessageContext messageContext) {
        try {
            if (messageContext.getProperty("RequestResponseTransportControl") != null) {
                return (RequestResponseTransport)messageContext.getProperty("RequestResponseTransportControl");
            }
            if (messageContext.getOperationContext() != null && messageContext.getOperationContext().getMessageContext("In") != null) {
                return (RequestResponseTransport)messageContext.getOperationContext().getMessageContext("In").getProperty("RequestResponseTransportControl");
            }
            return null;
        }
        catch (AxisFault af) {
            String msg = Messages.getMessage("getMessageContextError", af.toString());
            log.debug(msg);
            return null;
        }
    }

    public static void deleteAttachments(MessageContext msgContext) {
        String[] keys;
        Attachments attachments;
        if (log.isDebugEnabled()) {
            log.debug("Entering deleteAttachments()");
        }
        if ((attachments = msgContext.getAttachmentMap()) != null && (keys = attachments.getAllContentIDs()) != null) {
            String key = null;
            File file = null;
            DataSource dataSource = null;
            for (int i = 0; i < keys.length; ++i) {
                try {
                    key = keys[i];
                    dataSource = attachments.getDataHandler(key).getDataSource();
                    if (!(dataSource instanceof CachedFileDataSource)) continue;
                    file = ((CachedFileDataSource)dataSource).getFile();
                    if (log.isDebugEnabled()) {
                        log.debug("Delete cache attachment file: " + file.getName());
                    }
                    file.delete();
                    continue;
                }
                catch (Exception e) {
                    if (file == null) continue;
                    file.deleteOnExit();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exiting deleteAttachments()");
        }
    }
}

