/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.SchemaConstants;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.axis2.util.SchemaUtil;
import org.apache.axis2.util.URLProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMinExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaPatternFacet;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaCompiler {
    private static final Log log = LogFactory.getLog(SchemaCompiler.class);
    private CompilerOptions options;
    private HashMap processedTypemap;
    private HashMap processedElementMap;
    private HashMap processedAnonymousComplexTypesMap;
    private HashMap processedElementRefMap;
    private HashMap simpleTypesMap;
    private HashMap changedTypeMap;
    private HashMap processedTypeMetaInfoMap;
    private ArrayList processedElementList;
    private List nillableElementList;
    private BeanWriter writer = null;
    private Map baseSchemaTypeMap = null;
    private Map loadedSchemaMap = new HashMap();
    private Map availableSchemaMap = new HashMap();
    private Map loadedSourceURI = new HashMap();
    public static final String ANY_ELEMENT_FIELD_NAME = "extraElement";
    public static final String EXTRA_ATTRIBUTE_FIELD_NAME = "extraAttributes";
    private static int typeCounter = 0;

    public HashMap getProcessedElementMap() {
        return this.processedElementMap;
    }

    public Map getProcessedModelMap() {
        return this.writer.getModelMap();
    }

    public SchemaCompiler(CompilerOptions options) throws SchemaCompilationException {
        this.options = options == null ? new CompilerOptions() : options;
        this.processedTypemap = new HashMap();
        this.processedElementMap = new HashMap();
        this.simpleTypesMap = new HashMap();
        this.processedElementList = new ArrayList();
        this.processedAnonymousComplexTypesMap = new HashMap();
        this.changedTypeMap = new HashMap();
        this.processedTypeMetaInfoMap = new HashMap();
        this.processedElementRefMap = new HashMap();
        this.nillableElementList = new ArrayList();
        this.writer = SchemaPropertyLoader.getBeanWriterInstance();
        this.writer.init(this.options);
        this.baseSchemaTypeMap = SchemaPropertyLoader.getTypeMapperInstance().getTypeMap();
    }

    public void compile(List schemalist) throws SchemaCompilationException {
        try {
            int i;
            if (schemalist.isEmpty()) {
                return;
            }
            this.loadedSchemaMap.clear();
            this.availableSchemaMap.clear();
            for (i = 0; i < schemalist.size(); ++i) {
                XmlSchema schema = (XmlSchema)schemalist.get(i);
                this.availableSchemaMap.put(schema.getTargetNamespace(), schema);
            }
            if (this.writer.getExtensionMapperPackageName() == null) {
                String nsp = null;
                for (int i2 = 0; nsp == null && i2 < schemalist.size() && (nsp = ((XmlSchema)schemalist.get(i2)).getTargetNamespace()) == null; ++i2) {
                    XmlSchema[] schemas = SchemaUtil.getAllSchemas((XmlSchema)schemalist.get(i2));
                    for (int j = 0; schemas != null && j < schemas.length && (nsp = schemas[j].getTargetNamespace()) == null; ++j) {
                    }
                }
                if (nsp == null) {
                    nsp = "org.apache.axis2";
                }
                if (this.options.getNs2PackageMap() != null && this.options.getNs2PackageMap().containsKey(nsp)) {
                    this.writer.registerExtensionMapperPackageName((String)this.options.getNs2PackageMap().get(nsp));
                } else {
                    this.writer.registerExtensionMapperPackageName(URLProcessor.makePackageName(nsp));
                }
            }
            for (i = 0; i < schemalist.size(); ++i) {
                this.compile((XmlSchema)schemalist.get(i), true);
            }
            this.finalizeSchemaCompilation();
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public void compile(XmlSchema schema) throws SchemaCompilationException {
        this.compile(schema, false);
    }

    private void compile(XmlSchema schema, boolean isPartofGroup) throws SchemaCompilationException {
        XmlSchemaObjectCollection includes;
        if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) {
            return;
        }
        if (!isPartofGroup && this.writer.getExtensionMapperPackageName() == null) {
            this.writer.registerExtensionMapperPackageName(URLProcessor.makePackageName(schema.getTargetNamespace()));
        }
        if (!this.loadedSchemaMap.containsKey(schema.getTargetNamespace())) {
            this.loadedSchemaMap.put(schema.getTargetNamespace(), schema);
        }
        if (schema.getSourceURI() != null) {
            String key = schema.getTargetNamespace() + ":" + schema.getSourceURI();
            if (this.loadedSourceURI.containsKey(key)) {
                return;
            }
            this.loadedSourceURI.put(key, key);
        }
        if ((includes = schema.getIncludes()) != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                XmlSchema schema1;
                Object o = tempIterator.next();
                if (o instanceof XmlSchemaImport && (schema1 = ((XmlSchemaImport)o).getSchema()) != null) {
                    this.compile(schema1, isPartofGroup);
                }
                if (!(o instanceof XmlSchemaInclude) || (schema1 = ((XmlSchemaInclude)o).getSchema()) == null) continue;
                this.compile(schema1, isPartofGroup);
            }
        }
        XmlSchemaObjectTable elements = schema.getElements();
        Iterator xmlSchemaElement1Iterator = elements.getValues();
        while (xmlSchemaElement1Iterator.hasNext()) {
            this.processElement((XmlSchemaElement)xmlSchemaElement1Iterator.next(), schema);
        }
        Iterator xmlSchemaElement2Iterator = elements.getValues();
        while (xmlSchemaElement2Iterator.hasNext()) {
            this.writeElement((XmlSchemaElement)xmlSchemaElement2Iterator.next());
        }
        if (this.options.isGenerateAll()) {
            Iterator xmlSchemaTypes2Iterator = schema.getSchemaTypes().getValues();
            while (xmlSchemaTypes2Iterator.hasNext()) {
                XmlSchemaType schemaType = (XmlSchemaType)xmlSchemaTypes2Iterator.next();
                if (this.isAlreadyProcessed(schemaType.getQName())) continue;
                if (schemaType instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType2 = (XmlSchemaComplexType)schemaType;
                    if (complexType2.getName() == null) continue;
                    this.processNamedComplexSchemaType(complexType2, schema);
                    continue;
                }
                if (!(schemaType instanceof XmlSchemaSimpleType)) continue;
                this.processSimpleSchemaType((XmlSchemaSimpleType)schemaType, null, schema, null);
            }
        }
        if (!isPartofGroup) {
            this.finalizeSchemaCompilation();
        }
    }

    private void finalizeSchemaCompilation() throws SchemaCompilationException {
        this.writer.writeExtensionMapper(this.processedTypeMetaInfoMap.values().toArray(new BeanWriterMetaInfoHolder[this.processedTypeMetaInfoMap.size()]));
        if (this.options.isWrapClasses()) {
            this.writer.writeBatch();
        }
    }

    public Properties getCompilerProperties() {
        return SchemaPropertyLoader.getPropertyMap();
    }

    private void writeElement(XmlSchemaElement xsElt) throws SchemaCompilationException {
        QName qName;
        if (this.processedElementMap.containsKey(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        BeanWriterMetaInfoHolder metainf = new BeanWriterMetaInfoHolder();
        if (schemaType != null && schemaType.getName() != null) {
            qName = schemaType.getQName();
            String className = this.findClassName(qName, this.isArray(xsElt));
            if (this.changedTypeMap.containsKey(qName)) {
                metainf.registerMapping(xsElt.getQName(), (QName)this.changedTypeMap.get(qName), className);
            } else {
                metainf.registerMapping(xsElt.getQName(), qName, className);
            }
        } else if (xsElt.getRefName() == null) {
            if (xsElt.getSchemaTypeName() != null) {
                qName = xsElt.getSchemaTypeName();
                String className = this.findClassName(qName, this.isArray(xsElt));
                metainf.registerMapping(xsElt.getQName(), qName, className);
            } else if (schemaType != null) {
                metainf = (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(xsElt);
                metainf.setAnonymous(true);
            } else {
                log.warn(SchemaCompilerMessages.getMessage("schema.elementWithNoType", xsElt.getQName().toString()));
                metainf.registerMapping(xsElt.getQName(), null, this.writer.getDefaultClassName(), 8);
            }
        }
        if (this.nillableElementList.contains(xsElt.getQName())) {
            metainf.registerNillableQName(xsElt.getQName());
        }
        String writtenClassName = this.writer.write(xsElt, (Map)this.processedTypemap, metainf);
        xsElt.addMetaInfo("CLASS_NAME", writtenClassName);
        this.processedElementMap.put(xsElt.getQName(), writtenClassName);
    }

    private void processElement(XmlSchemaElement xsElt, Map innerElementMap, List localNillableList, XmlSchema parentSchema) throws SchemaCompilationException {
        this.processElement(xsElt, false, innerElementMap, localNillableList, parentSchema);
    }

    private void processElement(XmlSchemaElement xsElt, XmlSchema parentSchema) throws SchemaCompilationException {
        this.processElement(xsElt, true, null, null, parentSchema);
    }

    private void processElement(XmlSchemaElement xsElt, boolean isOuter, Map innerElementMap, List localNillableList, XmlSchema parentSchema) throws SchemaCompilationException {
        if (xsElt == null) {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.elementNull"));
        }
        if (isOuter && this.processedElementList.contains(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        if (schemaType != null) {
            this.processSchema(xsElt, schemaType, parentSchema);
            if (!isOuter) {
                if (schemaType.getName() != null) {
                    String className = this.findClassName(schemaType.getQName(), this.isArray(xsElt));
                    innerElementMap.put(xsElt.getQName(), className);
                    schemaType.addMetaInfo("CLASS_NAME", className);
                    if (this.baseSchemaTypeMap.containsValue(className)) {
                        schemaType.addMetaInfo("CLASS_NAME_PRIMITIVE", Boolean.TRUE);
                    }
                } else {
                    QName generatedTypeName = this.generateTypeQName(xsElt.getQName(), parentSchema);
                    if (schemaType instanceof XmlSchemaComplexType) {
                        schemaType.setName(generatedTypeName.getLocalPart());
                        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(schemaType.getQName());
                        this.processedTypemap.put(schemaType.getQName(), fullyQualifiedClassName);
                        BeanWriterMetaInfoHolder metaInfHolder = (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(xsElt);
                        metaInfHolder.setOwnQname(schemaType.getQName());
                        metaInfHolder.setOwnClassName(fullyQualifiedClassName);
                        this.writeComplexType((XmlSchemaComplexType)schemaType, metaInfHolder);
                        this.processedAnonymousComplexTypesMap.remove(xsElt);
                        String className = this.findClassName(schemaType.getQName(), this.isArray(xsElt));
                        innerElementMap.put(xsElt.getQName(), className);
                        xsElt.addMetaInfo("CLASS_NAME", className);
                    } else if (schemaType instanceof XmlSchemaSimpleType) {
                        schemaType.setName(generatedTypeName.getLocalPart());
                        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(schemaType.getQName());
                        this.processedTypemap.put(schemaType.getQName(), fullyQualifiedClassName);
                        BeanWriterMetaInfoHolder metaInfHolder = (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(xsElt);
                        metaInfHolder.setOwnQname(schemaType.getQName());
                        metaInfHolder.setOwnClassName(fullyQualifiedClassName);
                        this.writeSimpleType((XmlSchemaSimpleType)schemaType, metaInfHolder);
                        this.processedAnonymousComplexTypesMap.remove(xsElt);
                        String className = this.findClassName(schemaType.getQName(), this.isArray(xsElt));
                        innerElementMap.put(xsElt.getQName(), className);
                        xsElt.addMetaInfo("CLASS_NAME", className);
                    }
                }
            } else {
                this.processedElementList.add(xsElt.getQName());
            }
        } else if (xsElt.getRefName() != null) {
            if (xsElt.getRefName().equals(SchemaConstants.XSD_SCHEMA)) {
                innerElementMap.put(xsElt.getQName(), this.writer.getDefaultClassName());
                return;
            }
            XmlSchemaElement referencedElement = this.getReferencedElement(parentSchema, xsElt.getRefName());
            if (referencedElement == null) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.referencedElementNotFound", xsElt.getRefName().toString()));
            }
            this.processElement(referencedElement, parentSchema);
            QName referenceEltQName = referencedElement.getQName();
            if (referencedElement.getSchemaTypeName() != null) {
                String javaClassName = this.findClassName(referencedElement.getSchemaTypeName(), false);
                this.processedElementRefMap.put(referenceEltQName, javaClassName);
                referencedElement.addMetaInfo("CLASS_NAME", javaClassName);
            } else {
                QName generatedTypeName = this.generateTypeQName(referenceEltQName, parentSchema);
                XmlSchemaType referenceSchemaType = referencedElement.getSchemaType();
                if (referenceSchemaType instanceof XmlSchemaComplexType) {
                    if (referencedElement.getSchemaTypeName() == null) {
                        referencedElement.setSchemaTypeName(generatedTypeName);
                    }
                    referenceSchemaType.setName(generatedTypeName.getLocalPart());
                    String javaclassName = this.writeComplexType((XmlSchemaComplexType)referenceSchemaType, (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(referencedElement));
                    this.processedTypemap.put(generatedTypeName, javaclassName);
                    this.processedElementRefMap.put(referenceEltQName, javaclassName);
                }
            }
        } else if (xsElt.getSchemaTypeName() != null) {
            QName schemaTypeName = xsElt.getSchemaTypeName();
            XmlSchema currentParentSchema = this.resolveParentSchema(schemaTypeName, parentSchema);
            XmlSchemaType typeByName = this.getType(currentParentSchema, schemaTypeName);
            if (typeByName != null) {
                this.processSchema(xsElt, typeByName, currentParentSchema);
                if (!isOuter) {
                    String className = this.findClassName(schemaTypeName, this.isArray(xsElt));
                    innerElementMap.put(xsElt.getQName(), className);
                } else {
                    this.processedElementList.add(xsElt.getQName());
                }
            } else if (!isOuter) {
                String className = this.findClassName(schemaTypeName, this.isArray(xsElt));
                innerElementMap.put(xsElt.getQName(), className);
            } else {
                this.processedElementList.add(xsElt.getQName());
            }
        }
        if (xsElt.isNillable()) {
            if (isOuter) {
                this.nillableElementList.add(xsElt.getQName());
            } else {
                localNillableList.add(xsElt.getQName());
            }
        }
    }

    private XmlSchema resolveParentSchema(QName schemaTypeName, XmlSchema currentSchema) throws SchemaCompilationException {
        String targetNamespace = schemaTypeName.getNamespaceURI();
        Object loadedSchema = this.loadedSchemaMap.get(targetNamespace);
        if (loadedSchema != null) {
            return (XmlSchema)loadedSchema;
        }
        if (this.availableSchemaMap.containsKey(targetNamespace)) {
            XmlSchema schema = (XmlSchema)this.availableSchemaMap.get(targetNamespace);
            this.compile(schema);
            return schema;
        }
        return currentSchema;
    }

    private QName generateTypeQName(QName referenceEltQName, XmlSchema parentSchema) {
        QName generatedTypeName = new QName(referenceEltQName.getNamespaceURI(), referenceEltQName.getLocalPart() + this.getNextTypeSuffix());
        while (parentSchema.getTypeByName(generatedTypeName) != null) {
            generatedTypeName = new QName(referenceEltQName.getNamespaceURI(), referenceEltQName.getLocalPart() + this.getNextTypeSuffix());
        }
        return generatedTypeName;
    }

    private QName generateAttributeQName(QName attrRefName, XmlSchema parentSchema) {
        if (typeCounter == Integer.MAX_VALUE) {
            typeCounter = 0;
        }
        QName generatedAttrName = new QName(attrRefName.getNamespaceURI(), attrRefName.getLocalPart() + typeCounter++);
        while (parentSchema.getTypeByName(generatedAttrName) != null) {
            generatedAttrName = new QName(attrRefName.getNamespaceURI(), attrRefName.getLocalPart() + typeCounter++);
        }
        return generatedAttrName;
    }

    private boolean isAlreadyProcessed(QName qName) {
        return this.processedTypemap.containsKey(qName) || this.simpleTypesMap.containsKey(qName) || this.baseSchemaTypeMap.containsKey(qName);
    }

    private String findRefClassName(QName name, boolean isArray) {
        String className = null;
        if (this.processedElementRefMap.get(name) != null) {
            className = (String)this.processedElementRefMap.get(name);
            if (isArray) {
                className = className + "[]";
            }
        }
        return className;
    }

    private String findClassName(QName qName, boolean isArray) throws SchemaCompilationException {
        String className;
        if (this.processedTypemap.containsKey(qName)) {
            className = (String)this.processedTypemap.get(qName);
        } else if (this.simpleTypesMap.containsKey(qName)) {
            className = (String)this.simpleTypesMap.get(qName);
        } else if (this.baseSchemaTypeMap.containsKey(qName)) {
            className = (String)this.baseSchemaTypeMap.get(qName);
        } else {
            if (SchemaCompiler.isSOAP_ENC(qName.getNamespaceURI())) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.soapencoding.error", qName.toString()));
            }
            className = this.writer.getDefaultClassName();
            log.warn(SchemaCompilerMessages.getMessage("schema.typeMissing", qName.toString()));
        }
        if (isArray) {
            className = className + "[]";
        }
        return className;
    }

    public static boolean isSOAP_ENC(String s) {
        if (s.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return true;
        }
        return s.equals("http://www.w3.org/2003/05/soap-encoding");
    }

    private void processSchema(XmlSchemaElement xsElt, XmlSchemaType schemaType, XmlSchema parentSchema) throws SchemaCompilationException {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType2 = (XmlSchemaComplexType)schemaType;
            if (complexType2.getName() != null) {
                this.processNamedComplexSchemaType(complexType2, parentSchema);
            } else {
                this.processAnonymousComplexSchemaType(xsElt, complexType2, parentSchema);
            }
        } else if (schemaType instanceof XmlSchemaSimpleType) {
            this.processSimpleSchemaType((XmlSchemaSimpleType)schemaType, xsElt, parentSchema, null);
        }
    }

    private void processAnonymousComplexSchemaType(XmlSchemaElement elt, XmlSchemaComplexType complexType2, XmlSchema parentSchema) throws SchemaCompilationException {
        BeanWriterMetaInfoHolder metaInfHolder = this.processComplexType(complexType2, parentSchema);
        this.processedAnonymousComplexTypesMap.put(elt, metaInfHolder);
    }

    private void processNamedComplexSchemaType(XmlSchemaComplexType complexType2, XmlSchema parentSchema) throws SchemaCompilationException {
        if (this.processedTypemap.containsKey(complexType2.getQName()) || this.baseSchemaTypeMap.containsKey(complexType2.getQName())) {
            return;
        }
        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(complexType2.getQName());
        this.processedTypemap.put(complexType2.getQName(), fullyQualifiedClassName);
        complexType2.addMetaInfo("CLASS_NAME", fullyQualifiedClassName);
        BeanWriterMetaInfoHolder metaInfHolder = this.processComplexType(complexType2, parentSchema);
        metaInfHolder.setOwnQname(complexType2.getQName());
        metaInfHolder.setOwnClassName(fullyQualifiedClassName);
        this.writeComplexType(complexType2, metaInfHolder);
    }

    private String writeComplexType(XmlSchemaComplexType complexType2, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        String javaClassName = this.writer.write(complexType2, (Map)this.processedTypemap, metaInfHolder);
        this.processedTypeMetaInfoMap.put(complexType2.getQName(), metaInfHolder);
        return javaClassName;
    }

    private void writeSimpleType(XmlSchemaSimpleType simpleType2, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        this.writer.write(simpleType2, (Map)this.processedTypemap, metaInfHolder);
        this.processedTypeMetaInfoMap.put(simpleType2.getQName(), metaInfHolder);
    }

    private BeanWriterMetaInfoHolder processComplexType(XmlSchemaComplexType complexType2, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaParticle particle2 = complexType2.getParticle();
        BeanWriterMetaInfoHolder metaInfHolder = new BeanWriterMetaInfoHolder();
        if (particle2 != null) {
            this.processParticle(particle2, metaInfHolder, parentSchema);
        }
        XmlSchemaObjectCollection attribs = complexType2.getAttributes();
        Iterator attribIterator = attribs.getIterator();
        while (attribIterator.hasNext()) {
            Object o = attribIterator.next();
            if (!(o instanceof XmlSchemaAttribute)) continue;
            this.processAttribute((XmlSchemaAttribute)o, metaInfHolder, parentSchema);
        }
        XmlSchemaAnyAttribute anyAtt = complexType2.getAnyAttribute();
        if (anyAtt != null) {
            this.processAnyAttribute(metaInfHolder, anyAtt);
        }
        if (complexType2.getContentModel() != null) {
            this.processContentModel(complexType2.getContentModel(), metaInfHolder, parentSchema);
        }
        return metaInfHolder;
    }

    private void processContentModel(XmlSchemaContentModel content, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        if (content instanceof XmlSchemaComplexContent) {
            this.processComplexContent((XmlSchemaComplexContent)content, metaInfHolder, parentSchema);
        } else if (content instanceof XmlSchemaSimpleContent) {
            this.processSimpleContent((XmlSchemaSimpleContent)content, metaInfHolder, parentSchema);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processComplexContent(XmlSchemaComplexContent complexContent, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaContent content = complexContent.getContent();
        if (content instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)content;
            if (!this.isAlreadyProcessed(extension.getBaseTypeName())) {
                XmlSchemaType type = this.getType(parentSchema, extension.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType2 = (XmlSchemaComplexType)type;
                    if (complexType2.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in extension");
                    this.processNamedComplexSchemaType(complexType2, parentSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type, null, parentSchema, null);
                }
            }
            this.copyMetaInfoHierarchy(metaInfHolder, extension.getBaseTypeName(), parentSchema);
            if (extension.getParticle() != null) {
                this.processParticle(extension.getParticle(), metaInfHolder, parentSchema);
            }
            XmlSchemaObjectCollection attribs = extension.getAttributes();
            Iterator attribIterator = attribs.getIterator();
            while (attribIterator.hasNext()) {
                Object o = attribIterator.next();
                if (!(o instanceof XmlSchemaAttribute)) continue;
                this.processAttribute((XmlSchemaAttribute)o, metaInfHolder, parentSchema);
            }
            XmlSchemaAnyAttribute anyAtt = extension.getAnyAttribute();
            if (anyAtt != null) {
                this.processAnyAttribute(metaInfHolder, anyAtt);
            }
            String className = this.findClassName(extension.getBaseTypeName(), false);
            if (this.writer.getDefaultClassName().equals(className)) return;
            metaInfHolder.setExtension(true);
            metaInfHolder.setExtensionClassName(className);
            return;
        } else {
            if (!(content instanceof XmlSchemaComplexContentRestriction)) return;
            XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)content;
            if (!this.isAlreadyProcessed(restriction.getBaseTypeName())) {
                XmlSchemaType type = this.getType(parentSchema, restriction.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType3 = (XmlSchemaComplexType)type;
                    if (complexType3.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in restriction");
                    this.processNamedComplexSchemaType(complexType3, parentSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    throw new SchemaCompilationException("Not a valid restriction, complex content restriction base type cannot be a simple type.");
                }
            }
            this.copyMetaInfoHierarchy(metaInfHolder, restriction.getBaseTypeName(), parentSchema);
            this.processParticle(restriction.getParticle(), metaInfHolder, parentSchema);
            XmlSchemaObjectCollection attribs = restriction.getAttributes();
            Iterator attribIterator = attribs.getIterator();
            while (attribIterator.hasNext()) {
                Object o = attribIterator.next();
                if (!(o instanceof XmlSchemaAttribute)) continue;
                this.processAttribute((XmlSchemaAttribute)o, metaInfHolder, parentSchema);
            }
            XmlSchemaAnyAttribute anyAtt = restriction.getAnyAttribute();
            if (anyAtt != null) {
                this.processAnyAttribute(metaInfHolder, anyAtt);
            }
            String className = this.findClassName(restriction.getBaseTypeName(), false);
            if (this.writer.getDefaultClassName().equals(className)) return;
            metaInfHolder.setRestriction(true);
            metaInfHolder.setRestrictionClassName(this.findClassName(restriction.getBaseTypeName(), false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyMetaInfoHierarchy(BeanWriterMetaInfoHolder metaInfHolder, QName baseTypeName, XmlSchema parentSchema) throws SchemaCompilationException {
        BeanWriterMetaInfoHolder baseMetaInfoHolder;
        XmlSchemaType type = parentSchema.getTypeByName(baseTypeName);
        if (type == null) {
            type = this.getType(parentSchema, baseTypeName);
        }
        if ((baseMetaInfoHolder = (BeanWriterMetaInfoHolder)this.processedTypeMetaInfoMap.get(baseTypeName)) == null) return;
        if (type instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType2 = (XmlSchemaComplexType)type;
            if (complexType2.getContentModel() != null) {
                XmlSchemaContentModel content = complexType2.getContentModel();
                if (content instanceof XmlSchemaComplexContent) {
                    XmlSchemaComplexContent complexContent = (XmlSchemaComplexContent)content;
                    if (complexContent.getContent() instanceof XmlSchemaComplexContentExtension) {
                        XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)complexContent.getContent();
                        this.copyMetaInfoHierarchy(baseMetaInfoHolder, extension.getBaseTypeName(), parentSchema);
                    } else {
                        if (!(complexContent.getContent() instanceof XmlSchemaComplexContentRestriction)) throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unknowncontenterror"));
                        XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)complexContent.getContent();
                        this.copyMetaInfoHierarchy(baseMetaInfoHolder, restriction.getBaseTypeName(), parentSchema);
                    }
                } else {
                    if (!(content instanceof XmlSchemaSimpleContent)) throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unknowncontenterror"));
                    throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Content"));
                }
            }
            metaInfHolder.setAsParent(baseMetaInfoHolder);
            return;
        } else {
            if (!(type instanceof XmlSchemaSimpleType)) return;
            if (baseMetaInfoHolder.isUnion()) {
                metaInfHolder.setUnion(true);
                Map memberTypes = baseMetaInfoHolder.getMemberTypes();
                Iterator iter = memberTypes.keySet().iterator();
                while (iter.hasNext()) {
                    Object qname2 = iter.next();
                    metaInfHolder.addMemberType((QName)qname2, (String)memberTypes.get(qname2));
                }
            }
            if (baseMetaInfoHolder.isList()) {
                metaInfHolder.setList(true);
                metaInfHolder.setItemTypeQName(baseMetaInfoHolder.getItemTypeQName());
                metaInfHolder.setItemTypeClassName(baseMetaInfoHolder.getItemTypeClassName());
            }
            metaInfHolder.setAsParent(baseMetaInfoHolder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSimpleContent(XmlSchemaSimpleContent simpleContent, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaContent content = simpleContent.getContent();
        if (content instanceof XmlSchemaSimpleContentExtension) {
            XmlSchemaSimpleContentExtension extension = (XmlSchemaSimpleContentExtension)content;
            if (!this.isAlreadyProcessed(extension.getBaseTypeName())) {
                XmlSchemaType type = this.getType(parentSchema, extension.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType2 = (XmlSchemaComplexType)type;
                    if (complexType2.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in extension");
                    this.processNamedComplexSchemaType(complexType2, parentSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type, null, parentSchema, null);
                }
            }
            this.processSimpleExtensionBaseType(extension.getBaseTypeName(), metaInfHolder, parentSchema);
            XmlSchemaObjectCollection attribs = extension.getAttributes();
            Iterator attribIterator = attribs.getIterator();
            while (attribIterator.hasNext()) {
                Object attr = attribIterator.next();
                if (!(attr instanceof XmlSchemaAttribute)) continue;
                this.processAttribute((XmlSchemaAttribute)attr, metaInfHolder, parentSchema);
            }
            XmlSchemaAnyAttribute anyAtt = extension.getAnyAttribute();
            if (anyAtt == null) return;
            this.processAnyAttribute(metaInfHolder, anyAtt);
            return;
        } else {
            if (!(content instanceof XmlSchemaSimpleContentRestriction)) return;
            XmlSchemaSimpleContentRestriction restriction = (XmlSchemaSimpleContentRestriction)content;
            if (!this.isAlreadyProcessed(restriction.getBaseTypeName())) {
                XmlSchemaType type = this.getType(parentSchema, restriction.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType3 = (XmlSchemaComplexType)type;
                    if (complexType3.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in restriction");
                    this.processNamedComplexSchemaType(complexType3, parentSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type, null, parentSchema, null);
                }
            }
            this.processSimpleRestrictionBaseType(restriction.getBaseTypeName(), restriction.getBaseTypeName(), metaInfHolder, parentSchema);
            metaInfHolder.setSimple(true);
        }
    }

    public void processSimpleExtensionBaseType(QName extBaseType, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        String className = this.findClassName(extBaseType, false);
        if (this.baseSchemaTypeMap.containsKey(extBaseType)) {
            if (this.changedTypeMap.containsKey(extBaseType)) {
                metaInfHolder.registerMapping(extBaseType, (QName)this.changedTypeMap.get(extBaseType), className, 2);
            } else {
                metaInfHolder.registerMapping(extBaseType, extBaseType, className, 2);
            }
            metaInfHolder.setSimple(true);
        } else if (this.processedTypemap.containsKey(extBaseType)) {
            XmlSchemaComplexType complexType2;
            XmlSchemaType type = this.getType(parentSchema, extBaseType);
            if (type instanceof XmlSchemaSimpleType) {
                metaInfHolder.setSimple(true);
                metaInfHolder.setExtension(true);
                metaInfHolder.setExtensionClassName(className);
                this.copyMetaInfoHierarchy(metaInfHolder, extBaseType, parentSchema);
            } else if (type instanceof XmlSchemaComplexType && (complexType2 = (XmlSchemaComplexType)type).getContentModel() == null) {
                metaInfHolder.setExtension(true);
                metaInfHolder.setExtensionClassName(className);
                this.copyMetaInfoHierarchy(metaInfHolder, extBaseType, parentSchema);
            }
        } else {
            metaInfHolder.setSimple(true);
        }
        if (this.isBinary(extBaseType)) {
            metaInfHolder.addtStatus(extBaseType, 16);
        }
    }

    public void processSimpleRestrictionBaseType(QName qName, QName resBaseType, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        String className = this.findClassName(resBaseType, false);
        if (this.baseSchemaTypeMap.containsKey(resBaseType)) {
            if (this.changedTypeMap.containsKey(resBaseType)) {
                metaInfHolder.registerMapping(qName, (QName)this.changedTypeMap.get(resBaseType), className, 2);
            } else {
                metaInfHolder.registerMapping(qName, resBaseType, className, 2);
            }
        } else if (this.processedTypemap.containsKey(resBaseType)) {
            metaInfHolder.setSimple(true);
            metaInfHolder.setRestriction(true);
            metaInfHolder.setRestrictionClassName(className);
            this.copyMetaInfoHierarchy(metaInfHolder, resBaseType, parentSchema);
        }
        metaInfHolder.setRestrictionBaseType(resBaseType);
    }

    private void processFacets(XmlSchemaSimpleTypeRestriction restriction, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) {
        XmlSchemaObjectCollection facets = restriction.getFacets();
        Iterator facetIterator = facets.getIterator();
        while (facetIterator.hasNext()) {
            Object obj = facetIterator.next();
            if (obj instanceof XmlSchemaPatternFacet) {
                XmlSchemaPatternFacet pattern = (XmlSchemaPatternFacet)obj;
                String patternString = pattern.getValue().toString();
                metaInfHolder.setPatternFacet(patternString.replaceAll("\\\\", "\\\\\\\\"));
                continue;
            }
            if (obj instanceof XmlSchemaEnumerationFacet) {
                XmlSchemaEnumerationFacet enumeration = (XmlSchemaEnumerationFacet)obj;
                if (restriction.getBaseTypeName().equals(SchemaConstants.XSD_QNAME)) {
                    String value = enumeration.getValue().toString();
                    String prefix = value.substring(0, value.indexOf(":"));
                    String localPart = value.substring(value.indexOf(":") + 1);
                    String namespaceUri = parentSchema.getNamespaceContext().getNamespaceURI(prefix);
                    String qNameString = value + "\", \"" + namespaceUri;
                    metaInfHolder.addEnumFacet(qNameString);
                    continue;
                }
                metaInfHolder.addEnumFacet(enumeration.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaLengthFacet) {
                XmlSchemaLengthFacet length = (XmlSchemaLengthFacet)obj;
                metaInfHolder.setLengthFacet(Integer.parseInt(length.getValue().toString()));
                continue;
            }
            if (obj instanceof XmlSchemaMaxExclusiveFacet) {
                XmlSchemaMaxExclusiveFacet maxEx = (XmlSchemaMaxExclusiveFacet)obj;
                metaInfHolder.setMaxExclusiveFacet(maxEx.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMinExclusiveFacet) {
                XmlSchemaMinExclusiveFacet minEx = (XmlSchemaMinExclusiveFacet)obj;
                metaInfHolder.setMinExclusiveFacet(minEx.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMaxInclusiveFacet) {
                XmlSchemaMaxInclusiveFacet maxIn = (XmlSchemaMaxInclusiveFacet)obj;
                metaInfHolder.setMaxInclusiveFacet(maxIn.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMinInclusiveFacet) {
                XmlSchemaMinInclusiveFacet minIn = (XmlSchemaMinInclusiveFacet)obj;
                metaInfHolder.setMinInclusiveFacet(minIn.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMaxLengthFacet) {
                XmlSchemaMaxLengthFacet maxLen = (XmlSchemaMaxLengthFacet)obj;
                metaInfHolder.setMaxLengthFacet(Integer.parseInt(maxLen.getValue().toString()));
                continue;
            }
            if (!(obj instanceof XmlSchemaMinLengthFacet)) continue;
            XmlSchemaMinLengthFacet minLen = (XmlSchemaMinLengthFacet)obj;
            metaInfHolder.setMinLengthFacet(Integer.parseInt(minLen.getValue().toString()));
        }
    }

    private void processAnyAttribute(BeanWriterMetaInfoHolder metainf, XmlSchemaAnyAttribute anyAtt) {
        QName qName = new QName(EXTRA_ATTRIBUTE_FIELD_NAME);
        metainf.registerMapping(qName, null, this.writer.getDefaultAttribArrayClassName(), 8);
        metainf.addtStatus(qName, 1);
        metainf.addtStatus(qName, 4);
    }

    public void processAttribute(XmlSchemaAttribute att, BeanWriterMetaInfoHolder metainf, XmlSchema parentSchema) throws SchemaCompilationException {
        block6: {
            block5: {
                XmlSchemaSimpleType simpleType2;
                QName schemaTypeName;
                block7: {
                    schemaTypeName = att.getSchemaTypeName();
                    if (schemaTypeName == null) break block5;
                    if (att.getQName() == null) break block6;
                    if (!this.baseSchemaTypeMap.containsKey(schemaTypeName)) break block7;
                    metainf.registerMapping(att.getQName(), schemaTypeName, this.baseSchemaTypeMap.get(schemaTypeName).toString(), 1);
                    String use = att.getUse().getValue();
                    if (use.indexOf("optional") != -1) {
                        metainf.addtStatus(att.getQName(), 32);
                    }
                    break block6;
                }
                XmlSchemaType type = this.getType(parentSchema, schemaTypeName);
                if (!(type instanceof XmlSchemaSimpleType) || !((simpleType2 = (XmlSchemaSimpleType)type).getContent() instanceof XmlSchemaSimpleTypeRestriction)) break block6;
                if (!this.isAlreadyProcessed(schemaTypeName)) {
                    this.processSimpleSchemaType(simpleType2, null, parentSchema, null);
                }
                metainf.registerMapping(att.getQName(), schemaTypeName, this.processedTypemap.get(schemaTypeName).toString(), 1);
                String use = att.getUse().getValue();
                if (use.indexOf("optional") == -1) break block6;
                metainf.addtStatus(att.getQName(), 32);
                break block6;
            }
            if (att.getRefName() != null) {
                XmlSchema currentParentSchema = this.resolveParentSchema(att.getRefName(), parentSchema);
                QName attrQname = this.generateAttributeQName(att.getRefName(), parentSchema);
                XmlSchemaObjectCollection items = currentParentSchema.getItems();
                Iterator itemIterator = items.getIterator();
                while (itemIterator.hasNext()) {
                    XmlSchemaSimpleType simpleType3;
                    XmlSchemaAttribute attribute;
                    Object attr = itemIterator.next();
                    if (!(attr instanceof XmlSchemaAttribute) || !(attribute = (XmlSchemaAttribute)attr).getName().equals(att.getRefName().getLocalPart())) continue;
                    QName attrTypeName = attribute.getSchemaTypeName();
                    Object type = this.baseSchemaTypeMap.get(attrTypeName);
                    if (type == null && (simpleType3 = attribute.getSchemaType()) != null && simpleType3.getContent() instanceof XmlSchemaSimpleTypeRestriction) {
                        XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)simpleType3.getContent();
                        QName baseTypeName = restriction.getBaseTypeName();
                        type = this.baseSchemaTypeMap.get(baseTypeName);
                        attrQname = att.getRefName();
                    }
                    if (type == null) continue;
                    metainf.registerMapping(attrQname, attrQname, type.toString(), 1);
                    String use = att.getUse().getValue();
                    if (use.indexOf("optional") == -1) continue;
                    metainf.addtStatus(att.getQName(), 32);
                }
            }
        }
    }

    private void processParticle(XmlSchemaParticle particle2, BeanWriterMetaInfoHolder metainfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        if (particle2 instanceof XmlSchemaSequence) {
            XmlSchemaObjectCollection items = ((XmlSchemaSequence)particle2).getItems();
            if (this.options.isBackwordCompatibilityMode()) {
                this.process(items, metainfHolder, false, parentSchema);
            } else {
                this.process(items, metainfHolder, true, parentSchema);
            }
        } else if (particle2 instanceof XmlSchemaAll) {
            XmlSchemaObjectCollection items = ((XmlSchemaAll)particle2).getItems();
            this.process(items, metainfHolder, false, parentSchema);
        } else if (particle2 instanceof XmlSchemaChoice) {
            XmlSchemaObjectCollection items = ((XmlSchemaChoice)particle2).getItems();
            metainfHolder.setChoice(true);
            this.process(items, metainfHolder, false, parentSchema);
        }
    }

    private void process(XmlSchemaObjectCollection items, BeanWriterMetaInfoHolder metainfHolder, boolean order, XmlSchema parentSchema) throws SchemaCompilationException {
        int count = items.getCount();
        LinkedHashMap<XmlSchemaParticle, Boolean> processedElementArrayStatusMap = new LinkedHashMap<XmlSchemaParticle, Boolean>();
        LinkedHashMap<QName, XmlSchemaAny> processedElementTypeMap = new LinkedHashMap<QName, XmlSchemaAny>();
        ArrayList localNillableList = new ArrayList();
        ArrayList<QName> innerChoiceElementList = new ArrayList<QName>();
        HashMap<XmlSchemaParticle, Integer> elementOrderMap = new HashMap<XmlSchemaParticle, Integer>();
        int sequenceCounter = 0;
        for (int i = 0; i < count; ++i) {
            XmlSchemaObject item = items.getItem(i);
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement xsElt = (XmlSchemaElement)item;
                boolean isArray = this.isArray(xsElt);
                this.processElement(xsElt, processedElementTypeMap, localNillableList, parentSchema);
                processedElementArrayStatusMap.put(xsElt, isArray ? Boolean.TRUE : Boolean.FALSE);
                if (order) {
                    elementOrderMap.put(xsElt, new Integer(sequenceCounter));
                }
            } else if (item instanceof XmlSchemaAny) {
                XmlSchemaAny any = (XmlSchemaAny)item;
                processedElementTypeMap.put(new QName(ANY_ELEMENT_FIELD_NAME), any);
                if (order) {
                    elementOrderMap.put(any, new Integer(sequenceCounter));
                }
                processedElementArrayStatusMap.put(any, this.isArray(any) ? Boolean.TRUE : Boolean.FALSE);
            } else if (order && item instanceof XmlSchemaChoice) {
                XmlSchemaChoice choice = (XmlSchemaChoice)item;
                XmlSchemaObjectCollection schemaItems = choice.getItems();
                for (int j = 0; j < schemaItems.getCount(); ++j) {
                    XmlSchemaObject choiceChild = schemaItems.getItem(j);
                    if (!(choiceChild instanceof XmlSchemaElement)) continue;
                    XmlSchemaElement xsElt = (XmlSchemaElement)choiceChild;
                    boolean isArray = this.isArray(xsElt);
                    this.processElement(xsElt, processedElementTypeMap, localNillableList, parentSchema);
                    processedElementArrayStatusMap.put(xsElt, isArray ? Boolean.TRUE : Boolean.FALSE);
                    if (order) {
                        elementOrderMap.put(xsElt, new Integer(sequenceCounter));
                        ++sequenceCounter;
                    }
                    innerChoiceElementList.add(xsElt.getQName());
                }
            }
            ++sequenceCounter;
        }
        Iterator processedElementsIterator = processedElementArrayStatusMap.keySet().iterator();
        int startingItemNumberOrder = metainfHolder.getOrderStartPoint();
        while (processedElementsIterator.hasNext()) {
            Object child = processedElementsIterator.next();
            if (child instanceof XmlSchemaElement) {
                String clazzName;
                XmlSchemaElement elt = (XmlSchemaElement)child;
                QName referencedQName = null;
                if (elt.getQName() != null) {
                    QName schemaTypeQName;
                    referencedQName = elt.getQName();
                    QName qName = schemaTypeQName = elt.getSchemaType() != null ? elt.getSchemaType().getQName() : elt.getSchemaTypeName();
                    if (schemaTypeQName != null) {
                        clazzName = (String)processedElementTypeMap.get(elt.getQName());
                        metainfHolder.registerMapping(referencedQName, schemaTypeQName, clazzName, (Boolean)processedElementArrayStatusMap.get(elt) != false ? 4 : 2);
                        if (innerChoiceElementList.contains(referencedQName)) {
                            metainfHolder.addtStatus(referencedQName, 128);
                        }
                    }
                }
                if (elt.getRefName() != null) {
                    XmlSchemaElement refElement;
                    boolean arrayStatus;
                    referencedQName = elt.getRefName();
                    clazzName = this.findRefClassName(referencedQName, arrayStatus = ((Boolean)processedElementArrayStatusMap.get(elt)).booleanValue());
                    if (clazzName == null) {
                        clazzName = this.findClassName(referencedQName, arrayStatus);
                    }
                    if ((refElement = this.getReferencedElement(parentSchema, referencedQName)) != null) {
                        metainfHolder.registerMapping(referencedQName, refElement.getSchemaTypeName(), clazzName, arrayStatus ? 4 : 2);
                    } else if (referencedQName.equals(SchemaConstants.XSD_SCHEMA)) {
                        metainfHolder.registerMapping(referencedQName, null, this.writer.getDefaultClassName(), 8);
                    } else {
                        throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.referencedElementNotFound", referencedQName.toString()));
                    }
                }
                if (referencedQName == null) {
                    throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.emptyName"));
                }
                metainfHolder.addMaxOccurs(referencedQName, elt.getMaxOccurs());
                metainfHolder.addMinOccurs(referencedQName, elt.getMinOccurs());
                if (order) {
                    Integer integer = (Integer)elementOrderMap.get(elt);
                    metainfHolder.registerQNameIndex(referencedQName, startingItemNumberOrder + integer);
                }
                if (localNillableList.contains(elt.getQName())) {
                    metainfHolder.registerNillableQName(elt.getQName());
                }
                if (!this.isBinary(elt)) continue;
                metainfHolder.addtStatus(elt.getQName(), 16);
                continue;
            }
            if (!(child instanceof XmlSchemaAny)) continue;
            XmlSchemaAny any = (XmlSchemaAny)child;
            QName anyElementFieldName = new QName(ANY_ELEMENT_FIELD_NAME);
            boolean isArray = (Boolean)processedElementArrayStatusMap.get(any);
            metainfHolder.registerMapping(anyElementFieldName, null, isArray ? this.writer.getDefaultClassArrayName() : this.writer.getDefaultClassName(), 8);
            if (isArray) {
                metainfHolder.addtStatus(anyElementFieldName, 4);
            }
            metainfHolder.addMaxOccurs(anyElementFieldName, any.getMaxOccurs());
            metainfHolder.addMinOccurs(anyElementFieldName, any.getMinOccurs());
            if (!order) continue;
            Integer integer = (Integer)elementOrderMap.get(any);
            metainfHolder.registerQNameIndex(anyElementFieldName, startingItemNumberOrder + integer);
        }
        metainfHolder.setOrdered(order);
    }

    private XmlSchemaType getType(XmlSchema schema, QName schemaTypeName) throws SchemaCompilationException {
        XmlSchemaObjectCollection includes;
        XmlSchemaType typeByName = schema.getTypeByName(schemaTypeName);
        if (typeByName == null && (typeByName = (schema = this.resolveParentSchema(schemaTypeName, schema)).getTypeByName(schemaTypeName)) == null && (includes = schema.getIncludes()) != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                Object o = tempIterator.next();
                XmlSchema inclSchema = null;
                if (o instanceof XmlSchemaImport && (inclSchema = ((XmlSchemaImport)o).getSchema()) == null) {
                    inclSchema = (XmlSchema)this.loadedSchemaMap.get(((XmlSchemaImport)o).getNamespace());
                }
                if (o instanceof XmlSchemaInclude) {
                    inclSchema = ((XmlSchemaInclude)o).getSchema();
                }
                if (inclSchema != null) {
                    typeByName = inclSchema.getTypeByName(schemaTypeName);
                }
                if (typeByName == null) continue;
                break;
            }
        }
        return typeByName;
    }

    private XmlSchemaElement getReferencedElement(XmlSchema parentSchema, QName referencedQName) throws SchemaCompilationException {
        XmlSchemaObjectCollection includes;
        XmlSchema schema;
        XmlSchemaElement refElement = parentSchema.getElementByName(referencedQName);
        if (refElement == null && (refElement = (schema = this.resolveParentSchema(referencedQName, parentSchema)).getElementByName(referencedQName)) == null && (includes = schema.getIncludes()) != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                Object o = tempIterator.next();
                XmlSchema inclSchema = null;
                if (o instanceof XmlSchemaImport && (inclSchema = ((XmlSchemaImport)o).getSchema()) == null) {
                    inclSchema = (XmlSchema)this.loadedSchemaMap.get(((XmlSchemaImport)o).getNamespace());
                }
                if (o instanceof XmlSchemaInclude) {
                    inclSchema = ((XmlSchemaInclude)o).getSchema();
                }
                if (inclSchema != null) {
                    refElement = inclSchema.getElementByName(referencedQName);
                }
                if (refElement == null) continue;
                break;
            }
        }
        return refElement;
    }

    private boolean isBinary(XmlSchemaElement elt) {
        return elt.getSchemaType() != null && SchemaConstants.XSD_BASE64.equals(elt.getSchemaType().getQName());
    }

    private boolean isBinary(QName qName) {
        return qName != null && SchemaConstants.XSD_BASE64.equals(qName);
    }

    private void processSimpleSchemaType(XmlSchemaSimpleType simpleType2, XmlSchemaElement xsElt, XmlSchema parentSchema, QName qname2) throws SchemaCompilationException {
        String fullyQualifiedClassName = null;
        if (simpleType2.getQName() != null) {
            if (this.processedTypemap.containsKey(simpleType2.getQName()) || this.baseSchemaTypeMap.containsKey(simpleType2.getQName())) {
                return;
            }
            fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(simpleType2.getQName());
            this.processedTypemap.put(simpleType2.getQName(), fullyQualifiedClassName);
        } else {
            QName fakeQname;
            if (xsElt != null) {
                fakeQname = new QName(xsElt.getQName().getNamespaceURI(), xsElt.getQName().getLocalPart());
                xsElt.setSchemaTypeName(fakeQname);
            } else {
                fakeQname = qname2;
            }
            if (this.processedTypemap.containsKey(fakeQname) || this.baseSchemaTypeMap.containsKey(fakeQname)) {
                return;
            }
            fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(fakeQname);
            simpleType2.addMetaInfo("Q_NAME", fakeQname);
            this.processedTypemap.put(fakeQname, fullyQualifiedClassName);
        }
        simpleType2.addMetaInfo("CLASS_NAME", fullyQualifiedClassName);
        BeanWriterMetaInfoHolder metaInfHolder = this.processSimpleType(simpleType2, parentSchema);
        metaInfHolder.setSimple(true);
        if (simpleType2.getQName() == null) {
            QName fakeQname;
            this.processedAnonymousComplexTypesMap.put(xsElt, metaInfHolder);
            if (xsElt != null) {
                fakeQname = new QName(xsElt.getQName().getNamespaceURI(), xsElt.getQName().getLocalPart());
            } else {
                fakeQname = qname2;
                simpleType2.setName(fakeQname.getLocalPart());
                simpleType2.setSourceURI(fakeQname.getNamespaceURI());
            }
            this.simpleTypesMap.put(fakeQname, fullyQualifiedClassName);
        }
        metaInfHolder.setOwnQname(simpleType2.getQName());
        if (fullyQualifiedClassName != null) {
            metaInfHolder.setOwnClassName(fullyQualifiedClassName);
        }
        this.writeSimpleType(simpleType2, metaInfHolder);
    }

    private BeanWriterMetaInfoHolder processSimpleType(XmlSchemaSimpleType simpleType2, XmlSchema parentSchema) throws SchemaCompilationException {
        BeanWriterMetaInfoHolder metaInfHolder = new BeanWriterMetaInfoHolder();
        XmlSchemaSimpleTypeContent content = simpleType2.getContent();
        QName parentSimpleTypeQname = simpleType2.getQName();
        if (parentSimpleTypeQname == null) {
            parentSimpleTypeQname = (QName)simpleType2.getMetaInfoMap().get("Q_NAME");
        }
        if (content != null) {
            if (content instanceof XmlSchemaSimpleTypeRestriction) {
                XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content;
                QName baseTypeName = restriction.getBaseTypeName();
                if (this.baseSchemaTypeMap.containsKey(baseTypeName)) {
                    this.processSimpleRestrictionBaseType(parentSimpleTypeQname, restriction.getBaseTypeName(), metaInfHolder, parentSchema);
                    this.processFacets(restriction, metaInfHolder, parentSchema);
                } else {
                    XmlSchemaType restrictionBaseType = this.getType(parentSchema, baseTypeName);
                    if (restrictionBaseType instanceof XmlSchemaSimpleType) {
                        if (restrictionBaseType != null && !this.isAlreadyProcessed(baseTypeName)) {
                            this.processSimpleSchemaType((XmlSchemaSimpleType)restrictionBaseType, null, parentSchema, null);
                        }
                        this.processSimpleRestrictionBaseType(parentSimpleTypeQname, restriction.getBaseTypeName(), metaInfHolder, parentSchema);
                    }
                }
            } else if (content instanceof XmlSchemaSimpleTypeUnion) {
                XmlSchemaSimpleTypeUnion simpleTypeUnion = (XmlSchemaSimpleTypeUnion)content;
                QName[] qnames = simpleTypeUnion.getMemberTypesQNames();
                if (qnames != null) {
                    for (int i = 0; i < qnames.length; ++i) {
                        QName qname2 = qnames[i];
                        if (this.baseSchemaTypeMap.containsKey(qname2)) {
                            metaInfHolder.addMemberType(qname2, (String)this.baseSchemaTypeMap.get(qname2));
                            continue;
                        }
                        XmlSchemaType type = this.getType(parentSchema, qname2);
                        if (type instanceof XmlSchemaSimpleType) {
                            XmlSchemaSimpleType memberSimpleType = (XmlSchemaSimpleType)type;
                            if (!this.isAlreadyProcessed(qname2)) {
                                this.processSimpleSchemaType(memberSimpleType, null, parentSchema, null);
                            }
                            metaInfHolder.addMemberType(qname2, (String)this.processedTypemap.get(qname2));
                            continue;
                        }
                        throw new SchemaCompilationException("Unions can not have complex types as a member type");
                    }
                } else {
                    XmlSchemaObjectCollection xmlSchemaObjectCollection = simpleTypeUnion.getBaseTypes();
                    int i = 1;
                    Iterator iter = xmlSchemaObjectCollection.getIterator();
                    while (iter.hasNext()) {
                        XmlSchemaObject xmlSchemaObject = (XmlSchemaObject)iter.next();
                        ++i;
                        if (!(xmlSchemaObject instanceof XmlSchemaSimpleType)) continue;
                        XmlSchemaSimpleType unionSimpleType = (XmlSchemaSimpleType)xmlSchemaObject;
                        QName childQname = unionSimpleType.getQName();
                        if (childQname == null) {
                            childQname = new QName(parentSimpleTypeQname.getNamespaceURI(), parentSimpleTypeQname.getLocalPart() + "_type" + i);
                        }
                        this.processSimpleSchemaType(unionSimpleType, null, parentSchema, childQname);
                        metaInfHolder.addMemberType(childQname, (String)this.processedTypemap.get(childQname));
                    }
                }
                metaInfHolder.setUnion(true);
            } else if (content instanceof XmlSchemaSimpleTypeList) {
                XmlSchemaSimpleTypeList simpleTypeList = (XmlSchemaSimpleTypeList)content;
                QName itemTypeQName = simpleTypeList.getItemTypeName();
                if (itemTypeQName != null) {
                    XmlSchemaType simpleSchemaType;
                    if (!this.isAlreadyProcessed(itemTypeQName) && (simpleSchemaType = this.getType(parentSchema, itemTypeQName)) instanceof XmlSchemaSimpleType) {
                        this.processSimpleSchemaType((XmlSchemaSimpleType)simpleSchemaType, null, parentSchema, null);
                    }
                } else {
                    XmlSchemaSimpleType listSimpleType = simpleTypeList.getItemType();
                    itemTypeQName = listSimpleType.getQName();
                    if (itemTypeQName == null) {
                        itemTypeQName = new QName(parentSimpleTypeQname.getNamespaceURI(), parentSimpleTypeQname.getLocalPart() + "_type0");
                    }
                    this.processSimpleSchemaType(listSimpleType, null, parentSchema, itemTypeQName);
                }
                String className = this.findClassName(itemTypeQName, false);
                metaInfHolder.setList(true);
                metaInfHolder.setItemTypeQName(itemTypeQName);
                metaInfHolder.setItemTypeClassName(className);
            }
        }
        return metaInfHolder;
    }

    private boolean isArray(XmlSchemaParticle particle2) throws SchemaCompilationException {
        long minOccurs = particle2.getMinOccurs();
        long maxOccurs = particle2.getMaxOccurs();
        if (maxOccurs < minOccurs) {
            throw new SchemaCompilationException();
        }
        return maxOccurs > 1L;
    }

    private String getNextTypeSuffix() {
        if (typeCounter == Integer.MAX_VALUE) {
            typeCounter = 0;
        }
        return "_type" + typeCounter++;
    }
}

