/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.axis2.schema.SchemaConstants;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.databinding.CTypeMapper;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class ExtensionUtility {
    public static void invoke(CodeGenConfiguration configuration) throws Exception {
        AxisService axisService;
        QName qNameKey;
        Iterator processedkeys;
        ArrayList schemaList = configuration.getAxisService().getSchema();
        HashMap schemaMap = new HashMap();
        ExtensionUtility.populateSchemaMap(schemaMap, schemaList);
        if (schemaList == null || schemaList.isEmpty()) {
            configuration.setTypeMapper(new DefaultTypeMapper());
            return;
        }
        CompilerOptions options = new CompilerOptions();
        ExtensionUtility.populateDefaultOptions(options, configuration);
        ExtensionUtility.populateUserparameters(options, configuration);
        SchemaCompiler schemaCompiler = new SchemaCompiler(options);
        schemaCompiler.compile(schemaList);
        TypeMapper mapper = configuration.getTypeMapper();
        if (mapper == null) {
            mapper = configuration.getOutputLanguage() != null && !configuration.getOutputLanguage().trim().equals("") && configuration.getOutputLanguage().toLowerCase().equals("c") ? new CTypeMapper() : new JavaTypeMapper();
        }
        if (options.isWriteOutput()) {
            HashMap processedMap = schemaCompiler.getProcessedElementMap();
            processedkeys = processedMap.keySet().iterator();
            while (processedkeys.hasNext()) {
                qNameKey = (QName)processedkeys.next();
                mapper.addTypeMappingName(qNameKey, processedMap.get(qNameKey).toString());
            }
        } else {
            Map processedModelMap = schemaCompiler.getProcessedModelMap();
            processedkeys = processedModelMap.keySet().iterator();
            while (processedkeys.hasNext()) {
                qNameKey = (QName)processedkeys.next();
                mapper.addTypeMappingObject(qNameKey, processedModelMap.get(qNameKey));
            }
            HashMap processedMap = schemaCompiler.getProcessedElementMap();
            processedkeys = processedMap.keySet().iterator();
            while (processedkeys.hasNext()) {
                qNameKey = (QName)processedkeys.next();
                mapper.addTypeMappingName(qNameKey, processedMap.get(qNameKey).toString());
            }
            configuration.putProperty("externalTemplate", schemaCompiler.getCompilerProperties().getProperty("schema.bean.writer.template"));
        }
        if (!configuration.isParametersWrapped()) {
            axisService = configuration.getAxisService();
            Iterator operations = axisService.getOperations();
            while (operations.hasNext()) {
                AxisOperation op = (AxisOperation)operations.next();
                if (WSDLUtil.isInputPresentForMEP(op.getMessageExchangePattern())) {
                    ExtensionUtility.walkSchema(op.getMessage("In"), mapper, schemaMap, op.getName().getLocalPart(), "_input");
                }
                if (!WSDLUtil.isOutputPresentForMEP(op.getMessageExchangePattern())) continue;
                ExtensionUtility.walkSchema(op.getMessage("Out"), mapper, schemaMap, op.getName().getLocalPart(), "_output");
            }
        }
        if (!configuration.isParametersWrapped() || configuration.isBackwordCompatibilityMode()) {
            axisService = configuration.getAxisService();
            Iterator operators = axisService.getOperations();
            while (operators.hasNext()) {
                AxisMessage axisMessage;
                AxisOperation axisOperation = (AxisOperation)operators.next();
                if (WSDLUtil.isInputPresentForMEP(axisOperation.getMessageExchangePattern())) {
                    axisMessage = axisOperation.getMessage("In");
                    ExtensionUtility.setComplexTypeName(axisMessage);
                }
                if (!WSDLUtil.isOutputPresentForMEP(axisOperation.getMessageExchangePattern())) continue;
                axisMessage = axisOperation.getMessage("Out");
                ExtensionUtility.setComplexTypeName(axisMessage);
            }
        }
        configuration.setTypeMapper(mapper);
    }

    private static void setComplexTypeName(AxisMessage axisMessage) throws AxisFault {
        XmlSchemaComplexType complexType2;
        XmlSchemaType schemaType;
        if (axisMessage.getSchemaElement() != null && (schemaType = axisMessage.getSchemaElement().getSchemaType()) instanceof XmlSchemaComplexType && (complexType2 = (XmlSchemaComplexType)schemaType).getName() != null && complexType2.getQName() != null) {
            Map metaInfo = complexType2.getMetaInfoMap();
            String complexTypeName = (String)metaInfo.get("CLASS_NAME");
            axisMessage.addParameter(new Parameter("complexType", complexTypeName));
        }
    }

    private static void populateSchemaMap(Map schemaMap, List schemaList) {
        for (int i = 0; i < schemaList.size(); ++i) {
            XmlSchema xmlSchema = (XmlSchema)schemaList.get(i);
            schemaMap.put(xmlSchema.getTargetNamespace(), xmlSchema);
        }
    }

    private static void walkSchema(AxisMessage message, TypeMapper mapper, Map schemaMap, String opName, String qnameSuffix) {
        if (message.getParameter("UnWrapped") != null) {
            XmlSchemaType schemaType = message.getSchemaElement().getSchemaType();
            ExtensionUtility.processXMLSchemaComplexType(schemaType, mapper, opName, schemaMap, qnameSuffix);
        }
    }

    private static void processXMLSchemaComplexType(XmlSchemaType schemaType, TypeMapper mapper, String opName, Map schemaMap, String qnameSuffix) {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType cmplxType = (XmlSchemaComplexType)schemaType;
            if (cmplxType.getContentModel() == null) {
                ExtensionUtility.processSchemaSequence(cmplxType.getParticle(), mapper, opName, schemaMap, qnameSuffix);
            } else {
                ExtensionUtility.processComplexContentModel(cmplxType, mapper, opName, schemaMap, qnameSuffix);
            }
        }
    }

    private static void processComplexContentModel(XmlSchemaComplexType cmplxType, TypeMapper mapper, String opName, Map schemaMap, String qnameSuffix) {
        XmlSchemaComplexContent xmlSchemaComplexContent;
        XmlSchemaContent content;
        XmlSchemaContentModel contentModel = cmplxType.getContentModel();
        if (contentModel instanceof XmlSchemaComplexContent && (content = (xmlSchemaComplexContent = (XmlSchemaComplexContent)contentModel).getContent()) instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension schemaExtension = (XmlSchemaComplexContentExtension)content;
            ExtensionUtility.processSchemaSequence(schemaExtension.getParticle(), mapper, opName, schemaMap, qnameSuffix);
            XmlSchema parentSchema = (XmlSchema)schemaMap.get(schemaExtension.getBaseTypeName().getNamespaceURI());
            XmlSchemaType extensionSchemaType = parentSchema.getTypeByName(schemaExtension.getBaseTypeName());
            ExtensionUtility.processXMLSchemaComplexType(extensionSchemaType, mapper, opName, schemaMap, qnameSuffix);
        }
    }

    private static void processSchemaSequence(XmlSchemaParticle particle2, TypeMapper mapper, String opName, Map schemaMap, String qnameSuffix) {
        if (particle2 instanceof XmlSchemaSequence) {
            XmlSchemaObjectCollection items = ((XmlSchemaSequence)particle2).getItems();
            Iterator i = items.getIterator();
            while (i.hasNext()) {
                Object item = i.next();
                if (item instanceof XmlSchemaElement) {
                    XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)item;
                    XmlSchemaType eltSchemaType = xmlSchemaElement.getSchemaType();
                    if (eltSchemaType != null) {
                        ExtensionUtility.populateClassName(eltSchemaType, mapper, opName, xmlSchemaElement, qnameSuffix);
                        continue;
                    }
                    if (xmlSchemaElement.getSchemaTypeName() == null) continue;
                    eltSchemaType = ExtensionUtility.findSchemaType(schemaMap, xmlSchemaElement.getSchemaTypeName());
                    if (eltSchemaType != null) {
                        ExtensionUtility.populateClassName(eltSchemaType, mapper, opName, xmlSchemaElement, qnameSuffix);
                        continue;
                    }
                    if (!xmlSchemaElement.getSchemaTypeName().equals(SchemaConstants.XSD_ANYTYPE)) continue;
                    QName partQName = WSDLUtil.getPartQName(opName, qnameSuffix, xmlSchemaElement.getName());
                    if (xmlSchemaElement.getMaxOccurs() > 1L) {
                        mapper.addTypeMappingName(partQName, "org.apache.axiom.om.OMElement[]");
                        continue;
                    }
                    mapper.addTypeMappingName(partQName, "org.apache.axiom.om.OMElement");
                    continue;
                }
                if (!(item instanceof XmlSchemaAny)) continue;
                XmlSchemaAny xmlSchemaAny = (XmlSchemaAny)item;
                QName partQName = WSDLUtil.getPartQName(opName, qnameSuffix, "extraElement");
                if (((XmlSchemaAny)item).getMaxOccurs() > 1L) {
                    mapper.addTypeMappingName(partQName, "org.apache.axiom.om.OMElement[]");
                    continue;
                }
                mapper.addTypeMappingName(partQName, "org.apache.axiom.om.OMElement");
            }
        }
    }

    private static void populateClassName(XmlSchemaType eltSchemaType, TypeMapper typeMap, String opName, XmlSchemaElement xmlSchemaElement, String qnameSuffix) {
        boolean isArray = xmlSchemaElement.getMaxOccurs() > 1L;
        Map metaInfoMap = eltSchemaType.getMetaInfoMap();
        if (metaInfoMap != null) {
            String className = (String)metaInfoMap.get("CLASS_NAME");
            if (isArray && !className.endsWith("[]")) {
                className = className + "[]";
            } else if (!isArray && className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
            }
            QName partQName = WSDLUtil.getPartQName(opName, qnameSuffix, xmlSchemaElement.getName());
            typeMap.addTypeMappingName(partQName, className);
            if (Boolean.TRUE.equals(metaInfoMap.get("CLASS_NAME_PRIMITIVE"))) {
                typeMap.addTypeMappingStatus(partQName, Boolean.TRUE);
            }
        }
    }

    private static XmlSchemaType findSchemaType(Map schemaMap, QName schemaTypeName) {
        XmlSchema schema = (XmlSchema)schemaMap.get(schemaTypeName.getNamespaceURI());
        if (schema != null) {
            return schema.getTypeByName(schemaTypeName);
        }
        return null;
    }

    private static void populateUserparameters(CompilerOptions options, CodeGenConfiguration configuration) {
        String packageName;
        Map propertyMap = configuration.getProperties();
        if (propertyMap.containsKey("w")) {
            if (Boolean.valueOf(propertyMap.get("w").toString()).booleanValue()) {
                options.setWrapClasses(true);
            } else {
                options.setWrapClasses(false);
            }
        }
        if (propertyMap.containsKey("r")) {
            if (Boolean.valueOf(propertyMap.get("r").toString()).booleanValue()) {
                options.setWriteOutput(true);
            } else {
                options.setWriteOutput(false);
            }
        }
        if (propertyMap.containsKey("p") && ((packageName = (String)propertyMap.get("p")) != null || !"".equals(packageName))) {
            options.setPackageName(packageName);
        }
        options.setNs2PackageMap(configuration.getUri2PackageNameMap());
        if (propertyMap.containsKey("mp") && ((packageName = (String)propertyMap.get("mp")) != null || !"".equals(packageName))) {
            options.setMapperClassPackage(packageName);
        }
        if (!options.isWrapClasses() && propertyMap.containsKey("h")) {
            options.setHelperMode(true);
        }
    }

    private static void populateDefaultOptions(CompilerOptions options, CodeGenConfiguration configuration) {
        File outputDir;
        File file = outputDir = configuration.isFlattenFiles() ? configuration.getOutputLocation() : new File(configuration.getOutputLocation(), configuration.getSourceLocation());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        options.setOutputLocation(outputDir);
        options.setNs2PackageMap(configuration.getUri2PackageNameMap() == null ? new HashMap() : configuration.getUri2PackageNameMap());
        if (configuration.isServerSide()) {
            options.setWrapClasses(false);
            options.setWriteOutput(true);
        } else {
            options.setWrapClasses(configuration.isPackClasses());
            options.setWriteOutput(!configuration.isPackClasses());
        }
        if (configuration.isGenerateAll()) {
            options.setGenerateAll(true);
        }
        if (configuration.isBackwordCompatibilityMode()) {
            options.setBackwordCompatibilityMode(true);
        }
        if (configuration.isSuppressPrefixesMode()) {
            options.setSuppressPrefixesMode(true);
        }
    }
}

