/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12Factory;
import org.apache.axis2.saaj.MimeHeadersEx;
import org.apache.axis2.saaj.SOAPEnvelopeImpl;
import org.apache.axis2.saaj.SOAPMessageImpl;
import org.apache.axis2.saaj.util.IDGenerator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SOAPPartImpl
extends SOAPPart {
    private Document document;
    private SOAPMessage soapMessage;
    private SOAPEnvelopeImpl envelope;
    private MimeHeadersEx mimeHeaders = new MimeHeadersEx();
    private Source source;

    public SOAPPartImpl(SOAPMessageImpl parentSoapMsg, SOAPEnvelopeImpl soapEnvelope) {
        this.setMimeHeader("Content-Id", IDGenerator.generateID());
        this.setMimeHeader("Content-Type", "text/xml");
        this.soapMessage = parentSoapMsg;
        this.envelope = soapEnvelope;
        this.document = soapEnvelope.getOwnerDocument();
    }

    public SOAPPartImpl(SOAPMessageImpl parentSoapMsg, InputStream inputStream, MimeHeaders mimeHeaders) throws SOAPException {
        boolean mimeHeaderSet = true;
        if (mimeHeaders == null) {
            mimeHeaderSet = false;
            mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-ID", IDGenerator.generateID());
            mimeHeaders.addHeader("Content-Type", "text/xml");
        }
        Iterator mimeHeaderIterator = mimeHeaders.getAllHeaders();
        String contentType = "";
        while (mimeHeaderIterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)mimeHeaderIterator.next();
            String value = mimeHeader.getValue();
            if ("content-type".equals(mimeHeader.getName())) {
                contentType = value;
            }
            this.setMimeHeader(mimeHeader.getName(), value);
        }
        InputStream modifiedInputStream = null;
        if (mimeHeaderSet) {
            try {
                Attachments attachments = new Attachments(inputStream, contentType, false, "", "");
                modifiedInputStream = attachments.getSOAPPartInputStream();
            }
            catch (Exception e) {
                throw new SOAPException(e);
            }
        } else {
            modifiedInputStream = inputStream;
        }
        this.soapMessage = parentSoapMsg;
        try {
            InputStreamReader isReader = new InputStreamReader(modifiedInputStream);
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(StAXUtils.createXMLStreamReader(isReader), new SOAP11Factory(), null);
            SOAPEnvelope soapEnvelope = builder.getSOAPEnvelope();
            this.envelope = new SOAPEnvelopeImpl((org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl)soapEnvelope);
            this.envelope.element.build();
            this.document = this.envelope.getOwnerDocument();
            StreamSource xmlSource = new StreamSource(isReader);
            this.source = xmlSource;
        }
        catch (XMLStreamException e) {
            throw new SOAPException(e);
        }
    }

    public SOAPPartImpl(SOAPMessageImpl parentSoapMsg, InputStream inputStream) throws SOAPException {
        this(parentSoapMsg, inputStream, null);
    }

    public SOAPMessage getSoapMessage() {
        return this.soapMessage;
    }

    public javax.xml.soap.SOAPEnvelope getEnvelope() throws SOAPException {
        return this.envelope;
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public void addMimeHeader(String header, String value) {
        this.mimeHeaders.addHeader(header, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getNonMatchingHeaders(names);
    }

    public void setContent(Source source) throws SOAPException {
        this.source = source;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLStreamReader reader = inputFactory.createXMLStreamReader(is);
            StAXSOAPModelBuilder builder1 = null;
            if (this.envelope.element.getOMFactory() instanceof SOAP11Factory) {
                builder1 = new StAXSOAPModelBuilder(reader, (SOAP11Factory)this.envelope.element.getOMFactory(), null);
            } else if (this.envelope.element.getOMFactory() instanceof SOAP12Factory) {
                builder1 = new StAXSOAPModelBuilder(reader, (SOAP12Factory)this.envelope.element.getOMFactory(), null);
            }
            SOAPEnvelope soapEnvelope = builder1.getSOAPEnvelope();
            this.envelope = new SOAPEnvelopeImpl((org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl)soapEnvelope);
            this.envelope.element.build();
            this.document = this.envelope.getOwnerDocument();
        }
        catch (Exception e) {
            throw new SOAPException(e);
        }
    }

    public Source getContent() throws SOAPException {
        DOMSource domSource = new DOMSource(this.document);
        this.source = domSource;
        return this.source;
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.document.importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    public String getInputEncoding() {
        return this.envelope.getEncodingStyle();
    }

    public String getXmlEncoding() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException("TODO");
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public String getXmlVersion() {
        throw new UnsupportedOperationException("TODO");
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("TODO");
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("TODO");
    }

    public String getDocumentURI() {
        throw new UnsupportedOperationException("TODO");
    }

    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("TODO");
    }

    public Node adoptNode(Node source) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("TODO");
    }

    public void normalizeDocument() {
        throw new UnsupportedOperationException("TODO");
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public void setNodeValue(String arg0) throws DOMException {
        this.document.setNodeValue(arg0);
    }

    public short getNodeType() {
        return this.document.getNodeType();
    }

    public Node getParentNode() {
        return this.document.getParentNode();
    }

    public NodeList getChildNodes() {
        return this.document.getChildNodes();
    }

    public Node getFirstChild() {
        return this.document.getFirstChild();
    }

    public Node getLastChild() {
        return this.document.getLastChild();
    }

    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    public Node getNextSibling() {
        return this.document.getNextSibling();
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.document.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.document.replaceChild(newChild, oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.document.removeChild(oldChild);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.document.appendChild(newChild);
    }

    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    public void normalize() {
        this.document.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public void setPrefix(String arg0) throws DOMException {
        this.document.setPrefix(arg0);
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    protected void setMessage(SOAPMessageImpl message) {
        this.soapMessage = message;
    }

    public String getBaseURI() {
        throw new UnsupportedOperationException("TODO");
    }

    public short compareDocumentPosition(Node arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public void setTextContent(String arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isSameNode(Node arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public String lookupPrefix(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isDefaultNamespace(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public String lookupNamespaceURI(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isEqualNode(Node arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public Object getFeature(String arg0, String arg1) {
        throw new UnsupportedOperationException("TODO");
    }

    public Object setUserData(String arg0, Object arg1, UserDataHandler arg2) {
        throw new UnsupportedOperationException("TODO");
    }

    public Object getUserData(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public String getValue() {
        return null;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
    }

    public SOAPElement getParentElement() {
        return null;
    }

    public void detachNode() {
    }

    public void recycleNode() {
    }

    public void setValue(String value) {
    }
}

