/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFaultElement;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.impl.dom.SOAPFaultDetailImpl;
import org.apache.axiom.soap.impl.dom.factory.DOMSOAPFactory;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultDetailImpl;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultReasonImpl;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultRoleImpl;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultTextImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12Factory;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12FaultDetailImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12FaultRoleImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12FaultTextImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12FaultValueImpl;
import org.apache.axis2.saaj.DetailImpl;
import org.apache.axis2.saaj.SOAPBodyElementImpl;
import org.apache.axis2.saaj.SOAPFaultElementImpl;

public class SOAPFaultImpl
extends SOAPBodyElementImpl
implements javax.xml.soap.SOAPFault {
    protected SOAPFault fault;
    private boolean isDetailAdded;
    private Name faultCodeName;
    private Locale faultReasonLocale;

    public SOAPFaultImpl(SOAPFault fault) {
        super((ElementImpl)((Object)fault));
        this.fault = fault;
    }

    public void setFaultCode(String faultCode) throws SOAPException {
        SOAPFactory soapFactory = null;
        if (faultCode.indexOf(":") == -1) {
            throw new SOAPException("faultCode must be of the form prefix:localName");
        }
        String localName = "";
        String prefix = faultCode.substring(0, faultCode.indexOf(":"));
        localName = faultCode.substring(faultCode.indexOf(":") + 1);
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            soapFactory = DOOMAbstractFactory.getSOAP11Factory();
        } else if (this.element.getOMFactory() instanceof SOAP12Factory) {
            soapFactory = DOOMAbstractFactory.getSOAP12Factory();
        }
        SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode(this.fault);
        SOAPFaultValue soapFaultValue = soapFactory.createSOAPFaultValue(soapFaultCode);
        soapFaultCode.setValue(soapFaultValue);
        soapFaultValue.setText(faultCode);
        this.fault.setCode(soapFaultCode);
    }

    public String getFaultCode() {
        if (this.fault != null && this.fault.getCode() != null && this.fault.getCode().getValue() != null) {
            return this.fault.getCode().getValue().getText();
        }
        return null;
    }

    public void setFaultActor(String faultActor) throws SOAPException {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            if (this.fault.getRole() == null) {
                SOAP11FaultRoleImpl faultRoleImpl = new SOAP11FaultRoleImpl(this.fault, (SOAPFactory)this.element.getOMFactory());
                faultRoleImpl.setRoleValue(faultActor);
                this.fault.setRole(faultRoleImpl);
            } else {
                SOAPFaultRole role = this.fault.getRole();
                role.setRoleValue(faultActor);
            }
        } else if (this.element.getOMFactory() instanceof SOAP12Factory) {
            if (this.fault.getRole() == null) {
                SOAP12FaultRoleImpl faultRoleImpl = new SOAP12FaultRoleImpl(this.fault, (SOAPFactory)this.element.getOMFactory());
                faultRoleImpl.setRoleValue(faultActor);
                this.fault.setRole(faultRoleImpl);
            } else {
                SOAPFaultRole role = this.fault.getRole();
                role.setRoleValue(faultActor);
            }
        }
    }

    public String getFaultActor() {
        if (this.fault.getRole() != null) {
            return this.fault.getRole().getRoleValue();
        }
        return null;
    }

    public void setFaultString(String faultString) throws SOAPException {
        if (this.fault.getReason() != null) {
            SOAPFaultReason reason = this.fault.getReason();
            if (reason.getFirstSOAPText() != null) {
                reason.getFirstSOAPText().getFirstOMChild().detach();
                reason.getFirstSOAPText().setText(faultString);
            } else {
                OMElement text = null;
                if (this.element.getOMFactory() instanceof SOAP11Factory) {
                    text = new SOAP11FaultTextImpl(reason, (SOAPFactory)this.element.getOMFactory());
                } else if (this.element.getOMFactory() instanceof SOAP12Factory) {
                    text = new SOAP12FaultTextImpl(reason, (SOAPFactory)this.element.getOMFactory());
                }
                text.setText(faultString);
                reason.addSOAPText((SOAPFaultText)text);
            }
        } else {
            DOMSOAPFactory soapFactory = null;
            if (this.element.getOMFactory() instanceof SOAP11Factory) {
                soapFactory = (SOAP11Factory)this.element.getOMFactory();
            } else if (this.element.getOMFactory() instanceof SOAP12Factory) {
                soapFactory = (SOAP12Factory)this.element.getOMFactory();
            }
            SOAPFaultReason faultReason = soapFactory.createSOAPFaultReason(this.fault);
            SOAPFaultText faultText = soapFactory.createSOAPFaultText(faultReason);
            faultText.setText(faultString);
        }
    }

    public String getFaultString() {
        if (this.fault.getReason() != null && this.fault.getReason().getFirstSOAPText() != null) {
            return this.fault.getReason().getFirstSOAPText().getText();
        }
        return null;
    }

    public Detail getDetail() {
        return (Detail)this.toSAAJNode((org.w3c.dom.Node)((Object)this.fault.getDetail()));
    }

    public void setFaultCode(Name faultCodeQName) throws SOAPException {
        if (faultCodeQName.getURI() == null || faultCodeQName.getURI().trim().length() == 0) {
            throw new SOAPException("faultCodeQName must be namespace qualified.");
        }
        this.faultCodeName = faultCodeQName;
    }

    public Detail addDetail() throws SOAPException {
        if (this.isDetailAdded) {
            throw new SOAPException("This SOAPFault already contains a Detail element. Please remove the existing Detail element before calling addDetail()");
        }
        SOAPFactory factory = (SOAPFactory)this.element.getOMFactory();
        SOAPFaultDetailImpl omDetail = factory instanceof SOAP11Factory ? new SOAP11FaultDetailImpl(this.fault, factory) : new SOAP12FaultDetailImpl(this.fault, factory);
        DetailImpl saajDetail = new DetailImpl(omDetail);
        ((NodeImpl)((Object)this.fault.getDetail())).setUserData("saaj.node", saajDetail, null);
        this.isDetailAdded = true;
        return saajDetail;
    }

    public Name getFaultCodeAsName() {
        return this.faultCodeName;
    }

    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        if (this.fault.getReason() != null) {
            SOAPFaultReason reason = this.fault.getReason();
            if (reason.getFirstSOAPText() != null) {
                reason.getFirstSOAPText().setText(faultString);
                reason.getFirstSOAPText().setLang(locale.toString());
            } else {
                SOAP11FaultTextImpl text = null;
                if (this.element.getOMFactory() instanceof SOAP11Factory) {
                    text = new SOAP11FaultTextImpl(reason, (SOAPFactory)this.element.getOMFactory());
                    text.setText(faultString);
                    text.setLang(locale.toString());
                    reason.addSOAPText(text);
                } else if (this.element.getOMFactory() instanceof SOAP12Factory) {
                    this.addFaultReasonText(faultString, locale);
                }
            }
        } else if (this.element.getOMFactory() instanceof SOAP11Factory) {
            SOAP11FaultReasonImpl reason = new SOAP11FaultReasonImpl(this.fault, (SOAPFactory)this.element.getOMFactory());
            SOAP11FaultTextImpl text = new SOAP11FaultTextImpl(reason, (SOAPFactory)this.element.getOMFactory());
            text.setText(faultString);
            text.setLang(locale.toString());
            reason.addSOAPText(text);
            this.fault.setReason(reason);
        } else if (this.element.getOMFactory() instanceof SOAP12Factory) {
            this.addFaultReasonText(faultString, locale);
        }
        this.faultReasonLocale = locale;
    }

    public Locale getFaultStringLocale() {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            return this.faultReasonLocale;
        }
        if (this.element.getOMFactory() instanceof SOAP12Factory) {
            Locale locale = null;
            try {
                if (this.getFaultReasonLocales().hasNext()) {
                    locale = (Locale)this.getFaultReasonLocales().next();
                }
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
            return locale;
        }
        return null;
    }

    public void addFaultReasonText(String text, Locale locale) throws SOAPException {
        if (locale == null) {
            throw new SOAPException("Received null for locale");
        }
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            throw new UnsupportedOperationException("Not supported in SOAP 1.1");
        }
        if (this.element.getOMFactory() instanceof SOAP12Factory) {
            String existingReasonText = this.getFaultReasonText(locale);
            if (existingReasonText == null) {
                SOAP12Factory soapFactory = null;
                soapFactory = (SOAP12Factory)this.element.getOMFactory();
                if (this.fault.getReason() == null) {
                    SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason(this.fault);
                    this.fault.setReason(soapFaultReason);
                }
                SOAPFaultText soapFaultText = soapFactory.createSOAPFaultText(this.fault.getReason());
                soapFaultText.setText(text);
                soapFaultText.setLang(locale.toString());
            } else {
                Iterator soapTextsItr = this.fault.getReason().getAllSoapTexts().iterator();
                while (soapTextsItr.hasNext()) {
                    SOAPFaultText soapFaultText = (SOAPFaultText)soapTextsItr.next();
                    if (!soapFaultText.getLang().equals(locale.toString())) continue;
                    soapFaultText.setText(text);
                }
            }
        }
    }

    public void appendFaultSubcode(QName subcode) throws SOAPException {
        SOAPFactory soapFactory = null;
        SOAPFaultSubCode soapFaultSubCode = null;
        if (subcode.getNamespaceURI() == null || subcode.getNamespaceURI().trim().length() == 0) {
            throw new SOAPException("Unqualified QName object : " + subcode);
        }
        if ("SOAP 1.1 Protocol".equals(this.getSOAPVersion(this.element))) {
            throw new UnsupportedOperationException();
        }
        if ("SOAP 1.2 Protocol".equals(this.getSOAPVersion(this.element))) {
            soapFactory = DOOMAbstractFactory.getSOAP12Factory();
        }
        if (this.fault.getCode() == null) {
            soapFactory.createSOAPFaultCode(this.fault);
            soapFaultSubCode = soapFactory.createSOAPFaultSubCode(this.fault.getCode());
        } else {
            soapFaultSubCode = this.fault.getCode().getSubCode() != null ? soapFactory.createSOAPFaultSubCode(this.getLastSubCode(this.fault.getCode().getSubCode())) : soapFactory.createSOAPFaultSubCode(this.fault.getCode());
        }
        if (soapFaultSubCode != null) {
            SOAP12FaultValueImpl soapFaultValueimpl = new SOAP12FaultValueImpl(soapFaultSubCode, soapFactory);
            soapFaultValueimpl.setText(subcode.getPrefix() + ":" + subcode.getLocalPart());
            OMNamespaceImpl omNamespace = new OMNamespaceImpl(subcode.getNamespaceURI(), this.element.getPrefix());
            soapFaultValueimpl.setNamespace(omNamespace);
        }
    }

    private SOAPFaultSubCode getLastSubCode(SOAPFaultSubCode firstSubCodeElement) {
        SOAPFaultSubCode soapFaultSubCode = firstSubCodeElement.getSubCode();
        if (soapFaultSubCode != null) {
            return this.getLastSubCode(soapFaultSubCode);
        }
        return firstSubCodeElement;
    }

    public QName getFaultCodeAsQName() {
        SOAPFaultCode soapFaultCode = this.fault.getCode();
        if (soapFaultCode != null) {
            String prefix = "";
            String localPart = "";
            String uri = "";
            String text = soapFaultCode.getValue().getText();
            prefix = text.substring(0, text.indexOf(":"));
            localPart = text.substring(text.indexOf(":") + 1);
            OMNamespace namespace = soapFaultCode.getValue().getNamespace();
            uri = namespace != null ? soapFaultCode.getValue().getNamespace().getNamespaceURI() : this.fault.getNamespace().getNamespaceURI();
            QName qname2 = new QName(uri, localPart, prefix);
            return qname2;
        }
        return null;
    }

    public String getFaultNode() {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            throw new UnsupportedOperationException("Message does not support the SOAP 1.2 concept of Fault Node");
        }
        if (this.fault != null && this.fault.getNode() != null && this.fault.getNode().getText() != null) {
            return this.fault.getNode().getText();
        }
        return null;
    }

    public Iterator getFaultReasonLocales() throws SOAPException {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            throw new UnsupportedOperationException("Message does not support the SOAP 1.2 concept of Fault Reason");
        }
        ArrayList<Locale> faultReasonLocales = new ArrayList<Locale>();
        List soapTextList = this.fault.getReason().getAllSoapTexts();
        if (soapTextList != null) {
            Iterator faultReasons = soapTextList.iterator();
            while (faultReasons.hasNext()) {
                SOAPFaultText soapFaultText = (SOAPFaultText)faultReasons.next();
                String lang = soapFaultText.getLang();
                if (lang == null) {
                    faultReasonLocales.add(Locale.getDefault());
                    continue;
                }
                if (lang.indexOf("_") != -1) {
                    String language = lang.substring(0, lang.indexOf("_"));
                    String country = lang.substring(lang.indexOf("_") + 1);
                    faultReasonLocales.add(new Locale(language, country));
                    continue;
                }
                faultReasonLocales.add(new Locale(lang));
            }
        }
        return faultReasonLocales.iterator();
    }

    public String getFaultReasonText(Locale locale) throws SOAPException {
        List soapTexts;
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            throw new UnsupportedOperationException("Message does not support the SOAP 1.2 concept of Fault Reason");
        }
        Iterator soapTextsItr = new ArrayList().iterator();
        SOAPFaultReason soapFaultReason = this.fault.getReason();
        if (soapFaultReason != null && (soapTexts = soapFaultReason.getAllSoapTexts()) != null) {
            soapTextsItr = soapTexts.iterator();
            while (soapTextsItr.hasNext()) {
                SOAPFaultText soapFaultText = (SOAPFaultText)soapTextsItr.next();
                if (!soapFaultText.getLang().equals(locale.toString())) continue;
                return soapFaultText.getText();
            }
        }
        return null;
    }

    public Iterator getFaultReasonTexts() throws SOAPException {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            throw new UnsupportedOperationException();
        }
        Iterator soapTextsItr = this.fault.getReason().getAllSoapTexts().iterator();
        ArrayList<String> reasonTexts = new ArrayList<String>();
        while (soapTextsItr.hasNext()) {
            SOAPFaultText soapFaultText = (SOAPFaultText)soapTextsItr.next();
            reasonTexts.add(soapFaultText.getText());
        }
        return reasonTexts.iterator();
    }

    public String getFaultRole() {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            throw new UnsupportedOperationException("Message does not support the SOAP 1.2 concept of Fault Reason");
        }
        if (this.fault.getRole() != null) {
            return this.fault.getRole().getText();
        }
        return null;
    }

    public Iterator getFaultSubcodes() {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            throw new UnsupportedOperationException();
        }
        ArrayList faultSubcodes = new ArrayList();
        SOAPFaultSubCode firstSubCodeElement = this.fault.getCode().getSubCode();
        if (firstSubCodeElement != null) {
            String text = firstSubCodeElement.getValue().getText();
            String prefix = text.substring(0, text.indexOf(":"));
            String localPart = text.substring(text.indexOf(":") + 1);
            String uri = firstSubCodeElement.getValue().getNamespace().getNamespaceURI();
            QName qname2 = new QName(uri, localPart, prefix);
            faultSubcodes.add(qname2);
            faultSubcodes = this.getChildSubCodes(firstSubCodeElement, faultSubcodes);
        }
        return faultSubcodes.iterator();
    }

    private ArrayList getChildSubCodes(SOAPFaultSubCode firstSubCodeElement, ArrayList faultSubCodes) {
        SOAPFaultSubCode soapFaultSubCode = firstSubCodeElement.getSubCode();
        if (soapFaultSubCode != null) {
            String text = soapFaultSubCode.getValue().getText();
            String prefix = text.substring(0, text.indexOf(":"));
            String localPart = text.substring(text.indexOf(":") + 1);
            String uri = soapFaultSubCode.getValue().getNamespace().getNamespaceURI();
            QName qname2 = new QName(uri, localPart, prefix);
            faultSubCodes.add(qname2);
        }
        return faultSubCodes;
    }

    public boolean hasDetail() {
        return this.fault.getDetail() != null;
    }

    public void removeAllFaultSubcodes() {
        if (this.factory instanceof SOAP11Factory) {
            throw new UnsupportedOperationException();
        }
        this.fault.getCode().getSubCode().detach();
    }

    public void setFaultCode(QName qname2) throws SOAPException {
        if (qname2.getNamespaceURI() == null || qname2.getNamespaceURI().trim().length() == 0) {
            throw new SOAPException("Unqualified QName object : " + qname2);
        }
        SOAPFactory soapFactory = null;
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            soapFactory = (SOAPFactory)this.element.getOMFactory();
        } else if (this.element.getOMFactory() instanceof SOAP12Factory) {
            if (!qname2.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                throw new SOAPException("Incorrect URI" + qname2.getNamespaceURI());
            }
            soapFactory = (SOAPFactory)this.element.getOMFactory();
        } else {
            throw new SOAPException();
        }
        SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode(this.fault);
        SOAPFaultValue soapFaultValue = soapFactory.createSOAPFaultValue(soapFaultCode);
        String prefix = qname2.getPrefix() != null && !qname2.getPrefix().equals("") ? qname2.getPrefix() : this.fault.getQName().getPrefix();
        soapFaultValue.setText(prefix + ":" + qname2.getLocalPart());
        OMNamespaceImpl omNamespace = new OMNamespaceImpl(qname2.getNamespaceURI(), qname2.getPrefix());
        soapFaultValue.setNamespace(omNamespace);
    }

    public void setFaultNode(String s) throws SOAPException {
        SOAPFactory soapFactory = null;
        if ("SOAP 1.1 Protocol".equals(this.getSOAPVersion(this.element))) {
            throw new UnsupportedOperationException("message does not support the SOAP 1.2 concept of Fault Node");
        }
        if ("SOAP 1.2 Protocol".equals(this.getSOAPVersion(this.element))) {
            soapFactory = DOOMAbstractFactory.getSOAP12Factory();
        }
        SOAPFaultNode soapFaultNode = soapFactory.createSOAPFaultNode(this.fault);
        soapFaultNode.setText(s);
        this.fault.setNode(soapFaultNode);
    }

    public void setFaultRole(String uri) throws SOAPException {
        SOAPFactory soapFactory = null;
        if ("SOAP 1.1 Protocol".equals(this.getSOAPVersion(this.element))) {
            throw new UnsupportedOperationException("message does not support the SOAP 1.2 concept of Fault Role");
        }
        if ("SOAP 1.2 Protocol".equals(this.getSOAPVersion(this.element))) {
            soapFactory = DOOMAbstractFactory.getSOAP12Factory();
        }
        SOAPFaultRole soapFaultRole = soapFactory.createSOAPFaultRole(this.fault);
        soapFaultRole.setRoleValue(uri);
        this.fault.setRole(soapFaultRole);
    }

    public Iterator getChildElements(Name name) {
        QName qName = new QName(name.getURI(), name.getLocalName());
        return this.getChildren(this.element.getChildrenWithName(qName));
    }

    public Iterator getChildElements() {
        return this.getChildren(this.element.getChildren());
    }

    private Iterator getChildren(Iterator childIter) {
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            org.w3c.dom.Node domNode = (org.w3c.dom.Node)childIter.next();
            Node saajNode = this.toSAAJNode(domNode);
            if (!(saajNode instanceof SOAPFaultElement)) {
                SOAPFaultElementImpl bodyEle = new SOAPFaultElementImpl((ElementImpl)domNode);
                ((NodeImpl)domNode).setUserData("saaj.node", bodyEle, null);
                childElements.add(bodyEle);
                continue;
            }
            childElements.add(saajNode);
        }
        return childElements.iterator();
    }
}

