/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.Text;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12Factory;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12FaultImpl;
import org.apache.axis2.saaj.PrefixedQName;
import org.apache.axis2.saaj.SOAPBodyElementImpl;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.axis2.saaj.SOAPFaultImpl;
import org.apache.axis2.saaj.TextImplEx;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SOAPBodyImpl
extends SOAPElementImpl
implements javax.xml.soap.SOAPBody {
    private SOAPBody omSOAPBody;
    private boolean isBodyElementAdded;

    public SOAPBodyImpl(SOAPBody omSOAPBody) {
        super((ElementImpl)((Object)omSOAPBody));
        this.omSOAPBody = omSOAPBody;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        if (this.omSOAPBody.hasFault()) {
            throw new SOAPException("A SOAPFault has been already added to this SOAPBody");
        }
        SOAPBodyElementImpl childEle = new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElement(localName));
        childEle.element.setUserData("saaj.node", childEle, null);
        this.element.appendChild(childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", this, null);
        this.isBodyElementAdded = true;
        return childEle;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            throw new SOAPException("Namespace not declared for the give prefix: " + prefix);
        }
        SOAPBodyElementImpl childEle = new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElementNS(namespaceURI, localName));
        childEle.element.setUserData("saaj.node", childEle, null);
        childEle.element.setNamespace(childEle.element.declareNamespace(namespaceURI, prefix));
        this.element.appendChild(childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPElement addChildElement(SOAPElement soapElement) throws SOAPException {
        String namespaceURI = soapElement.getNamespaceURI();
        String prefix = soapElement.getPrefix();
        String localName = soapElement.getLocalName();
        this.element.declareNamespace(namespaceURI, prefix);
        SOAPBodyElementImpl childEle = new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElementNS(namespaceURI, localName));
        Iterator iter = soapElement.getAllAttributes();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            childEle.addAttribute(name, soapElement.getAttributeValue(name));
        }
        iter = soapElement.getChildElements();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof org.w3c.dom.Text) {
                childEle.addTextNode(((org.w3c.dom.Text)o).getData());
                continue;
            }
            childEle.addChildElement((SOAPElement)o);
        }
        childEle.element.setUserData("saaj.node", childEle, null);
        childEle.element.setNamespace(childEle.element.declareNamespace(namespaceURI, prefix));
        this.element.appendChild(childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        if (this.omSOAPBody.hasFault()) {
            throw new SOAPException("A SOAPFault has been already added to this SOAPBody");
        }
        SOAPBodyElementImpl childEle = uri == null || "".equals(uri) ? new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElement(localName)) : new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElementNS(uri, prefix + ":" + localName));
        childEle.element.setUserData("saaj.node", childEle, null);
        childEle.element.setNamespace(childEle.element.declareNamespace(uri, prefix));
        this.element.appendChild(childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", this, null);
        this.isBodyElementAdded = true;
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPFault addFault() throws SOAPException {
        if (this.isBodyElementAdded) {
            throw new SOAPException("A SOAPBodyElement has been already added to this SOAPBody");
        }
        OMNamespace omNamespace = this.omSOAPBody.getNamespace();
        SOAPFaultImpl saajSOAPFault = null;
        if (omNamespace.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && omNamespace.getPrefix().equals("soapenv")) {
            SOAP11FaultImpl fault = new SOAP11FaultImpl(this.omSOAPBody, (SOAPFactory)this.element.getOMFactory());
            saajSOAPFault = new SOAPFaultImpl(fault);
        } else if (omNamespace.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope") && omNamespace.getPrefix().equals("soapenv")) {
            SOAP12FaultImpl fault = new SOAP12FaultImpl(this.omSOAPBody, (SOAPFactory)this.element.getOMFactory());
            saajSOAPFault = new SOAPFaultImpl(fault);
        }
        ((NodeImpl)((Object)this.omSOAPBody.getFault())).setUserData("saaj.node", saajSOAPFault, null);
        return saajSOAPFault;
    }

    public boolean hasFault() {
        return this.omSOAPBody.hasFault();
    }

    public SOAPFault getFault() {
        if (this.omSOAPBody.hasFault()) {
            return (SOAPFault)this.toSAAJNode((org.w3c.dom.Node)((Object)this.omSOAPBody.getFault()));
        }
        return null;
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        return (SOAPBodyElement)this.addChildElement(name);
    }

    public SOAPFault addFault(Name faultCode, String faultString, Locale locale) throws SOAPException {
        org.apache.axiom.soap.impl.dom.SOAPFaultImpl fault = this.element.getOMFactory() instanceof SOAP11Factory ? new SOAP11FaultImpl(this.omSOAPBody, new Exception(faultString), (SOAPFactory)this.element.getOMFactory()) : new SOAP12FaultImpl(this.omSOAPBody, new Exception(faultString), (SOAPFactory)this.element.getOMFactory());
        SOAPFaultImpl faultImpl = new SOAPFaultImpl(fault);
        faultImpl.setFaultCode(faultCode);
        if (locale != null) {
            faultImpl.setFaultString(faultString, locale);
        } else {
            faultImpl.setFaultString(faultString);
        }
        return faultImpl;
    }

    public SOAPFault addFault(Name faultCode, String faultString) throws SOAPException {
        return this.addFault(faultCode, faultString, null);
    }

    public SOAPBodyElement addDocument(Document document) throws SOAPException {
        Element docEle = document.getDocumentElement();
        SOAPElement saajSOAPEle = (SOAPElement)this.toSAAJNode(docEle, this);
        SOAPBodyElementImpl bodyEle = new SOAPBodyElementImpl(((SOAPElementImpl)saajSOAPEle).element);
        this.addChildElement(bodyEle);
        return bodyEle;
    }

    public SOAPBodyElement addBodyElement(QName qname2) throws SOAPException {
        return (SOAPBodyElement)this.addChildElement(qname2);
    }

    public SOAPFault addFault(QName faultcode, String faultString) throws SOAPException {
        return this.addFault(faultcode, faultString, null);
    }

    public SOAPFault addFault(QName faultCode, String faultString, Locale locale) throws SOAPException {
        SOAPFaultImpl faultImpl = null;
        if ("SOAP 1.1 Protocol".equals(this.getSOAPVersion(this.element))) {
            SOAP11FaultImpl fault = new SOAP11FaultImpl(this.omSOAPBody, new Exception(faultString), (SOAPFactory)this.element.getOMFactory());
            faultImpl = new SOAPFaultImpl(fault);
        } else if ("SOAP 1.2 Protocol".equals(this.getSOAPVersion(this.element))) {
            SOAP12FaultImpl fault = new SOAP12FaultImpl(this.omSOAPBody, new Exception(faultString), (SOAPFactory)this.element.getOMFactory());
            faultImpl = new SOAPFaultImpl(fault);
        }
        if (faultImpl != null) {
            faultImpl.setFaultCode(faultCode);
            if (locale != null) {
                faultImpl.setFaultString(faultString, locale);
            } else {
                faultImpl.setFaultString(faultString);
            }
        }
        return faultImpl;
    }

    public Document extractContentAsDocument() throws SOAPException {
        Document document;
        Iterator childElements = this.getChildElements();
        org.w3c.dom.Node domNode = null;
        int childCount = 0;
        while (childElements.hasNext()) {
            domNode = (org.w3c.dom.Node)childElements.next();
            if (++childCount <= 1) continue;
            throw new SOAPException("SOAPBody contains more than one child element");
        }
        this.removeContents();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element element = document.createElementNS(domNode.getNamespaceURI(), domNode.getLocalName());
            element.setNodeValue(domNode.getNodeValue());
            document.appendChild(element);
        }
        catch (ParserConfigurationException e) {
            throw new SOAPException(e);
        }
        return document;
    }

    private Node toSAAJNode(org.w3c.dom.Node node, SOAPElement parent) throws SOAPException {
        NamespaceImpl ns;
        String localname;
        if (node == null) {
            return null;
        }
        if (node instanceof org.w3c.dom.Text) {
            org.w3c.dom.Text domText = (org.w3c.dom.Text)node;
            return new TextImplEx(domText.getData(), parent);
        }
        if (node instanceof Comment) {
            Comment domText = (Comment)node;
            return new TextImplEx("<!--" + domText.getData() + "-->", parent);
        }
        Element domEle = (Element)node;
        int indexOfColon = domEle.getTagName().indexOf(":");
        if (indexOfColon != -1) {
            localname = domEle.getTagName().substring(indexOfColon + 1);
            ns = new NamespaceImpl(domEle.getNamespaceURI(), domEle.getTagName().substring(0, indexOfColon));
        } else {
            localname = domEle.getLocalName();
            ns = new NamespaceImpl(domEle.getNamespaceURI(), domEle.getPrefix());
        }
        ElementImpl eleImpl = new ElementImpl((DocumentImpl)this.getOwnerDocument(), localname, ns, this.element.getOMFactory());
        SOAPElementImpl saajEle = new SOAPElementImpl(eleImpl);
        saajEle.setParentElement(parent);
        NamedNodeMap domAttrs = domEle.getAttributes();
        for (int i = 0; i < domAttrs.getLength(); ++i) {
            org.w3c.dom.Node attrNode = domAttrs.item(i);
            saajEle.addAttribute(new PrefixedQName(attrNode.getNamespaceURI(), attrNode.getLocalName(), attrNode.getPrefix()), attrNode.getNodeValue());
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childSAAJNode = this.toSAAJNode(childNodes.item(i), saajEle);
            if (childSAAJNode instanceof Text) {
                saajEle.addTextNode(childSAAJNode.getValue());
                continue;
            }
            saajEle.addChildElement((SOAPElement)childSAAJNode);
        }
        return saajEle;
    }

    public void detachNode() {
        this.detach();
    }

    public OMNode detach() {
        this.parentElement = null;
        return this.element.detach();
    }

    public Iterator getChildElements(Name name) {
        QName qName = new QName(name.getURI(), name.getLocalName());
        return this.getChildren(this.element.getChildrenWithName(qName));
    }

    public SOAPElement addAttribute(QName qname2, String value) throws SOAPException {
        OMNamespace omNamespace = null;
        if ("SOAP 1.1 Protocol".equals(this.getSOAPVersion(this.element))) {
            SOAP11Factory soapFactory = new SOAP11Factory();
            omNamespace = soapFactory.createOMNamespace(qname2.getNamespaceURI(), qname2.getPrefix());
        } else if ("SOAP 1.2 Protocol".equals(this.getSOAPVersion(this.element))) {
            SOAP12Factory soapFactory = new SOAP12Factory();
            omNamespace = soapFactory.createOMNamespace(qname2.getNamespaceURI(), qname2.getPrefix());
        }
        this.element.addAttribute(qname2.getLocalPart(), value, omNamespace);
        return this;
    }

    public SOAPElement addChildElement(QName qname2) throws SOAPException {
        if (this.omSOAPBody.hasFault()) {
            throw new SOAPException("A SOAPFault has been already added to this SOAPBody");
        }
        SOAPBodyElementImpl childEle = qname2.getNamespaceURI() == null || "".equals(qname2.getNamespaceURI()) ? new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElement(qname2.getLocalPart())) : new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElementNS(qname2.getNamespaceURI(), qname2.getPrefix() + ":" + qname2.getLocalPart()));
        childEle.element.setUserData("saaj.node", childEle, null);
        childEle.element.setNamespace(childEle.element.declareNamespace(qname2.getNamespaceURI(), qname2.getPrefix()));
        this.element.appendChild(childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", this, null);
        this.isBodyElementAdded = true;
        childEle.setParentElement(this);
        return childEle;
    }

    public QName createQName(String localName, String prefix) throws SOAPException {
        if (this.element.getOMFactory() instanceof SOAP11Factory) {
            return super.createQName(localName, prefix);
        }
        if (this.element.getOMFactory() instanceof SOAP12Factory) {
            if (this.element.findNamespaceURI(prefix) == null) {
                throw new SOAPException("Only Namespace Qualified elements are allowed");
            }
            return super.createQName(localName, prefix);
        }
        throw new UnsupportedOperationException();
    }

    public Iterator getAllAttributesAsQNames() {
        return super.getAllAttributesAsQNames();
    }

    public String getAttributeValue(QName qname2) {
        return super.getAttributeValue(qname2);
    }

    public Iterator getChildElements(QName qname2) {
        return super.getChildElements(qname2);
    }

    public QName getElementQName() {
        return super.getElementQName();
    }

    public boolean removeAttribute(QName qname2) {
        return super.removeAttribute(qname2);
    }

    public SOAPElement setElementQName(QName qname2) throws SOAPException {
        return super.setElementQName(qname2);
    }

    public Iterator getChildElements() {
        return this.getChildren(this.element.getChildren());
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        return super.addTextNode(text);
    }

    private Iterator getChildren(Iterator childIter) {
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            org.w3c.dom.Node domNode = (org.w3c.dom.Node)childIter.next();
            Node saajNode = this.toSAAJNode(domNode);
            if (saajNode instanceof Text) {
                childElements.add(saajNode);
                continue;
            }
            if (!(saajNode instanceof SOAPBodyElement)) {
                if (!(domNode instanceof ElementImpl)) continue;
                if (this.omSOAPBody.hasFault()) {
                    SOAPFactory omFactory = (SOAPFactory)this.element.getOMFactory();
                    org.apache.axiom.soap.impl.dom.SOAPFaultImpl fault = omFactory instanceof SOAP11Factory ? new SOAP11FaultImpl(this.omSOAPBody, omFactory) : new SOAP12FaultImpl(this.omSOAPBody, omFactory);
                    SOAPFaultImpl saajSOAPFault = new SOAPFaultImpl(fault);
                    ((NodeImpl)((Object)this.omSOAPBody.getFault())).setUserData("saaj.node", saajSOAPFault, null);
                    childElements.add(saajSOAPFault);
                    continue;
                }
                SOAPBodyElementImpl saajBodyEle = new SOAPBodyElementImpl((ElementImpl)domNode);
                ((NodeImpl)domNode).setUserData("saaj.node", saajBodyEle, null);
                childElements.add(saajBodyEle);
                continue;
            }
            childElements.add(saajNode);
        }
        return childElements.iterator();
    }
}

