/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.reader.NullXMLStreamReader;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.util.StreamWrapper;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.java2wsdl.utils.TypeTable;

public class RPCUtil {
    private static String RETURN_WRAPPER = "return";

    public static void processResponse(SOAPFactory fac, Object resObject, OMElement bodyContent, OMNamespace ns, SOAPEnvelope envelope, Method method, boolean qualified, TypeTable typeTable) {
        if (resObject != null) {
            if (resObject instanceof OMElement) {
                OMElement result = (OMElement)resObject;
                bodyContent = fac.createOMElement(method.getName() + "Response", ns);
                OMElement resWrapper = qualified ? fac.createOMElement(RETURN_WRAPPER, ns.getNamespaceURI(), ns.getPrefix()) : fac.createOMElement(RETURN_WRAPPER, null);
                resWrapper.addChild(result);
                bodyContent.addChild(resWrapper);
            } else if (SimpleTypeMapper.isSimpleType(resObject)) {
                bodyContent = fac.createOMElement(method.getName() + "Response", ns);
                OMElement child = qualified ? fac.createOMElement(RETURN_WRAPPER, ns) : fac.createOMElement(RETURN_WRAPPER, null);
                child.addChild(fac.createOMText((OMContainer)child, SimpleTypeMapper.getStringValue(resObject)));
                bodyContent.addChild(child);
            } else {
                bodyContent = fac.createOMElement(method.getName() + "Response", ns);
                QName returnWrapper = qualified ? new QName(ns.getNamespaceURI(), RETURN_WRAPPER, ns.getPrefix()) : new QName(RETURN_WRAPPER);
                XMLStreamReader xr = BeanUtil.getPullParser(resObject, returnWrapper, typeTable, qualified);
                StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getOMFactory(), new StreamWrapper(xr));
                OMElement documentElement = stAXOMBuilder.getDocumentElement();
                if (documentElement != null) {
                    bodyContent.addChild(documentElement);
                }
            }
        }
        if (bodyContent != null) {
            envelope.getBody().addChild(bodyContent);
        }
    }

    public static Object[] processRequest(OMElement methodElement, Method method, ObjectSupplier objectSupplier) throws AxisFault {
        Object[] parameters = method.getParameterTypes();
        return BeanUtil.deserialize(methodElement, parameters, objectSupplier);
    }

    public static OMElement getResponseElement(QName resname, Object[] objs, boolean qualified, TypeTable typeTable) {
        if (qualified) {
            return BeanUtil.getOMElement(resname, objs, new QName(resname.getNamespaceURI(), RETURN_WRAPPER, resname.getPrefix()), qualified, typeTable);
        }
        return BeanUtil.getOMElement(resname, objs, new QName(RETURN_WRAPPER), qualified, typeTable);
    }

    public static OMElement getResponseElementForArray(QName resname, Object[] objs, boolean qualified, TypeTable typeTable) {
        if (qualified) {
            return BeanUtil.getOMElement(resname, objs, new QName(resname.getNamespaceURI(), RETURN_WRAPPER, resname.getPrefix()), qualified, typeTable);
        }
        return BeanUtil.getOMElement(resname, objs, new QName(RETURN_WRAPPER), qualified, typeTable);
    }

    public static void processResponse(Object resObject, AxisService service, Method method, SOAPEnvelope envelope, SOAPFactory fac, OMNamespace ns, OMElement bodyContent, MessageContext outMessage) throws Exception {
        QName elementQName = outMessage.getAxisMessage().getElementQName();
        if (resObject == null) {
            QName resName = service.isElementFormDefault() ? new QName(service.getSchematargetNamespace(), RETURN_WRAPPER, service.getSchematargetNamespacePrefix()) : new QName(RETURN_WRAPPER);
            NullXMLStreamReader xr = new NullXMLStreamReader(resName);
            StreamWrapper parser = new StreamWrapper(xr);
            StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getSOAP11Factory(), parser);
            ns = fac.createOMNamespace(service.getSchematargetNamespace(), service.getSchematargetNamespacePrefix());
            OMElement bodyChild = fac.createOMElement(method.getName() + "Response", ns);
            bodyChild.addChild(stAXOMBuilder.getDocumentElement());
            envelope.getBody().addChild(bodyChild);
        } else if (resObject instanceof Object[]) {
            QName resName = new QName(elementQName.getNamespaceURI(), method.getName() + "Response", elementQName.getPrefix());
            OMElement bodyChild = RPCUtil.getResponseElement(resName, (Object[])resObject, service.isElementFormDefault(), service.getTypeTable());
            envelope.getBody().addChild(bodyChild);
        } else if (resObject.getClass().isArray()) {
            Object[] objArray;
            int length = Array.getLength(resObject);
            if (resObject instanceof byte[]) {
                objArray = new Object[]{Base64.encode((byte[])resObject)};
            } else {
                objArray = new Object[length];
                for (int i = 0; i < length; ++i) {
                    objArray[i] = Array.get(resObject, i);
                }
            }
            QName resName = new QName(elementQName.getNamespaceURI(), method.getName() + "Response", elementQName.getPrefix());
            OMElement bodyChild = RPCUtil.getResponseElementForArray(resName, objArray, service.isElementFormDefault(), service.getTypeTable());
            envelope.getBody().addChild(bodyChild);
        } else if (SimpleTypeMapper.isCollection(resObject.getClass())) {
            Collection collection = (Collection)resObject;
            int size = collection.size();
            Object[] values = new Object[size];
            int count = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                values[count] = iterator.next();
                ++count;
            }
            QName resName = new QName(elementQName.getNamespaceURI(), method.getName() + "Response", elementQName.getPrefix());
            OMElement bodyChild = RPCUtil.getResponseElement(resName, values, service.isElementFormDefault(), service.getTypeTable());
            envelope.getBody().addChild(bodyChild);
        } else if (service.isElementFormDefault()) {
            RPCUtil.processResponse(fac, resObject, bodyContent, ns, envelope, method, service.isElementFormDefault(), service.getTypeTable());
        } else {
            RPCUtil.processResponse(fac, resObject, bodyContent, ns, envelope, method, service.isElementFormDefault(), null);
        }
        outMessage.setEnvelope(envelope);
    }

    private static String getReturnName(AxisMessage outMessage) {
        XmlSchemaObjectCollection xmlSchemaObjectCollection;
        XmlSchemaObject schemaElement;
        XmlSchemaSequence xmlSchemaSequence;
        XmlSchemaObjectCollection items;
        XmlSchemaComplexType xmlSchemaComplexType;
        XmlSchemaParticle particle2;
        XmlSchemaElement element;
        if (outMessage != null && (element = outMessage.getSchemaElement()) instanceof XmlSchemaComplexType && (particle2 = (xmlSchemaComplexType = (XmlSchemaComplexType)((Object)element)).getParticle()) instanceof XmlSchemaSequence && (items = (xmlSchemaSequence = (XmlSchemaSequence)particle2).getItems()) instanceof XmlSchemaObjectCollection && (schemaElement = (xmlSchemaObjectCollection = items).getItem(0)) instanceof XmlSchemaElement) {
            return ((XmlSchemaElement)schemaElement).getName();
        }
        return RETURN_WRAPPER;
    }
}

