/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.wrapper.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.utility.PropertyDescriptorPlus;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.axis2.jaxws.wrapper.JAXBWrapperTool;
import org.apache.axis2.jaxws.wrapper.impl.JAXBWrapperException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBWrapperToolImpl
implements JAXBWrapperTool {
    private static final Log log = LogFactory.getLog(JAXBWrapperTool.class);

    @Override
    public Object[] unWrap(Object jaxbObject, List<String> childNames, Map<String, PropertyDescriptorPlus> pdMap) throws JAXBWrapperException {
        if (jaxbObject == null) {
            throw new JAXBWrapperException(Messages.getMessage("JAXBWrapperErr1"));
        }
        if (childNames == null) {
            throw new JAXBWrapperException(Messages.getMessage("JAXBWrapperErr2"));
        }
        Object jaxbComplexTypeObj = jaxbObject;
        if (log.isDebugEnabled()) {
            log.debug("Invoking unWrap() method with jaxb object:" + jaxbComplexTypeObj.getClass().getName());
            log.debug("The input child xmlnames are: " + this.toString(childNames));
        }
        this.checkPropertyDescriptorMap(jaxbComplexTypeObj.getClass(), childNames, pdMap);
        ArrayList<Object> objList = new ArrayList<Object>();
        for (String childName : childNames) {
            PropertyDescriptorPlus propInfo = pdMap.get(childName);
            Object object = null;
            try {
                object = propInfo.get(jaxbComplexTypeObj);
            }
            catch (Throwable e) {
                if (log.isDebugEnabled()) {
                    log.debug("An exception " + e.getClass() + "occurred while trying to call get() on " + propInfo);
                    log.debug("The corresponding xml child name is: " + childName);
                }
                throw new JAXBWrapperException(e);
            }
            objList.add(object);
        }
        Object[] jaxbObjects = objList.toArray();
        objList = null;
        return jaxbObjects;
    }

    @Override
    public Object wrap(Class jaxbClass, List<String> childNames, Map<String, Object> childObjects, Map<String, PropertyDescriptorPlus> pdMap) throws JAXBWrapperException {
        if (childNames == null || childObjects == null) {
            throw new JAXBWrapperException(Messages.getMessage("JAXBWrapperErr3"));
        }
        if (childNames.size() != childObjects.size()) {
            throw new JAXBWrapperException(Messages.getMessage("JAXBWrapperErr4"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Invoking unwrap() method to create jaxb object:" + jaxbClass.getName());
            log.debug("The input child xmlnames are: " + this.toString(childNames));
        }
        this.checkPropertyDescriptorMap(jaxbClass, childNames, pdMap);
        Object jaxbObject = null;
        try {
            jaxbObject = jaxbClass.newInstance();
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("An exception " + t.getClass() + "occurred while trying to create jaxbobject  " + jaxbClass.getName());
            }
            throw new JAXBWrapperException(t);
        }
        for (String childName : childNames) {
            PropertyDescriptorPlus propInfo = pdMap.get(childName);
            Object value = childObjects.get(childName);
            try {
                propInfo.set(jaxbObject, value);
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug("An exception " + t.getClass() + "occurred while trying to call set() on  " + propInfo);
                    log.debug("The corresponding xml child name is: " + childName);
                    String name = value == null ? "<null>" : value.getClass().getName();
                    log.debug("The corresponding value object is: " + name);
                }
                throw new JAXBWrapperException(t);
            }
        }
        return jaxbObject;
    }

    private void checkPropertyDescriptorMap(Class jaxbClass, List<String> xmlChildNames, Map<String, PropertyDescriptorPlus> pdMap) throws JAXBWrapperException {
        if (log.isDebugEnabled()) {
            for (int i = 0; i < xmlChildNames.size(); ++i) {
                String xmlChildName = xmlChildNames.get(i);
                PropertyDescriptorPlus pd = pdMap.get(xmlChildName);
                if (pd != null) continue;
                log.debug("Error occurred trying to match an xml name to a child of a jaxb object");
                log.debug("  The JAXBClass is:" + jaxbClass.getName());
                log.debug("  The child name that we are looking for is:" + xmlChildName);
                log.debug("  The JAXBClass has the following child xml names:" + this.toString(pdMap.keySet()));
                log.debug("  Complete list of child names that we are looking for:" + this.toString(xmlChildNames));
                throw new JAXBWrapperException(Messages.getMessage("JAXBWrapperErr6", jaxbClass.getName(), xmlChildName));
            }
        }
    }

    private String toString(Collection<String> collection) {
        String text = "[";
        if (collection == null) {
            return "[]";
        }
        boolean first = true;
        for (String name : collection) {
            if (first) {
                first = false;
                text = text + name;
                continue;
            }
            text = text + "," + name;
        }
        return text + "]";
    }

    @Override
    public Object[] unWrap(Object jaxbObject, List<String> childNames) throws JAXBWrapperException {
        Class<?> jaxbClass = jaxbObject.getClass();
        Map<String, PropertyDescriptorPlus> pdMap = null;
        try {
            pdMap = XMLRootElementUtil.createPropertyDescriptorMap(jaxbClass);
        }
        catch (Throwable t) {
            log.debug("Error occurred to build the PropertyDescriptor map");
            log.debug("  The JAXBClass is:" + jaxbClass.getName());
            throw new JAXBWrapperException(t);
        }
        return this.unWrap(jaxbObject, childNames, pdMap);
    }

    @Override
    public Object wrap(Class jaxbClass, List<String> childNames, Map<String, Object> childObjects) throws JAXBWrapperException {
        Map<String, PropertyDescriptorPlus> pdMap = null;
        try {
            pdMap = XMLRootElementUtil.createPropertyDescriptorMap(jaxbClass);
        }
        catch (Throwable t) {
            log.debug("Error occurred to build the PropertyDescriptor map");
            log.debug("  The JAXBClass is:" + jaxbClass.getName());
            throw new JAXBWrapperException(t);
        }
        return this.wrap(jaxbClass, childNames, childObjects, pdMap);
    }
}

