/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDLWrapper;
import org.apache.axis2.metadata.factory.ResourceFinderFactory;
import org.apache.axis2.metadata.registry.MetadataFactoryRegistry;
import org.apache.axis2.metadata.resource.ResourceFinder;
import org.apache.axis2.wsdl.util.WSDLDefinitionWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDL4JWrapper
implements WSDLWrapper {
    private static final Log log = LogFactory.getLog(WSDL4JWrapper.class);
    private WSDLDefinitionWrapper wsdlDefinition = null;
    private URL wsdlURL;
    private String wsdlExplicitURL;

    public WSDL4JWrapper(URL wsdlURL) throws WSDLException {
        if (log.isDebugEnabled()) {
            log.debug("Looking for wsdl file on client: " + (wsdlURL != null ? wsdlURL.getPath() : null));
        }
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.wsdlURL = wsdlURL;
        try {
            boolean isFileProtocol;
            URL url = wsdlURL;
            String filePath = null;
            boolean bl = isFileProtocol = url != null && "file".equals(url.getProtocol());
            if (isFileProtocol) {
                boolean isRelativePath;
                filePath = url != null ? url.getPath() : null;
                URI uri = null;
                if (url != null) {
                    uri = url.toURI();
                }
                boolean bl2 = isRelativePath = filePath != null && !new File(filePath).isAbsolute();
                if (isRelativePath) {
                    if (log.isDebugEnabled()) {
                        log.debug("WSDL URL has a relative path");
                    }
                    if ((url = this.getAbsoluteURL(classLoader, filePath)) == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("WSDL URL for relative path not found in ClassLoader");
                            log.warn("Unable to read WSDL from relative path, check the relative path");
                            log.info("Relative path example: file:/WEB-INF/wsdl/<wsdlfilename>");
                            log.warn("Using relative path as default wsdl URL to create wsdl Definition.");
                        }
                        url = wsdlURL;
                    } else if (log.isDebugEnabled()) {
                        log.debug("WSDL URL found for relative path: " + filePath + " scheme: " + uri.getScheme());
                    }
                }
            }
            URLConnection urlCon = url.openConnection();
            InputStream is = null;
            try {
                is = this.getInputStream(urlCon);
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Could not open url connection. Trying to use classloader to get another URL.");
                }
                if (filePath != null) {
                    url = this.getAbsoluteURL(classLoader, filePath);
                    if (url == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Could not locate URL for wsdl. Reporting error");
                        }
                        throw new WSDLException("WSDL4JWrapper : ", e.getMessage(), e);
                    }
                    urlCon = url.openConnection();
                    if (log.isDebugEnabled()) {
                        log.debug("Found URL for WSDL from jar");
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Could not get URL from classloader. Reporting error due to no file path.");
                }
                throw new WSDLException("WSDL4JWrapper : ", e.getMessage(), e);
            }
            if (is != null) {
                is.close();
            }
            this.wsdlExplicitURL = urlCon.getURL().toString();
            this.getDefinition();
        }
        catch (FileNotFoundException ex) {
            WSDLException we = new WSDLException("WSDL4JWrapper : ", ex.getMessage(), ex);
            throw we;
        }
        catch (UnknownHostException ex) {
            WSDLException we = new WSDLException("WSDL4JWrapper : ", ex.getMessage(), ex);
            throw we;
        }
        catch (ConnectException ex) {
            WSDLException we = new WSDLException("WSDL4JWrapper : ", ex.getMessage(), ex);
            throw we;
        }
        catch (IOException ex) {
            WSDLException we = new WSDLException("WSDL4JWrapper : ", ex.getMessage(), ex);
            throw we;
        }
        catch (Exception ex) {
            throw new WSDLException("WSDL4JWrapper : ", ex.getMessage(), ex);
        }
    }

    private URL getAbsoluteURL(ClassLoader classLoader, String filePath) {
        URL url = classLoader.getResource(filePath);
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug("Could not get URL from classloader. Looking in a jar.");
            }
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlLoader = (URLClassLoader)classLoader;
                url = this.getURLFromJAR(urlLoader, this.wsdlURL);
            }
        }
        return url;
    }

    private URL getURLFromJAR(URLClassLoader urlLoader, URL relativeURL) {
        URL[] urlList = null;
        ResourceFinderFactory rff = (ResourceFinderFactory)MetadataFactoryRegistry.getFactory(ResourceFinderFactory.class);
        ResourceFinder cf = rff.getResourceFinder();
        urlList = cf.getURLs(urlLoader);
        if (urlList == null) {
            if (log.isDebugEnabled()) {
                log.debug("No URL's found in URL ClassLoader");
            }
            ExceptionFactory.makeWebServiceException(Messages.getMessage("WSDL4JWrapperErr1"));
        }
        for (URL url : urlList) {
            File f;
            if (!"file".equals(url.getProtocol()) || !(f = new File(url.getPath())).exists() || f.isDirectory()) continue;
            try {
                JarFile jf = new JarFile(f);
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    String relativePath;
                    JarEntry je = entries.nextElement();
                    String name = je.getName();
                    if (!name.endsWith(".wsdl") || !(relativePath = relativeURL.getPath()).endsWith(name)) continue;
                    String path = f.getAbsolutePath();
                    if (path != null && path.indexOf("/") == 0) {
                        path = path.substring(1, path.length());
                    }
                    URL absoluteUrl = new URL("jar:file:/" + path + "!/" + je.getName());
                    return absoluteUrl;
                }
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(e);
            }
        }
        return null;
    }

    private static WSDLReader getWSDLReader() throws WSDLException {
        WSDLReader reader;
        try {
            reader = (WSDLReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WSDLException {
                    WSDLFactory factory = WSDLFactory.newInstance();
                    return factory.newWSDLReader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (WSDLException)e.getException();
        }
        reader.setFeature("javax.wsdl.verbose", false);
        return reader;
    }

    public WSDL4JWrapper(URL wsdlURL, Definition wsdlDefinition) throws WSDLException {
        this.wsdlURL = wsdlURL;
        this.wsdlDefinition = wsdlDefinition != null && !(wsdlDefinition instanceof WSDLDefinitionWrapper) ? new WSDLDefinitionWrapper(wsdlDefinition, wsdlURL) : (WSDLDefinitionWrapper)wsdlDefinition;
    }

    public WSDL4JWrapper(Definition wsdlDefinition) throws WSDLException {
        this.wsdlDefinition = wsdlDefinition != null && !(wsdlDefinition instanceof WSDLDefinitionWrapper) ? new WSDLDefinitionWrapper(wsdlDefinition) : (WSDLDefinitionWrapper)wsdlDefinition;
        if (this.wsdlDefinition != null) {
            String baseURI = wsdlDefinition.getDocumentBaseURI();
            try {
                this.wsdlURL = new URL(baseURI);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Definition getDefinition() {
        Definition def;
        if (this.wsdlDefinition == null && (def = this.loadDefinition()) != null) {
            this.wsdlDefinition = new WSDLDefinitionWrapper(def);
        }
        return this.wsdlDefinition;
    }

    public Definition getUnwrappedDefinition() {
        Definition def = this.wsdlDefinition == null ? this.loadDefinition() : (this.wsdlDefinition instanceof WSDLDefinitionWrapper ? this.wsdlDefinition.getUnwrappedDefinition() : this.wsdlDefinition);
        return def;
    }

    public Definition loadDefinition() {
        Definition def = null;
        if (this.wsdlExplicitURL != null) {
            try {
                def = (Definition)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSDLException {
                        WSDLReader reader = WSDL4JWrapper.getWSDLReader();
                        return reader.readWSDL(WSDL4JWrapper.this.wsdlExplicitURL);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception thrown from AccessController: " + e);
                }
                throw ExceptionFactory.makeWebServiceException(e.getException());
            }
        }
        if (log.isDebugEnabled()) {
            if (def != null) {
                log.debug("loadDefinition() returning a NON-NULL definition");
            } else {
                log.debug("loadDefinition() returning a NULL definition");
            }
        }
        return def;
    }

    public Binding getFirstPortBinding(QName serviceQname) {
        Service service = this.getService(serviceQname);
        if (service == null) {
            return null;
        }
        Map map = this.getService(serviceQname).getPorts();
        if (map == null || map.isEmpty()) {
            return null;
        }
        Iterator i$ = map.values().iterator();
        if (i$.hasNext()) {
            Object listObject = i$.next();
            Port wsdlPort = (Port)listObject;
            return wsdlPort.getBinding();
        }
        return null;
    }

    public String getOperationName(QName serviceQname, QName portQname) {
        Port port = this.getPort(serviceQname, portQname);
        Binding binding = port.getBinding();
        if (binding == null) {
            return null;
        }
        List operations = binding.getBindingOperations();
        Iterator i$ = operations.iterator();
        if (i$.hasNext()) {
            Object opObj = i$.next();
            BindingOperation operation = (BindingOperation)opObj;
            return operation.getName();
        }
        return null;
    }

    private Port getPort(QName serviceQname, QName eprQname) {
        Service service = this.getService(serviceQname);
        if (service == null) {
            return null;
        }
        return service.getPort(eprQname.getLocalPart());
    }

    public ArrayList getPortBinding(QName serviceQname) {
        Map map = this.getService(serviceQname).getPorts();
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Binding> portBindings = new ArrayList<Binding>();
        for (Object listObject : map.values()) {
            Port wsdlPort = (Port)listObject;
            Binding binding = wsdlPort.getBinding();
            if (binding == null) continue;
            portBindings.add(binding);
        }
        return portBindings;
    }

    public String getPortBinding(QName serviceQname, QName portQname) {
        Port port = this.getPort(serviceQname, portQname);
        if (port == null) {
            return null;
        }
        Binding binding = port.getBinding();
        return binding.getQName().getLocalPart();
    }

    public String[] getPorts(QName serviceQname) {
        String[] portNames = null;
        Service service = this.getService(serviceQname);
        if (service == null) {
            return null;
        }
        Map map = service.getPorts();
        if (map == null || map.isEmpty()) {
            return null;
        }
        portNames = new String[map.values().size()];
        Iterator iter = map.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Port wsdlPort = (Port)iter.next();
            if (wsdlPort != null) {
                portNames[i] = wsdlPort.getName();
            }
            ++i;
        }
        return portNames;
    }

    public Service getService(QName serviceQname) {
        if (serviceQname == null) {
            return null;
        }
        Definition def = this.getDefinition();
        if (def != null) {
            return def.getService(serviceQname);
        }
        return null;
    }

    public String getSOAPAction(QName serviceQname) {
        Binding binding = this.getFirstPortBinding(serviceQname);
        if (binding == null) {
            return null;
        }
        List operations = binding.getBindingOperations();
        for (Object opObj : operations) {
            BindingOperation operation = (BindingOperation)opObj;
            List exElements = operation.getExtensibilityElements();
            for (Object elObj : exElements) {
                ExtensibilityElement exElement = (ExtensibilityElement)elObj;
                if (!this.isSoapOperation(exElement)) continue;
                SOAPOperation soapOperation = (SOAPOperation)exElement;
                return soapOperation.getSoapActionURI();
            }
        }
        return null;
    }

    public String getSOAPAction(QName serviceQname, QName portQname) {
        Port port = this.getPort(serviceQname, portQname);
        if (port == null) {
            return null;
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            return null;
        }
        List operations = binding.getBindingOperations();
        for (Object opObj : operations) {
            BindingOperation operation = (BindingOperation)opObj;
            List exElements = operation.getExtensibilityElements();
            for (Object elObj : exElements) {
                ExtensibilityElement exElement = (ExtensibilityElement)elObj;
                if (!this.isSoapOperation(exElement)) continue;
                SOAPOperation soapOperation = (SOAPOperation)exElement;
                return soapOperation.getSoapActionURI();
            }
        }
        return null;
    }

    public String getSOAPAction(QName serviceQname, QName portQname, QName operationQname) {
        Port port = this.getPort(serviceQname, portQname);
        if (port == null) {
            return null;
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            return null;
        }
        List operations = binding.getBindingOperations();
        if (operations == null) {
            return null;
        }
        ElementExtensible operation = null;
        for (Object opObj : operations) {
            operation = (BindingOperation)opObj;
        }
        List exElements = operation.getExtensibilityElements();
        for (Object elObj : exElements) {
            SOAPOperation soapOperation;
            ExtensibilityElement exElement = (ExtensibilityElement)elObj;
            if (!this.isSoapOperation(exElement) || !(soapOperation = (SOAPOperation)exElement).getElementType().equals(operationQname)) continue;
            return soapOperation.getSoapActionURI();
        }
        return null;
    }

    public URL getWSDLLocation() {
        return this.wsdlURL;
    }

    private boolean isSoapOperation(ExtensibilityElement exElement) {
        return WSDLWrapper.SOAP_11_OPERATION.equals(exElement.getElementType());
    }

    public String getTargetNamespace() {
        Definition def = this.getDefinition();
        if (def != null) {
            return def.getTargetNamespace();
        }
        return null;
    }

    private InputStream getInputStream(URLConnection urlCon) throws Exception {
        final URLConnection finalURLCon = urlCon;
        InputStream is = null;
        try {
            is = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return finalURLCon.getInputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return is;
    }
}

