/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.concurrent.Executor;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.client.PropertyMigrator;
import org.apache.axis2.jaxws.client.dispatch.JAXBDispatch;
import org.apache.axis2.jaxws.client.dispatch.XMLDispatch;
import org.apache.axis2.jaxws.client.proxy.JAXWSProxyHandler;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.handler.HandlerResolverImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.spi.BindingProvider;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.axis2.jaxws.util.WSDLWrapper;
import org.apache.axis2.jaxws.utility.ExecutorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDelegate
extends javax.xml.ws.spi.ServiceDelegate {
    private static final Log log = LogFactory.getLog(ServiceDelegate.class);
    private Executor executor;
    private ServiceDescription serviceDescription;
    private QName serviceQname;
    private ServiceClient serviceClient = null;
    private HandlerResolver handlerResolver = null;

    public ServiceDelegate(URL url, QName qname2, Class clazz) throws WebServiceException {
        this.serviceQname = qname2;
        if (!this.isValidServiceName()) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDelegateConstruct0", ""));
        }
        this.serviceDescription = DescriptionFactory.createServiceDescription(url, this.serviceQname, clazz);
        if (this.isValidWSDLLocation() && !this.isServiceDefined(this.serviceQname)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDelegateConstruct0", this.serviceQname.toString(), url.toString()));
        }
        ApplicationContextMigratorUtil.addApplicationContextMigrator(this.serviceDescription.getAxisConfigContext(), "org.apache.axis2.jaxws.spi.ApplicationContextMigrators", new PropertyMigrator());
    }

    @Override
    public void addPort(QName portName, String bindingId, String endpointAddress) throws WebServiceException {
        if (endpointAddress != null && endpointAddress.trim().length() == 0) {
            ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortErr1", portName != null ? portName.getLocalPart() : "", endpointAddress));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint(this.serviceDescription, null, portName, DescriptionFactory.UpdateType.ADD_PORT);
        endpointDesc.setEndpointAddress(endpointAddress);
        endpointDesc.setClientBindingID(bindingId);
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName qname2, Class<T> clazz, Service.Mode mode) throws WebServiceException {
        if (qname2 == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail0"));
        }
        if (!this.isValidDispatchType(clazz)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchInvalidType"));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint(this.serviceDescription, null, qname2, DescriptionFactory.UpdateType.CREATE_DISPATCH);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail2", qname2.toString()));
        }
        this.addBinding(endpointDesc.getClientBindingID());
        XMLDispatch dispatch = new XMLDispatch(this, endpointDesc);
        if (mode != null) {
            dispatch.setMode(mode);
        } else {
            dispatch.setMode(Service.Mode.PAYLOAD);
        }
        if (this.serviceClient == null) {
            this.serviceClient = this.getServiceClient(qname2);
        }
        dispatch.setServiceClient(this.serviceClient);
        dispatch.setType(clazz);
        return dispatch;
    }

    @Override
    public Dispatch<Object> createDispatch(QName qname2, JAXBContext context, Service.Mode mode) {
        if (qname2 == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail0"));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint(this.serviceDescription, null, qname2, DescriptionFactory.UpdateType.CREATE_DISPATCH);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail2", qname2.toString()));
        }
        this.addBinding(endpointDesc.getClientBindingID());
        JAXBDispatch dispatch = new JAXBDispatch(this, endpointDesc);
        if (mode != null) {
            dispatch.setMode(mode);
        } else {
            dispatch.setMode(Service.Mode.PAYLOAD);
        }
        if (this.serviceClient == null) {
            this.serviceClient = this.getServiceClient(qname2);
        }
        dispatch.setJAXBContext(context);
        dispatch.setServiceClient(this.serviceClient);
        return dispatch;
    }

    @Override
    public <T> T getPort(Class<T> sei) throws WebServiceException {
        return this.getPort(null, sei);
    }

    @Override
    public <T> T getPort(QName portName, Class<T> sei) throws WebServiceException {
        if (!this.isValidWSDLLocation()) {
            // empty if block
        }
        if (sei == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("getPortInvalidSEI", portName.toString(), "null"));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint(this.serviceDescription, sei, portName, DescriptionFactory.UpdateType.GET_PORT);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException("Unable to getPort for port QName " + portName.toString());
        }
        JAXWSProxyHandler proxyHandler = new JAXWSProxyHandler(this, sei, endpointDesc);
        Class[] seiClazz = new Class[]{sei, BindingProvider.class};
        Object proxyClass = Proxy.newProxyInstance(ServiceDelegate.getClassLoader(sei), seiClazz, (InvocationHandler)proxyHandler);
        return sei.cast(proxyClass);
    }

    @Override
    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.getDefaultExecutor();
        }
        return this.executor;
    }

    @Override
    public HandlerResolver getHandlerResolver() {
        if (this.handlerResolver == null) {
            this.handlerResolver = new HandlerResolverImpl(this.serviceDescription);
        }
        return this.handlerResolver;
    }

    @Override
    public Iterator<QName> getPorts() {
        return this.getServiceDescription().getPorts().iterator();
    }

    @Override
    public QName getServiceName() {
        return this.serviceQname;
    }

    @Override
    public URL getWSDLDocumentLocation() {
        return ((ServiceDescriptionWSDL)((Object)this.serviceDescription)).getWSDLLocation();
    }

    @Override
    public void setExecutor(Executor e) {
        if (e == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("cannotSetExcutorToNull"));
        }
        this.executor = e;
    }

    @Override
    public void setHandlerResolver(HandlerResolver handlerresolver) {
        this.handlerResolver = handlerresolver;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    public ServiceClient getServiceClient(QName portQName) throws WebServiceException {
        return this.serviceDescription.getServiceClient(portQName);
    }

    private Executor getDefaultExecutor() {
        ExecutorFactory executorFactory = (ExecutorFactory)FactoryRegistry.getFactory(ExecutorFactory.class);
        return executorFactory.getExecutorInstance(0);
    }

    private boolean isValidServiceName() {
        return this.serviceQname != null && !"".equals(this.serviceQname.toString().trim());
    }

    private boolean isValidWSDLLocation() {
        URL wsdlLocation = this.getWSDLDocumentLocation();
        return wsdlLocation != null && !"".equals(wsdlLocation.toString().trim());
    }

    private WSDLWrapper getWSDLWrapper() {
        return ((ServiceDescriptionWSDL)((Object)this.serviceDescription)).getWSDLWrapper();
    }

    private boolean isServiceDefined(QName serviceName) {
        return this.getWSDLWrapper().getService(serviceName) != null;
    }

    private void addBinding(String bindingId) {
        if (bindingId != null) {
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                // empty if block
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                // empty if block
            }
            if (bindingId.equals("http://www.w3.org/2004/08/wsdl/http")) {
                // empty if block
            }
        }
    }

    private boolean isValidDispatchType(Class clazz) {
        return clazz != null && (clazz == String.class || clazz == Source.class || clazz == DataSource.class || clazz == SOAPMessage.class || clazz == OMElement.class);
    }

    private static ClassLoader getClassLoader(final Class cls) {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return cls.getClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }
}

