/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.endpoint;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.binding.BindingUtils;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.transport.http.HTTPWorkerFactory;
import org.apache.axis2.transport.http.server.SimpleHttpServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends Endpoint {
    private boolean published;
    private Object implementor;
    private EndpointDescription endpointDesc;
    private Binding binding;
    private SimpleHttpServer server;

    public EndpointImpl(Object o) {
        this.implementor = o;
        this.initialize();
    }

    public EndpointImpl(Object o, Binding bnd, EndpointDescription ed) {
        this.implementor = o;
        this.binding = bnd;
        this.endpointDesc = ed;
        this.initialize();
    }

    private void initialize() {
        if (this.implementor == null) {
            throw ExceptionFactory.makeWebServiceException("The implementor object cannot be null");
        }
        if (this.endpointDesc == null) {
            ServiceDescription sd = DescriptionFactory.createServiceDescription(this.implementor.getClass());
            this.endpointDesc = sd.getEndpointDescriptions_AsCollection().iterator().next();
        }
        if (this.endpointDesc != null & this.binding == null) {
            this.binding = BindingUtils.createBinding(this.endpointDesc);
        }
        this.published = false;
    }

    @Override
    public List<Source> getMetadata() {
        return null;
    }

    @Override
    public void setMetadata(List<Source> list) {
    }

    @Override
    public Map<String, Object> getProperties() {
        return null;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public Executor getExecutor() {
        return null;
    }

    @Override
    public Object getImplementor() {
        return this.implementor;
    }

    @Override
    public boolean isPublished() {
        return this.published;
    }

    @Override
    public void publish(Object obj) {
    }

    @Override
    public void publish(String s) {
        ConfigurationContext ctx = this.endpointDesc.getServiceDescription().getAxisConfigContext();
        try {
            AxisService svc = this.endpointDesc.getAxisService();
            ctx.getAxisConfiguration().addService(svc);
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
        ctx.setContextRoot("/");
        HTTPWorkerFactory wf = new HTTPWorkerFactory();
        try {
            this.server = new SimpleHttpServer(ctx, wf, 8080);
            this.server.init();
            this.server.start();
        }
        catch (IOException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
        this.published = true;
    }

    @Override
    public void setExecutor(Executor executor) {
    }

    @Override
    public void stop() {
        try {
            this.server.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

