/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.dispatcher;

import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import javax.jws.soap.SOAPBinding;
import org.apache.axis2.AxisFault;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.factory.MethodMarshallerFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.EndpointCallback;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.dispatcher.JavaDispatcher;
import org.apache.axis2.jaxws.server.endpoint.Utils;
import org.apache.axis2.jaxws.utility.ExecutorFactory;
import org.apache.axis2.jaxws.utility.SingleThreadedExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaBeanDispatcher
extends JavaDispatcher {
    private static final Log log = LogFactory.getLog(JavaBeanDispatcher.class);
    private EndpointDescription endpointDesc = null;

    public JavaBeanDispatcher(Class implClass, Object serviceInstance) {
        super(implClass, serviceInstance);
    }

    public MessageContext invoke(MessageContext mc) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Invoking service endpoint: " + this.serviceImplClass.getName());
            log.debug("Invocation pattern: two way, sync");
        }
        this.initialize(mc);
        OperationDescription operationDesc = Utils.getOperationDescription(mc);
        Object[] methodInputParams = this.createRequestParameters(mc);
        Method target = this.getJavaMethod(mc, this.serviceImplClass);
        if (log.isDebugEnabled()) {
            log.debug("JavaBeanDispatcher about to invoke using OperationDesc: " + operationDesc.toString());
        }
        boolean faultThrown = false;
        Throwable fault = null;
        Object output = null;
        try {
            output = this.invokeTargetOperation(target, methodInputParams);
        }
        catch (Throwable e) {
            faultThrown = true;
            fault = e;
        }
        MessageContext response = null;
        if (operationDesc.isOneWay()) {
            return null;
        }
        if (faultThrown) {
            response = this.createFaultResponse(mc, mc.getMessage().getProtocol(), fault);
            JavaBeanDispatcher.setWebMethodExceptionProperty(response, fault);
        } else {
            response = this.createResponse(mc, mc.getMessage().getProtocol(), methodInputParams, output);
        }
        return response;
    }

    public void invokeOneWay(MessageContext request) {
        if (log.isDebugEnabled()) {
            log.debug("Invoking service endpoint: " + this.serviceImplClass.getName());
            log.debug("Invocation pattern: one way");
        }
        this.initialize(request);
        OperationDescription operationDesc = Utils.getOperationDescription(request);
        Object[] methodInputParams = this.createRequestParameters(request);
        Method target = this.getJavaMethod(request, this.serviceImplClass);
        if (log.isDebugEnabled()) {
            log.debug("JavaBeanDispatcher about to invoke using OperationDesc: " + operationDesc.toString());
        }
        EndpointInvocationContext eic = (EndpointInvocationContext)request.getInvocationContext();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        JavaDispatcher.AsyncInvocationWorker worker = new JavaDispatcher.AsyncInvocationWorker(this, target, methodInputParams, cl, eic);
        FutureTask task = new FutureTask(worker);
        ExecutorFactory ef = (ExecutorFactory)FactoryRegistry.getFactory(ExecutorFactory.class);
        Executor executor = ef.getExecutorInstance(1);
        Boolean disable = (Boolean)request.getProperty("serverDisableThreadSwitch");
        if (disable != null && disable.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("Server side thread switch disabled.  Setting Executor to the SingleThreadedExecutor.");
            }
            executor = new SingleThreadedExecutor();
        }
        executor.execute(task);
    }

    public void invokeAsync(MessageContext request, EndpointCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("Invoking service endpoint: " + this.serviceImplClass.getName());
            log.debug("Invocation pattern: two way, async");
        }
        this.initialize(request);
        OperationDescription operationDesc = Utils.getOperationDescription(request);
        Object[] methodInputParams = this.createRequestParameters(request);
        Method target = this.getJavaMethod(request, this.serviceImplClass);
        if (log.isDebugEnabled()) {
            log.debug("JavaBeanDispatcher about to invoke using OperationDesc: " + operationDesc.toString());
        }
        EndpointInvocationContext eic = (EndpointInvocationContext)request.getInvocationContext();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        JavaDispatcher.AsyncInvocationWorker worker = new JavaDispatcher.AsyncInvocationWorker(this, target, methodInputParams, cl, eic);
        FutureTask task = new FutureTask(worker);
        ExecutorFactory ef = (ExecutorFactory)FactoryRegistry.getFactory(ExecutorFactory.class);
        Executor executor = ef.getExecutorInstance(1);
        Boolean disable = (Boolean)request.getProperty("serverDisableThreadSwitch");
        if (disable != null && disable.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("Server side thread switch disabled.  Setting Executor to the SingleThreadedExecutor.");
            }
            executor = new SingleThreadedExecutor();
        }
        executor.execute(task);
    }

    private void initialize(MessageContext mc) {
        mc.setOperationName(mc.getAxisMessageContext().getAxisOperation().getName());
        mc.setOperationDescription(Utils.getOperationDescription(mc));
        this.endpointDesc = mc.getEndpointDescription();
        String bindingType = this.endpointDesc.getBindingType();
        if (bindingType != null && (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
            mc.getMessage().setMTOMEnabled(true);
        }
        ContextUtils.addWSDLProperties(mc);
    }

    private MethodMarshaller getMethodMarshaller(Protocol protocol, OperationDescription operationDesc) {
        SOAPBinding.Style styleOnSEI = this.endpointDesc.getEndpointInterfaceDescription().getSoapBindingStyle();
        SOAPBinding.Style styleOnMethod = operationDesc.getSoapBindingStyle();
        if (styleOnMethod != null && styleOnSEI != styleOnMethod) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("proxyErr2"));
        }
        return MethodMarshallerFactory.getMarshaller(operationDesc, false);
    }

    protected Method getJavaMethod(MessageContext mc, Class serviceImplClass) {
        OperationDescription opDesc = mc.getOperationDescription();
        if (opDesc == null) {
            throw ExceptionFactory.makeWebServiceException("Operation Description was not set");
        }
        Method returnMethod = opDesc.getMethodFromServiceImpl(serviceImplClass);
        if (returnMethod == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("JavaBeanDispatcherErr1"));
        }
        return returnMethod;
    }

    private Object[] createRequestParameters(MessageContext request) {
        Protocol requestProtocol = request.getMessage().getProtocol();
        MethodMarshaller methodMarshaller = this.getMethodMarshaller(requestProtocol, request.getOperationDescription());
        Object[] methodInputParams = methodMarshaller.demarshalRequest(request.getMessage(), request.getOperationDescription());
        if (log.isDebugEnabled()) {
            log.debug("Unmarshalled parameters for request");
            if (methodInputParams != null) {
                log.debug(methodInputParams.length + " parameters were found.");
            }
        }
        return methodInputParams;
    }

    public MessageContext createResponse(MessageContext request, Object[] input, Object output) {
        return this.createResponse(request, request.getMessage().getProtocol(), input, output);
    }

    public MessageContext createResponse(MessageContext request, Protocol p, Object[] params, Object output) {
        OperationDescription operationDesc = request.getOperationDescription();
        Method method = operationDesc.getMethodFromServiceImpl(this.serviceImplClass);
        MethodMarshaller marshaller = this.getMethodMarshaller(p, request.getOperationDescription());
        Message m = null;
        m = method.getReturnType().getName().equals("void") ? marshaller.marshalResponse(null, params, operationDesc, p) : marshaller.marshalResponse(output, params, operationDesc, p);
        MessageContext response = MessageContextUtils.createResponseMessageContext(request);
        response.setMessage(m);
        EndpointDescription epDesc = request.getEndpointDescription();
        String bindingType = epDesc.getBindingType();
        if (bindingType != null && (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
            if (log.isDebugEnabled()) {
                log.debug("MTOM enabled for the response message.");
            }
            m.setMTOMEnabled(true);
        }
        return response;
    }

    public MessageContext createFaultResponse(MessageContext request, Throwable t) {
        return this.createFaultResponse(request, request.getMessage().getProtocol(), t);
    }

    public MessageContext createFaultResponse(MessageContext request, Protocol p, Throwable t) {
        MethodMarshaller marshaller = this.getMethodMarshaller(p, request.getOperationDescription());
        Message m = marshaller.marshalFaultResponse(t, request.getOperationDescription(), p);
        MessageContext response = MessageContextUtils.createFaultMessageContext(request);
        response.setMessage(m);
        AxisFault axisFault = new AxisFault("The endpoint returned a fault when invoking the target operation.", response.getAxisMessageContext(), t);
        response.setCausedByException(axisFault);
        return response;
    }
}

