/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.MessageReceiverExtension;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.server.EndpointCallback;
import org.apache.axis2.jaxws.server.EndpointController;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSMessageReceiver
implements MessageReceiver,
MessageReceiverExtension {
    private static final Log log = LogFactory.getLog(JAXWSMessageReceiver.class);
    private static String PARAM_SERVICE_CLASS = "ServiceClass";
    public static String PARAM_BINDING = "Binding";

    public void receive(MessageContext axisRequestMsgCtx) throws AxisFault {
        AxisFault faultToReturn = null;
        if (log.isDebugEnabled()) {
            log.debug("new request received");
        }
        AxisService service = axisRequestMsgCtx.getAxisService();
        AxisOperation operation = axisRequestMsgCtx.getAxisOperation();
        String mep = operation.getMessageExchangePattern();
        if (log.isDebugEnabled()) {
            log.debug("MEP: " + mep);
        }
        Parameter svcClassParam = service.getParameter(PARAM_SERVICE_CLASS);
        try {
            if (svcClassParam == null) {
                throw new RuntimeException(Messages.getMessage("JAXWSMessageReceiverNoServiceClass"));
            }
            ThreadContextMigratorUtil.performMigrationToThread("JAXWS-ThreadContextMigrator-List", axisRequestMsgCtx);
            EndpointController endpointCtlr = new EndpointController();
            org.apache.axis2.jaxws.core.MessageContext requestMsgCtx = new org.apache.axis2.jaxws.core.MessageContext(axisRequestMsgCtx);
            requestMsgCtx.setMEPContext(new MEPContext(requestMsgCtx));
            AttachmentsAdapter.install(requestMsgCtx);
            TransportHeadersAdapter.install(requestMsgCtx);
            Binding binding = (Binding)axisRequestMsgCtx.getProperty(PARAM_BINDING);
            EndpointInvocationContext eic = InvocationContextFactory.createEndpointInvocationContext(binding);
            eic.setRequestMessageContext(requestMsgCtx);
            eic.getRequestMessageContext().setProperty("serverDisableThreadSwitch", true);
            if (this.isMepInOnly(mep)) {
                if (log.isDebugEnabled()) {
                    log.debug("Detected a one way invocation.");
                }
                eic.setIsOneWay(true);
                endpointCtlr.invokeOneWay(eic);
            } else if (JavaUtils.isTrueExplicitly(axisRequestMsgCtx.getProperty("IsAddressingProcessed")) && axisRequestMsgCtx.getReplyTo() != null && !axisRequestMsgCtx.getReplyTo().hasAnonymousAddress()) {
                if (log.isDebugEnabled()) {
                    log.debug("Detected an async invocation.");
                }
                EndpointCallback ecb = new EndpointCallback();
                eic.setCallback(ecb);
                endpointCtlr.invokeAsync(eic);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Detected a sync invocation.");
                }
                eic = endpointCtlr.invoke(eic);
                org.apache.axis2.jaxws.core.MessageContext responseMsgCtx = eic.getResponseMessageContext();
                MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
                MessageUtils.putMessageOnMessageContext(responseMsgCtx.getMessage(), axisResponseMsgCtx);
                OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
                opCtx.addMessageContext(axisResponseMsgCtx);
                if (responseMsgCtx.getMessage().isFault()) {
                    faultToReturn = responseMsgCtx.getCausedByException() != null ? responseMsgCtx.getCausedByException() : new AxisFault("An error was detected during JAXWS processing", axisResponseMsgCtx);
                } else {
                    ThreadContextMigratorUtil.performMigrationToContext("JAXWS-ThreadContextMigrator-List", axisResponseMsgCtx);
                    AxisEngine engine2 = new AxisEngine(axisResponseMsgCtx.getConfigurationContext());
                    engine2.send(axisResponseMsgCtx);
                    ThreadContextMigratorUtil.performContextCleanup("JAXWS-ThreadContextMigrator-List", axisResponseMsgCtx);
                }
            }
        }
        catch (Exception e) {
            ThreadContextMigratorUtil.performThreadCleanup("JAXWS-ThreadContextMigrator-List", axisRequestMsgCtx);
            WebServiceException wse = ExceptionFactory.makeWebServiceException(e);
            throw AxisFault.makeFault(wse);
        }
        ThreadContextMigratorUtil.performThreadCleanup("JAXWS-ThreadContextMigrator-List", axisRequestMsgCtx);
        if (faultToReturn != null) {
            throw faultToReturn;
        }
    }

    public boolean isMustUnderstandCheckPostponed(MessageContext axisRequestMsgCtx) {
        AxisService axisSvc = axisRequestMsgCtx.getAxisService();
        if (axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription") != null) {
            Parameter param = axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
            EndpointDescription ed = (EndpointDescription)param.getValue();
            if (log.isDebugEnabled()) {
                log.debug("Check to see if a jaxws handler is configured.");
            }
            return ed.getHandlerChain() != null;
        }
        return true;
    }

    private boolean isMepInOnly(String mep) {
        boolean inOnly = mep.equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/in-only");
        return inOnly;
    }
}

