/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import org.apache.axis2.context.OperationContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointCallback {
    private static final Log log = LogFactory.getLog(EndpointCallback.class);

    public void handleResponse(EndpointInvocationContext eic) {
        MessageContext responseMsgCtx = eic.getResponseMessageContext();
        org.apache.axis2.context.MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
        try {
            MessageUtils.putMessageOnMessageContext(responseMsgCtx.getMessage(), axisResponseMsgCtx);
            OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
            opCtx.addMessageContext(axisResponseMsgCtx);
            ThreadContextMigratorUtil.performMigrationToContext("JAXWS-ThreadContextMigrator-List", axisResponseMsgCtx);
            AxisEngine engine2 = new AxisEngine(axisResponseMsgCtx.getConfigurationContext());
            if (log.isDebugEnabled()) {
                log.debug("Sending async response.");
            }
            engine2.send(axisResponseMsgCtx);
            ThreadContextMigratorUtil.performContextCleanup("JAXWS-ThreadContextMigrator-List", axisResponseMsgCtx);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("An error occurred while attempting to send the async response.");
                t.printStackTrace();
            }
            ThreadContextMigratorUtil.performThreadCleanup("JAXWS-ThreadContextMigrator-List", eic.getRequestMessageContext().getAxisMessageContext());
            this.handleFaultResponse(eic);
        }
    }

    public void handleFaultResponse(EndpointInvocationContext eic) {
        MessageContext responseMsgCtx = eic.getResponseMessageContext();
        org.apache.axis2.context.MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
        try {
            MessageUtils.putMessageOnMessageContext(responseMsgCtx.getMessage(), axisResponseMsgCtx);
            OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
            opCtx.addMessageContext(axisResponseMsgCtx);
            ThreadContextMigratorUtil.performThreadCleanup("JAXWS-ThreadContextMigrator-List", eic.getRequestMessageContext().getAxisMessageContext());
            AxisEngine engine2 = new AxisEngine(axisResponseMsgCtx.getConfigurationContext());
            engine2.sendFault(axisResponseMsgCtx);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

