/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.bind.JAXBElement;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.AnnotationDescImpl;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.axis2.jaxws.wsdl.SchemaReaderException;
import org.apache.axis2.jaxws.wsdl.impl.SchemaReaderImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageSetBuilder {
    private static Log log = LogFactory.getLog(PackageSetBuilder.class);
    private static final Class[] noClass = new Class[0];

    private PackageSetBuilder() {
    }

    public static TreeSet<String> getPackagesFromSchema(ServiceDescription serviceDesc) {
        TreeSet<String> set = new TreeSet<String>();
        ServiceDescriptionWSDL sdw = (ServiceDescriptionWSDL)((Object)serviceDesc);
        Definition wsdlDefinition = sdw.getWSDLDefinition();
        Collection<EndpointDescription> endpointDescs = serviceDesc.getEndpointDescriptions_AsCollection();
        if (endpointDescs != null) {
            for (EndpointDescription ed : endpointDescs) {
                if (wsdlDefinition == null && ed instanceof EndpointDescriptionJava) {
                    String wsdlLocation = ((EndpointDescriptionJava)((Object)ed)).getAnnoWebServiceWSDLLocation();
                    wsdlDefinition = PackageSetBuilder.getWSDLDefinition(wsdlLocation);
                }
                if (wsdlDefinition == null) continue;
                SchemaReaderImpl sr = new SchemaReaderImpl();
                try {
                    Set<String> pkgSet = sr.readPackagesFromSchema(wsdlDefinition);
                    set.addAll(pkgSet);
                }
                catch (SchemaReaderException e) {
                    ExceptionFactory.makeWebServiceException(e);
                }
            }
        }
        return set;
    }

    public static TreeSet<String> getPackagesFromAnnotations(ServiceDescription serviceDesc, MarshalServiceRuntimeDescription msrd) {
        TreeSet<String> set = new TreeSet<String>();
        Collection<EndpointDescription> endpointDescs = serviceDesc.getEndpointDescriptions_AsCollection();
        if (endpointDescs != null) {
            for (EndpointDescription endpointDesc : endpointDescs) {
                set.addAll(PackageSetBuilder.getPackagesFromAnnotations(endpointDesc, msrd));
            }
        }
        return set;
    }

    private static TreeSet<String> getPackagesFromAnnotations(EndpointDescription endpointDesc, MarshalServiceRuntimeDescription msrd) {
        EndpointInterfaceDescription endpointInterfaceDesc = endpointDesc.getEndpointInterfaceDescription();
        if (endpointInterfaceDesc == null) {
            return new TreeSet<String>();
        }
        return PackageSetBuilder.getPackagesFromAnnotations(endpointInterfaceDesc, msrd);
    }

    private static TreeSet<String> getPackagesFromAnnotations(EndpointInterfaceDescription endpointInterfaceDesc, MarshalServiceRuntimeDescription msrd) {
        TreeSet<String> set = new TreeSet<String>();
        OperationDescription[] opDescs = endpointInterfaceDesc.getOperations();
        if (opDescs != null) {
            for (int i = 0; i < opDescs.length; ++i) {
                PackageSetBuilder.getPackagesFromAnnotations(opDescs[i], set, msrd);
            }
        }
        return set;
    }

    private static void getPackagesFromAnnotations(OperationDescription opDesc, TreeSet<String> set, MarshalServiceRuntimeDescription msrd) {
        Class cls;
        FaultDescription[] faultDescs;
        ParameterDescription[] parameterDescs = opDesc.getParameterDescriptions();
        if (parameterDescs != null) {
            for (int i = 0; i < parameterDescs.length; ++i) {
                PackageSetBuilder.getPackagesFromAnnotations(parameterDescs[i], set, msrd);
            }
        }
        if ((faultDescs = opDesc.getFaultDescriptions()) != null) {
            for (int i = 0; i < faultDescs.length; ++i) {
                PackageSetBuilder.getPackagesFromAnnotations(faultDescs[i], set, msrd);
            }
        }
        String pkg = PackageSetBuilder.getPackageFromClassName(msrd.getRequestWrapperClassName(opDesc));
        if (log.isDebugEnabled()) {
            log.debug("Package from Request Wrapper annotation = " + pkg);
        }
        if (pkg != null) {
            set.add(pkg);
        }
        pkg = PackageSetBuilder.getPackageFromClassName(msrd.getResponseWrapperClassName(opDesc));
        if (log.isDebugEnabled()) {
            log.debug("Package from Response Wrapper annotation = " + pkg);
        }
        if (pkg != null) {
            set.add(pkg);
        }
        if ((cls = opDesc.getResultActualType()) != null && cls != Void.TYPE && cls != Void.class) {
            Package returnTypePkg = cls.getPackage();
            if (log.isDebugEnabled()) {
                log.debug("Package from Return Type = " + pkg);
            }
            if (returnTypePkg != null) {
                pkg = returnTypePkg.getName();
                set.add(pkg);
            }
        }
    }

    private static void getPackagesFromAnnotations(ParameterDescription paramDesc, TreeSet<String> set, MarshalServiceRuntimeDescription msrd) {
        Class paramClass = paramDesc.getParameterActualType();
        if (paramClass != null) {
            PackageSetBuilder.setTypeAndElementPackages(paramClass, paramDesc.getTargetNamespace(), paramDesc.getPartName(), set, msrd);
        }
    }

    private static void getPackagesFromAnnotations(FaultDescription faultDesc, TreeSet<String> set, MarshalServiceRuntimeDescription msrd) {
        FaultBeanDesc faultBeanDesc = msrd.getFaultBeanDesc(faultDesc);
        if (faultBeanDesc == null) {
            if (log.isDebugEnabled()) {
                log.debug("faultBeanDesc from MarshallServiceRuntimeDescription is null");
            }
            return;
        }
        String faultBeanName = faultBeanDesc.getFaultBeanClassName();
        if (faultBeanName == null) {
            if (log.isDebugEnabled()) {
                log.debug("FaultBeanName is null");
            }
            return;
        }
        Class faultBean = PackageSetBuilder.loadClass(faultBeanName);
        if (faultBean != null) {
            PackageSetBuilder.setTypeAndElementPackages(faultBean, faultBeanDesc.getFaultBeanNamespace(), faultBeanDesc.getFaultBeanLocalName(), set, msrd);
        }
    }

    private static void setTypeAndElementPackages(Class cls, String namespace, String localPart, TreeSet<String> set, MarshalServiceRuntimeDescription msrd) {
        String pkg;
        Class eClass = PackageSetBuilder.getElement(cls, msrd);
        Class tClass = PackageSetBuilder.getType(cls);
        if (tClass != null) {
            Package typePkg = tClass.getPackage();
            String string = pkg = typePkg != null ? typePkg.getName() : null;
            if (pkg != null) {
                set.add(pkg);
            }
        }
        if (tClass != eClass) {
            if (eClass == null) {
                String pkg2;
                if (namespace != null && namespace.length() > 0 && (pkg2 = PackageSetBuilder.makePackage(namespace)) != null) {
                    set.add(pkg2);
                }
            } else {
                Package elementPkg = eClass.getPackage();
                String string = pkg = elementPkg != null ? elementPkg.getName() : null;
                if (pkg != null) {
                    set.add(pkg);
                }
            }
        }
    }

    private static Class getElement(Class cls, MarshalServiceRuntimeDescription msrd) {
        AnnotationDesc annotationDesc = msrd.getAnnotationDesc(cls);
        if (annotationDesc == null) {
            annotationDesc = AnnotationDescImpl.create(cls);
        }
        if (annotationDesc.hasXmlRootElement()) {
            return cls;
        }
        return null;
    }

    private static Class getType(Class cls) {
        if (JAXBElement.class.isAssignableFrom(cls)) {
            try {
                Method m = cls.getMethod("getValue", noClass);
                return m.getReturnType();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Cannot find JAXBElement.getValue method.");
                }
                return null;
            }
        }
        return cls;
    }

    private static String makePackage(String ns) {
        String pkgName = JavaUtils.getPackageFromNamespace(ns);
        return pkgName;
    }

    private static String getPackageFromClassName(String className) {
        Class clz = PackageSetBuilder.loadClass(className);
        String pkg = clz == null ? null : (clz.getPackage() == null ? "" : clz.getPackage().getName());
        return pkg;
    }

    private static Class loadClass(String className) {
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            Class<?> cls = ClassUtils.getPrimitiveClass(className);
            if (cls == null) {
                cls = Class.forName(className, true, PackageSetBuilder.getContextClassLoader());
            }
            return cls;
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("PackageSetBuilder cannot load the following class:" + className);
            }
            return null;
        }
    }

    private static Definition getWSDLDefinition(String wsdlLoc) {
        Definition wsdlDefinition = null;
        final String wsdlLocation = wsdlLoc;
        if (wsdlLocation != null && wsdlLocation.trim().length() > 0) {
            try {
                wsdlDefinition = (Definition)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException, WSDLException {
                        String baseDir = new File(System.getProperty("basedir", ".")).getCanonicalPath();
                        String wsdlLocationPath = new File(baseDir + File.separator + wsdlLocation).getAbsolutePath();
                        File file = new File(wsdlLocationPath);
                        URL url = file.toURL();
                        if (log.isDebugEnabled()) {
                            log.debug("Reading WSDL from URL:" + url.toString());
                        }
                        WSDL4JWrapper wsdlWrapper = new WSDL4JWrapper(url);
                        return wsdlWrapper.getDefinition();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                ExceptionFactory.makeWebServiceException(e.getException());
            }
        }
        return wsdlDefinition;
    }

    static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    if (cls == null) {
                        cls = Class.forName(className, initialize, classloader);
                    }
                    return cls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (RuntimeException)e.getException();
        }
        return cl;
    }
}

