/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.AnnotationDescImpl;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.FaultBeanDescImpl;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArtifactProcessor {
    private static final Log log = LogFactory.getLog(ArtifactProcessor.class);
    private ServiceDescription serviceDesc;
    private Map<OperationDescription, String> requestWrapperMap = new HashMap<OperationDescription, String>();
    private Map<OperationDescription, String> responseWrapperMap = new HashMap<OperationDescription, String>();
    private Map<FaultDescription, FaultBeanDesc> faultBeanDescMap = new HashMap<FaultDescription, FaultBeanDesc>();
    static final String JAXWS_SUBPACKAGE = "jaxws";

    ArtifactProcessor(ServiceDescription serviceDesc) {
        this.serviceDesc = serviceDesc;
    }

    Map<OperationDescription, String> getRequestWrapperMap() {
        return this.requestWrapperMap;
    }

    Map<OperationDescription, String> getResponseWrapperMap() {
        return this.responseWrapperMap;
    }

    Map<FaultDescription, FaultBeanDesc> getFaultBeanDescMap() {
        return this.faultBeanDescMap;
    }

    void build() {
        for (EndpointDescription ed : this.serviceDesc.getEndpointDescriptions()) {
            if (ed.getEndpointInterfaceDescription() == null) continue;
            for (OperationDescription opDesc : ed.getEndpointInterfaceDescription().getOperations()) {
                String foundResponseWrapperName;
                String responseWrapperName;
                String foundRequestWrapperName;
                String declaringClassName = opDesc.getJavaDeclaringClassName();
                String packageName = ArtifactProcessor.getPackageName(declaringClassName);
                String simpleName = ArtifactProcessor.getSimpleClassName(declaringClassName);
                String methodName = opDesc.getJavaMethodName();
                String requestWrapperName = opDesc.getRequestWrapperClassName();
                if (requestWrapperName == null) {
                    requestWrapperName = packageName.length() > 0 ? packageName + "." + ArtifactProcessor.javaMethodToClassName(methodName) : ArtifactProcessor.javaMethodToClassName(methodName);
                }
                if ((foundRequestWrapperName = ArtifactProcessor.findArtifact(requestWrapperName)) == null) {
                    foundRequestWrapperName = this.missingArtifact(requestWrapperName);
                }
                if (foundRequestWrapperName != null) {
                    this.requestWrapperMap.put(opDesc, foundRequestWrapperName);
                }
                if ((responseWrapperName = opDesc.getResponseWrapperClassName()) == null) {
                    responseWrapperName = packageName.length() > 0 ? packageName + "." + ArtifactProcessor.javaMethodToClassName(methodName) + "Response" : ArtifactProcessor.javaMethodToClassName(methodName) + "Response";
                }
                if ((foundResponseWrapperName = ArtifactProcessor.findArtifact(responseWrapperName)) == null) {
                    foundResponseWrapperName = this.missingArtifact(responseWrapperName);
                }
                if (foundResponseWrapperName != null) {
                    this.responseWrapperMap.put(opDesc, foundResponseWrapperName);
                }
                for (FaultDescription faultDesc : opDesc.getFaultDescriptions()) {
                    FaultBeanDesc faultBeanDesc = this.create(faultDesc, opDesc);
                    this.faultBeanDescMap.put(faultDesc, faultBeanDesc);
                }
            }
        }
    }

    private FaultBeanDesc create(FaultDescription faultDesc, OperationDescription opDesc) {
        String faultBeanNamespace;
        String faultBeanLocalName;
        String foundClassName;
        String faultBeanClassName = faultDesc.getFaultBean();
        if (faultBeanClassName == null || faultBeanClassName.length() == 0) {
            faultBeanClassName = faultDesc.getFaultInfo();
        }
        if (faultBeanClassName == null || faultBeanClassName.length() == 0) {
            String declaringClassName = opDesc.getJavaDeclaringClassName();
            String packageName = ArtifactProcessor.getPackageName(declaringClassName);
            String simpleName = ArtifactProcessor.getSimpleClassName(faultDesc.getExceptionClassName());
            faultBeanClassName = packageName.length() > 0 ? packageName + "." + simpleName + "Bean" : simpleName + "Bean";
        }
        if ((foundClassName = ArtifactProcessor.findArtifact(faultBeanClassName)) == null) {
            faultBeanClassName = this.missingArtifact(faultBeanClassName);
        }
        if (foundClassName != null) {
            faultBeanClassName = foundClassName;
        }
        if (((faultBeanLocalName = faultDesc.getName()) == null || faultBeanLocalName.length() == 0) && faultBeanClassName != null && faultBeanClassName.length() > 0) {
            try {
                Class faultBean = ArtifactProcessor.loadClass(faultBeanClassName);
                AnnotationDesc aDesc = AnnotationDescImpl.create(faultBean);
                if (aDesc.hasXmlRootElement()) {
                    faultBeanLocalName = aDesc.getXmlRootElementName();
                }
            }
            catch (Throwable t) {
                ExceptionFactory.makeWebServiceException(t);
            }
        }
        if (faultBeanLocalName == null || faultBeanLocalName.length() == 0) {
            faultBeanLocalName = ArtifactProcessor.getSimpleClassName(faultDesc.getExceptionClassName()) + "Bean";
        }
        if (((faultBeanNamespace = faultDesc.getTargetNamespace()) == null || faultBeanNamespace.length() == 0) && faultBeanClassName != null && faultBeanClassName.length() > 0) {
            try {
                Class faultBean = ArtifactProcessor.loadClass(faultBeanClassName);
                AnnotationDesc aDesc = AnnotationDescImpl.create(faultBean);
                if (aDesc.hasXmlRootElement()) {
                    faultBeanNamespace = aDesc.getXmlRootElementNamespace();
                }
            }
            catch (Throwable t) {
                ExceptionFactory.makeWebServiceException(t);
            }
        }
        if (faultBeanNamespace == null || faultBeanNamespace.length() == 0) {
            faultBeanNamespace = opDesc.getEndpointInterfaceDescription().getTargetNamespace();
        }
        return new FaultBeanDescImpl(faultBeanClassName, faultBeanLocalName, faultBeanNamespace);
    }

    private static String getPackageName(String className) {
        int index = className.lastIndexOf(".");
        if (index == 0) {
            return "";
        }
        return className.substring(0, index);
    }

    private static String getSimpleClassName(String className) {
        int index = className.lastIndexOf(".");
        if (index == 0) {
            return className;
        }
        return className.substring(index + 1);
    }

    private static String javaMethodToClassName(String methodName) {
        String className = null;
        if (methodName != null) {
            StringBuffer buildClassName = new StringBuffer(methodName);
            buildClassName.replace(0, 1, methodName.substring(0, 1).toUpperCase());
            className = buildClassName.toString();
        }
        return className;
    }

    private String missingArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug("The following class is missing: " + artifactName + " Processing continues.");
        }
        return null;
    }

    private static String findArtifact(String artifactClassName) {
        String originalPackage;
        String returnArtifactClassName = null;
        if (artifactClassName == null) {
            return returnArtifactClassName;
        }
        try {
            ArtifactProcessor.loadClass(artifactClassName);
            returnArtifactClassName = artifactClassName;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (returnArtifactClassName == null && (originalPackage = ArtifactProcessor.getPackageName(artifactClassName)).length() > 0) {
            String alternatePackage = originalPackage + "." + JAXWS_SUBPACKAGE;
            String className = ArtifactProcessor.getSimpleClassName(artifactClassName);
            String alternateWrapperClass = alternatePackage + "." + className;
            try {
                ArtifactProcessor.loadClass(alternateWrapperClass);
                returnArtifactClassName = alternateWrapperClass;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return returnArtifactClassName;
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        return ArtifactProcessor.forName(className, true, ArtifactProcessor.getContextClassLoader());
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    try {
                        if (cls == null) {
                            cls = Class.forName(className, initialize, classloader);
                        }
                        return cls;
                    }
                    catch (NoClassDefFoundError e) {
                        if (log.isDebugEnabled()) {
                            log.debug("ArtifactProcessor cannot load the following class NoClassDefFoundError:" + className);
                        }
                        return cls;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (RuntimeException)e.getException();
        }
        return cl;
    }
}

