/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.injection.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.injection.impl.ResourceInjectionServiceRuntimeDescriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceInjectionServiceRuntimeDescriptionBuilder {
    private ResourceInjectionServiceRuntimeDescriptionBuilder() {
    }

    public static ResourceInjectionServiceRuntimeDescription create(ServiceDescription serviceDesc, Class implClass) {
        ResourceInjectionServiceRuntimeDescriptionImpl desc = new ResourceInjectionServiceRuntimeDescriptionImpl(ResourceInjectionServiceRuntimeDescriptionBuilder.getKey(implClass), serviceDesc);
        boolean value = ResourceInjectionServiceRuntimeDescriptionBuilder.hasResourceAnnotation(implClass);
        desc.setResourceAnnotation(value);
        Method method = ResourceInjectionServiceRuntimeDescriptionBuilder.getPostConstructMethod(implClass);
        desc.setPostConstructMethod(method);
        method = ResourceInjectionServiceRuntimeDescriptionBuilder.getPreDestoryMethod(implClass);
        desc.setPreDestroyMethod(method);
        return desc;
    }

    public static String getKey(Class implClass) {
        return "Resource Injection:" + implClass.getCanonicalName();
    }

    private static boolean hasResourceAnnotation(Class implClass) {
        List<Field> fields = ResourceInjectionServiceRuntimeDescriptionBuilder.getFields(implClass);
        for (Field field : fields) {
            if (ResourceInjectionServiceRuntimeDescriptionBuilder.getAnnotation(field, Resource.class) == null) continue;
            return true;
        }
        List<Method> methods = ResourceInjectionServiceRuntimeDescriptionBuilder.getMethods(implClass);
        for (Method method : methods) {
            if (ResourceInjectionServiceRuntimeDescriptionBuilder.getAnnotation(method, Resource.class) == null) continue;
            return true;
        }
        return false;
    }

    private static Method getPostConstructMethod(Class implClass) {
        List<Method> methods = ResourceInjectionServiceRuntimeDescriptionBuilder.getMethods(implClass);
        for (Method method : methods) {
            if (ResourceInjectionServiceRuntimeDescriptionBuilder.getAnnotation(method, PostConstruct.class) == null) continue;
            return method;
        }
        return null;
    }

    private static Method getPreDestoryMethod(Class implClass) {
        List<Method> methods = ResourceInjectionServiceRuntimeDescriptionBuilder.getMethods(implClass);
        for (Method method : methods) {
            if (ResourceInjectionServiceRuntimeDescriptionBuilder.getAnnotation(method, PreDestroy.class) == null) continue;
            return method;
        }
        return null;
    }

    private static List<Field> getFields(final Class beanClass) {
        List fields = (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<Field> fields = new ArrayList<Field>();
                for (Class cls = beanClass; cls != null; cls = cls.getSuperclass()) {
                    Field[] fieldArray;
                    for (Field field : fieldArray = cls.getDeclaredFields()) {
                        fields.add(field);
                    }
                }
                return fields;
            }
        });
        return fields;
    }

    private static List<Method> getMethods(final Class beanClass) {
        List methods = (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<Method> methods = new ArrayList<Method>();
                for (Class cls = beanClass; cls != null; cls = cls.getSuperclass()) {
                    Method[] methodArray;
                    for (Method method : methodArray = cls.getDeclaredMethods()) {
                        methods.add(method);
                    }
                }
                return methods;
            }
        });
        return methods;
    }

    private static Annotation getAnnotation(final AnnotatedElement element, final Class annotation2) {
        return (Annotation)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return element.getAnnotation(annotation2);
            }
        });
    }
}

