/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.client.Options;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.XMLPart;
import org.apache.axis2.jaxws.message.attachments.AttachmentUtils;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.SAAJConverterFactory;
import org.apache.axis2.jaxws.message.factory.SOAPEnvelopeBlockFactory;
import org.apache.axis2.jaxws.message.factory.XMLPartFactory;
import org.apache.axis2.jaxws.message.factory.XMLStringBlockFactory;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.message.util.SAAJConverter;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message {
    private static final Log log = LogFactory.getLog(MessageImpl.class);
    Protocol protocol = Protocol.unknown;
    XMLPart xmlPart = null;
    boolean mtomEnabled;
    private Map transportHeaders = null;
    Attachments attachments = new Attachments();
    private MessageContext messageContext;
    private boolean postPivot = false;
    private boolean doingSWA = false;
    SAAJConverter converter = null;

    MessageImpl(Protocol protocol) throws WebServiceException, XMLStreamException {
        this.createXMLPart(protocol);
    }

    MessageImpl(OMElement root, Protocol protocol) throws WebServiceException, XMLStreamException {
        this.createXMLPart(root, protocol);
    }

    MessageImpl(SOAPEnvelope root) throws WebServiceException, XMLStreamException {
        this.createXMLPart(root);
    }

    private void createXMLPart(SOAPEnvelope root) throws WebServiceException, XMLStreamException {
        XMLPartFactory factory = (XMLPartFactory)FactoryRegistry.getFactory(XMLPartFactory.class);
        this.xmlPart = factory.createFrom(root);
        this.protocol = this.xmlPart.getProtocol();
        this.xmlPart.setParent(this);
    }

    private void createXMLPart(OMElement root, Protocol protocol) throws WebServiceException, XMLStreamException {
        XMLPartFactory factory = (XMLPartFactory)FactoryRegistry.getFactory(XMLPartFactory.class);
        this.xmlPart = factory.createFrom(root, protocol);
        this.protocol = this.xmlPart.getProtocol();
        this.xmlPart.setParent(this);
    }

    private void createXMLPart(Protocol protocol) throws WebServiceException, XMLStreamException {
        this.protocol = protocol;
        if (protocol.equals((Object)Protocol.unknown)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ProtocolIsNotKnown"));
        }
        XMLPartFactory factory = (XMLPartFactory)FactoryRegistry.getFactory(XMLPartFactory.class);
        this.xmlPart = factory.create(protocol);
        this.xmlPart.setParent(this);
    }

    @Override
    public SOAPMessage getAsSOAPMessage() throws WebServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("start getAsSOAPMessage");
            }
            OMElement element = this.xmlPart.getAsOMElement();
            OMNamespace ns = element.getNamespace();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            element.serialize(outStream);
            byte[] bytes = outStream.toByteArray();
            if (log.isDebugEnabled()) {
                String text = new String(bytes);
                log.debug("  inputstream = " + text);
            }
            if (element.getBuilder() != null && !element.getBuilder().isCompleted()) {
                element.getBuilder().close();
            }
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
            MessageFactory mf = this.getSAAJConverter().createMessageFactory(ns.getNamespaceURI());
            MimeHeaders defaultHeaders = new MimeHeaders();
            if (this.transportHeaders != null) {
                for (Map.Entry entry : this.transportHeaders.entrySet()) {
                    String key = (String)entry.getKey();
                    if (entry.getValue() instanceof String) {
                        if (log.isDebugEnabled()) {
                            log.debug("  add transport header. header =" + key + " value = " + entry.getValue());
                        }
                        defaultHeaders.addHeader(key, (String)entry.getValue());
                        continue;
                    }
                    String[] values = (String[])entry.getValue();
                    for (int i = 0; i < values.length; ++i) {
                        if (log.isDebugEnabled()) {
                            log.debug("  add transport header. header =" + key + " value = " + values[i]);
                        }
                        defaultHeaders.addHeader(key, values[i]);
                    }
                }
            }
            this.getMimeHeaders();
            String contentType = null;
            contentType = ns.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") ? "text/xml" : "application/soap+xml";
            String ctValue = contentType + "; charset=UTF-8";
            defaultHeaders.setHeader("Content-type", ctValue);
            if (log.isDebugEnabled()) {
                log.debug("  setContentType =" + ctValue);
            }
            SOAPMessage soapMessage = mf.createMessage(defaultHeaders, inStream);
            this.createXMLPart(soapMessage.getSOAPPart().getEnvelope());
            String soapPartContentID = this.getSOAPPartContentID();
            if (log.isDebugEnabled()) {
                log.debug("  soapPartContentID =" + soapPartContentID);
            }
            ArrayList<String> dontCopy = new ArrayList<String>();
            if (soapPartContentID != null) {
                dontCopy.add(soapPartContentID);
            }
            Iterator it = soapMessage.getAttachments();
            while (it.hasNext()) {
                AttachmentPart ap = (AttachmentPart)it.next();
                String cid = ap.getContentId();
                if (log.isDebugEnabled()) {
                    log.debug("  add SOAPMessage attachment to Message.  cid = " + cid);
                }
                this.addDataHandler(ap.getDataHandler(), cid);
                dontCopy.add(cid);
            }
            for (String cid : this.getAttachmentIDs()) {
                DataHandler dh = this.attachments.getDataHandler(cid);
                if (dontCopy.contains(cid)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("  add Message attachment to SoapMessage.  cid = " + cid);
                }
                AttachmentPart ap = MessageUtils.createAttachmentPart(cid, dh, soapMessage);
                soapMessage.addAttachmentPart(ap);
            }
            if (log.isDebugEnabled()) {
                log.debug("  The SOAPMessage has the following attachments");
                Iterator it2 = soapMessage.getAttachments();
                while (it2.hasNext()) {
                    AttachmentPart ap = (AttachmentPart)it2.next();
                    log.debug("    AttachmentPart cid=" + ap.getContentId());
                    log.debug("        contentType =" + ap.getContentType());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("end getAsSOAPMessage");
            }
            return soapMessage;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public String getAttachmentID(int index) {
        List<String> cids = this.getAttachmentIDs();
        String spCID = this.getSOAPPartContentID();
        if (log.isDebugEnabled()) {
            log.debug("getAttachmentID for index =" + index);
            for (int i = 0; i < cids.size(); ++i) {
                log.debug("Attachment CID (" + i + ") = " + cids.indexOf(i));
            }
            log.debug("The SOAP Part CID is ignored.  It's CID is (" + spCID + ")");
        }
        int spIndex = spCID == null ? -1 : cids.indexOf(spCID);
        index = spIndex != -1 && spIndex <= index ? index + 1 : index;
        String resultCID = null;
        if (index < cids.size()) {
            resultCID = cids.get(index);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning CID=" + resultCID);
        }
        return resultCID;
    }

    private String getSOAPPartContentID() {
        String contentID = null;
        if (this.messageContext == null) {
            return null;
        }
        try {
            contentID = this.attachments.getSOAPPartContentID();
        }
        catch (RuntimeException e) {
            return null;
        }
        return contentID;
    }

    @Override
    public Object getValue(Object context, BlockFactory blockFactory) throws WebServiceException {
        try {
            Object value = null;
            if (this.protocol == Protocol.rest) {
                Block block = this.xmlPart.getBodyBlock(context, blockFactory);
                if (block != null) {
                    value = block.getBusinessObject(true);
                }
            } else if (blockFactory instanceof SOAPEnvelopeBlockFactory) {
                value = this.getAsSOAPMessage();
            } else {
                OMElement messageOM = this.getAsOMElement();
                String stringValue = ((Object)messageOM).toString();
                String soapNS = this.protocol == Protocol.soap11 ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
                QName soapEnvQname = new QName(soapNS, "Envelope");
                XMLStringBlockFactory stringFactory = (XMLStringBlockFactory)FactoryRegistry.getFactory(XMLStringBlockFactory.class);
                Block stringBlock = stringFactory.createFrom(stringValue, null, soapEnvQname);
                Block block = blockFactory.createFrom(stringBlock, context);
                value = block.getBusinessObject(true);
            }
            return value;
        }
        catch (Throwable e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public List<String> getAttachmentIDs() {
        return this.attachments.getContentIDList();
    }

    @Override
    public DataHandler getDataHandler(String cid) {
        if (cid == null) {
            return null;
        }
        String bcid = this.getBlobCID(cid);
        return this.attachments.getDataHandler(bcid);
    }

    @Override
    public DataHandler removeDataHandler(String cid) {
        String bcid = this.getBlobCID(cid);
        DataHandler dh = this.attachments.getDataHandler(bcid);
        this.attachments.removeDataHandler(bcid);
        return dh;
    }

    private String getBlobCID(String cid) {
        String blobCID = cid;
        if (cid.startsWith("cid:")) {
            blobCID = cid.substring(4);
        }
        return blobCID;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public OMElement getAsOMElement() throws WebServiceException {
        return this.xmlPart.getAsOMElement();
    }

    @Override
    public SOAPEnvelope getAsSOAPEnvelope() throws WebServiceException {
        return this.xmlPart.getAsSOAPEnvelope();
    }

    @Override
    public Block getBodyBlock(int index, Object context, BlockFactory blockFactory) throws WebServiceException {
        return this.xmlPart.getBodyBlock(index, context, blockFactory);
    }

    @Override
    public Block getHeaderBlock(String namespace, String localPart, Object context, BlockFactory blockFactory) throws WebServiceException {
        return this.xmlPart.getHeaderBlock(namespace, localPart, context, blockFactory);
    }

    @Override
    public int getNumBodyBlocks() throws WebServiceException {
        return this.xmlPart.getNumBodyBlocks();
    }

    @Override
    public int getNumHeaderBlocks() throws WebServiceException {
        return this.xmlPart.getNumHeaderBlocks();
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean consume) throws WebServiceException {
        return this.xmlPart.getXMLStreamReader(consume);
    }

    @Override
    public boolean isConsumed() {
        return this.xmlPart.isConsumed();
    }

    @Override
    public void outputTo(XMLStreamWriter writer, boolean consume) throws XMLStreamException, WebServiceException {
        this.xmlPart.outputTo(writer, consume);
    }

    @Override
    public void removeBodyBlock(int index) throws WebServiceException {
        this.xmlPart.removeBodyBlock(index);
    }

    @Override
    public void removeHeaderBlock(String namespace, String localPart) throws WebServiceException {
        this.xmlPart.removeHeaderBlock(namespace, localPart);
    }

    @Override
    public void setBodyBlock(int index, Block block) throws WebServiceException {
        this.xmlPart.setBodyBlock(index, block);
    }

    @Override
    public void setHeaderBlock(String namespace, String localPart, Block block) throws WebServiceException {
        this.xmlPart.setHeaderBlock(namespace, localPart, block);
    }

    @Override
    public String traceString(String indent) {
        return this.xmlPart.traceString(indent);
    }

    private SAAJConverter getSAAJConverter() {
        if (this.converter == null) {
            SAAJConverterFactory factory = (SAAJConverterFactory)FactoryRegistry.getFactory(SAAJConverterFactory.class);
            this.converter = factory.getSAAJConverter();
        }
        return this.converter;
    }

    @Override
    public void addDataHandler(DataHandler dh, String id) {
        if (id.startsWith("<") && id.endsWith(">")) {
            id = id.substring(1, id.length() - 1);
        }
        this.attachments.addDataHandler(id, dh);
    }

    @Override
    public Message getParent() {
        return null;
    }

    @Override
    public void setParent(Message msg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMTOMEnabled() {
        return this.mtomEnabled;
    }

    @Override
    public void setMTOMEnabled(boolean b) {
        this.mtomEnabled = b;
    }

    @Override
    public XMLFault getXMLFault() throws WebServiceException {
        return this.xmlPart.getXMLFault();
    }

    @Override
    public void setXMLFault(XMLFault xmlFault) throws WebServiceException {
        this.xmlPart.setXMLFault(xmlFault);
    }

    @Override
    public boolean isFault() throws WebServiceException {
        return this.xmlPart.isFault();
    }

    @Override
    public String getXMLPartContentType() {
        return this.xmlPart.getXMLPartContentType();
    }

    @Override
    public SOAPBinding.Style getStyle() {
        return this.xmlPart.getStyle();
    }

    @Override
    public void setStyle(SOAPBinding.Style style) throws WebServiceException {
        this.xmlPart.setStyle(style);
    }

    @Override
    public QName getOperationElement() throws WebServiceException {
        return this.xmlPart.getOperationElement();
    }

    @Override
    public void setOperationElement(QName operationQName) throws WebServiceException {
        this.xmlPart.setOperationElement(operationQName);
    }

    @Override
    public Map getMimeHeaders() {
        if (this.transportHeaders == null) {
            this.transportHeaders = new HashMap();
        }
        return this.transportHeaders;
    }

    @Override
    public void setMimeHeaders(Map map) {
        this.transportHeaders = map;
        if (this.transportHeaders == null) {
            this.transportHeaders = new HashMap();
        }
    }

    @Override
    public Block getBodyBlock(Object context, BlockFactory blockFactory) throws WebServiceException {
        return this.xmlPart.getBodyBlock(context, blockFactory);
    }

    @Override
    public void setBodyBlock(Block block) throws WebServiceException {
        this.xmlPart.setBodyBlock(block);
    }

    @Override
    public void setPostPivot() {
        this.postPivot = true;
    }

    @Override
    public boolean isPostPivot() {
        return this.postPivot;
    }

    @Override
    public int getIndirection() {
        return this.xmlPart.getIndirection();
    }

    @Override
    public void setIndirection(int indirection) {
        this.xmlPart.setIndirection(indirection);
    }

    @Override
    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    @Override
    public void setMessageContext(MessageContext messageContext) {
        if (this.messageContext != messageContext) {
            String[] cids;
            Attachments newMap = messageContext.getAxisMessageContext().getAttachmentMap();
            Attachments oldMap = this.attachments;
            for (String cid : oldMap.getAllContentIDs()) {
                DataHandler dh = oldMap.getDataHandler(cid);
                if (dh == null) continue;
                newMap.addDataHandler(cid, dh);
            }
            if (!this.isMTOMEnabled() && (cids = newMap.getAllContentIDs()).length > 0) {
                Options opts = messageContext.getAxisMessageContext().getOptions();
                opts.setProperty("enableSwA", "true");
            }
            if (log.isDebugEnabled()) {
                for (String cid : newMap.getAllContentIDs()) {
                    log.debug("Message has an attachment with content id= " + cid);
                }
            }
            this.attachments = newMap;
        }
        if (this.attachments != null && !messageContext.getAxisMessageContext().isServerSide()) {
            AttachmentUtils.findCachedAttachment(this.attachments);
        }
        this.messageContext = messageContext;
    }

    @Override
    public void setDoingSWA(boolean value) {
        this.doingSWA = value;
    }

    @Override
    public boolean isDoingSWA() {
        return this.doingSWA;
    }

    @Override
    public void close() {
        if (this.xmlPart != null) {
            this.xmlPart.close();
        }
    }
}

