/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.SourceBlock;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.message.util.Reader2Writer;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SourceBlockImpl
extends BlockImpl
implements SourceBlock {
    private static final Log log;
    private static Class staxSource;

    SourceBlockImpl(Source busObject, QName qName, BlockFactory factory) throws WebServiceException {
        super(busObject, null, qName, factory);
        if (busObject instanceof DOMSource || busObject instanceof SAXSource || busObject instanceof StreamSource || busObject.getClass().equals(staxSource) || busObject instanceof JAXBSource) {
            if (log.isDebugEnabled()) {
                log.debug("data object is a " + busObject.getClass().getName());
            }
        } else {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("SourceNotSupported", busObject.getClass().getName()));
        }
    }

    public SourceBlockImpl(OMElement omElement, QName qName, BlockFactory factory) {
        super(omElement, null, qName, factory);
    }

    protected Object _getBOFromReader(XMLStreamReader reader, Object busContext) throws XMLStreamException {
        if (staxSource != null) {
            try {
                Constructor c = staxSource.getDeclaredConstructor(XMLStreamReader.class);
                return c.newInstance(reader);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Reader2Writer r2w = new Reader2Writer(reader);
        String text = r2w.getAsString();
        StringReader sr = new StringReader(text);
        return new StreamSource(sr);
    }

    protected XMLStreamReader _getReaderFromBO(Object busObj, Object busContext) throws XMLStreamException, WebServiceException {
        try {
            if (busObj instanceof StreamSource) {
                XMLInputFactory f = StAXUtils.getXMLInputFactory();
                XMLStreamReader reader = f.createXMLStreamReader((Source)busObj);
                StAXUtils.releaseXMLInputFactory(f);
                return reader;
            }
            return this._slow_getReaderFromSource((Source)busObj);
        }
        catch (Exception e) {
            String className = busObj == null ? "none" : busObj.getClass().getName();
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("SourceReadErr", className), e);
        }
    }

    private XMLStreamReader _slow_getReaderFromSource(Source src) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug("Start _slow_getReaderFromSource");
        }
        byte[] bytes = (byte[])ConvertUtils.convert(src, byte[].class);
        if (log.isDebugEnabled()) {
            log.debug("Successfully converted to ByteArray");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        XMLStreamReader reader = StAXUtils.createXMLStreamReader(bais);
        if (log.isDebugEnabled()) {
            log.debug("End _slow_getReaderFromSource =" + reader);
        }
        return reader;
    }

    protected void _outputFromBO(Object busObject, Object busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Start _outputFromBO");
        }
        XMLStreamReader reader = this._getReaderFromBO(busObject, busContext);
        if (log.isDebugEnabled()) {
            log.debug("Obtained reader=" + reader);
        }
        this._outputFromReader(reader, writer);
        if (log.isDebugEnabled()) {
            log.debug("End _outputReaderFromBO");
        }
    }

    protected Object _getBOFromBO(Object busObject, Object busContext, boolean consume) {
        if (consume) {
            return busObject;
        }
        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("SourceMissingSupport", busObject.getClass().getName()));
    }

    public boolean isElementData() {
        return false;
    }

    private static Class forName(final String className) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    public Object getBusinessObject(boolean consume) throws XMLStreamException, WebServiceException {
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("BlockImplErr1", this.getClass().getName()));
        }
        if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
        } else {
            boolean hasFault = false;
            if (this.parent != null && this.parent.isFault() || this.omElement.getQName().getLocalPart().equals("Fault")) {
                hasFault = true;
            }
            if (!hasFault) {
                XMLStreamReader reader = this.omElement.getBuilder() != null && !this.omElement.getBuilder().isCompleted() ? this.omElement.getXMLStreamReaderWithoutCaching() : this.omElement.getXMLStreamReader();
                this.busObject = this._getBOFromReader(reader, this.busContext);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.omElement.serialize(baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                this.busObject = new StreamSource(bais);
            }
            this.omElement = null;
        }
        Object newBusObject = this.busObject;
        this.setConsumed(consume);
        return newBusObject;
    }

    public void close() {
    }

    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        try {
            byte[] bytes = (byte[])ConvertUtils.convert(this.getBusinessObject(false), byte[].class);
            return new ByteArrayInputStream(bytes);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Object getObject() {
        try {
            return this.getBusinessObject(false);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public boolean isDestructiveRead() {
        return true;
    }

    public boolean isDestructiveWrite() {
        return true;
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        if (log.isDebugEnabled()) {
            log.debug("Start getXMLBytes");
        }
        byte[] bytes = null;
        try {
            bytes = (byte[])ConvertUtils.convert(this.getBusinessObject(false), byte[].class);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("End getXMLBytes");
        }
        return bytes;
    }

    static {
        block2: {
            log = LogFactory.getLog(SourceBlockImpl.class);
            staxSource = null;
            try {
                staxSource = SourceBlockImpl.forName("javax.xml.transform.stax.StAXSource");
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("StAXSource is not present in the JDK.  This is acceptable.  Processing continues");
            }
        }
    }
}

