/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.attachments.JAXBAttachmentMarshaller;
import org.apache.axis2.jaxws.message.attachments.JAXBAttachmentUnmarshaller;
import org.apache.axis2.jaxws.message.databinding.JAXBBlock;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.message.databinding.XSDListUtils;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.message.util.XMLStreamWriterWithOS;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBBlockImpl
extends BlockImpl
implements JAXBBlock {
    private static final Log log = LogFactory.getLog(JAXBBlockImpl.class);
    private static final boolean DEBUG_ENABLED = log.isDebugEnabled();

    JAXBBlockImpl(Object busObject, JAXBBlockContext busContext, QName qName, BlockFactory factory) throws JAXBException {
        super(busObject, (Object)busContext, qName, factory);
    }

    JAXBBlockImpl(OMElement omElement, JAXBBlockContext busContext, QName qName, BlockFactory factory) {
        super(omElement, (Object)busContext, qName, factory);
    }

    protected Object _getBOFromReader(XMLStreamReader reader, Object busContext) throws XMLStreamException, WebServiceException {
        JAXBBlockContext ctx = (JAXBBlockContext)busContext;
        try {
            Unmarshaller u = JAXBUtils.getJAXBUnmarshaller(ctx.getJAXBContext());
            if (DEBUG_ENABLED) {
                log.debug("Adding JAXBAttachmentUnmarshaller to Unmarshaller");
            }
            Message msg = this.getParent();
            JAXBAttachmentUnmarshaller aum = new JAXBAttachmentUnmarshaller(msg);
            u.setAttachmentUnmarshaller(aum);
            Object jaxb = null;
            jaxb = ctx.getProcessType() == null ? JAXBBlockImpl.unmarshalByElement(u, reader) : JAXBBlockImpl.unmarshalByType(u, reader, ctx.getProcessType(), ctx.isxmlList(), ctx.getConstructionType());
            JAXBUtils.releaseJAXBUnmarshaller(ctx.getJAXBContext(), u);
            return jaxb;
        }
        catch (JAXBException je) {
            if (DEBUG_ENABLED) {
                try {
                    log.debug("JAXBContext for unmarshal failure:" + ctx.getJAXBContext());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw ExceptionFactory.makeWebServiceException(je);
        }
    }

    private byte[] _getBytesFromBO(Object busObj, Object busContext, String encoding) throws XMLStreamException, WebServiceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriterWithOS writer = new XMLStreamWriterWithOS(baos, encoding);
        this._outputFromBO(busObj, busContext, writer);
        writer.flush();
        writer.close();
        return baos.toByteArray();
    }

    protected XMLStreamReader _getReaderFromBO(Object busObj, Object busContext) throws XMLStreamException, WebServiceException {
        ByteArrayInputStream baos = new ByteArrayInputStream(this._getBytesFromBO(busObj, busContext, "utf-8"));
        return StAXUtils.createXMLStreamReader(baos, "utf-8");
    }

    protected void _outputFromBO(Object busObject, Object busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        JAXBBlockContext ctx = (JAXBBlockContext)busContext;
        try {
            Marshaller m = JAXBUtils.getJAXBMarshaller(ctx.getJAXBContext());
            if (DEBUG_ENABLED) {
                log.debug("Adding JAXBAttachmentMarshaller to Marshaller");
            }
            Message msg = this.getParent();
            JAXBAttachmentMarshaller am = new JAXBAttachmentMarshaller(msg, writer);
            m.setAttachmentMarshaller(am);
            if (ctx.getProcessType() == null) {
                JAXBBlockImpl.marshalByElement(busObject, m, writer, !am.isXOPPackage());
            } else {
                JAXBBlockImpl.marshalByType(busObject, m, writer, ctx.getProcessType(), ctx.isxmlList(), ctx.getConstructionType());
            }
            JAXBUtils.releaseJAXBMarshaller(ctx.getJAXBContext(), m);
        }
        catch (JAXBException je) {
            if (DEBUG_ENABLED) {
                try {
                    log.debug("JAXBContext for marshal failure:" + ctx.getJAXBContext());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw ExceptionFactory.makeWebServiceException(je);
        }
    }

    private static QName getQName(Object jaxb, JAXBBlockContext ctx) throws JAXBException {
        JAXBIntrospector jbi = JAXBUtils.getJAXBIntrospector(ctx.getJAXBContext());
        QName qName = jbi.getElementName(jaxb);
        JAXBUtils.releaseJAXBIntrospector(ctx.getJAXBContext(), jbi);
        return qName;
    }

    private static void marshalByElement(final Object b, final Marshaller m, final XMLStreamWriter writer, final boolean optimize) throws WebServiceException {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    OutputStream os;
                    OutputStream outputStream = os = optimize ? JAXBBlockImpl.getOutputStream(writer) : null;
                    if (os != null) {
                        if (DEBUG_ENABLED) {
                            log.debug("Invoking marshalByElement.  Marshaling to an OutputStream. Object is " + JAXBBlockImpl.getDebugName(b));
                        }
                        writer.flush();
                        m.marshal(b, os);
                    } else {
                        if (DEBUG_ENABLED) {
                            log.debug("Invoking marshalByElement.  Marshaling to an XMLStreamWriter. Object is " + JAXBBlockImpl.getDebugName(b));
                        }
                        m.marshal(b, writer);
                    }
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
                return null;
            }
        });
    }

    private static Object unmarshalByElement(final Unmarshaller u, final XMLStreamReader reader) throws WebServiceException {
        if (DEBUG_ENABLED) {
            log.debug("Invoking unMarshalByElement");
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return u.unmarshal(reader);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
            }
        });
    }

    private static void marshalByType(final Object b, final Marshaller m, final XMLStreamWriter writer, final Class type, final boolean isList, final JAXBUtils.CONSTRUCTION_TYPE ctype) throws WebServiceException {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    JAXBElement<String> jbo = b;
                    if (isList || type != null && type.isArray()) {
                        if (log.isDebugEnabled()) {
                            log.debug("marshalling type which is a List or Array");
                        }
                        if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                            QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(b);
                            String text = XSDListUtils.toXSDListString(JAXBBlockImpl.getTypeEnabledObject(b));
                            jbo = new JAXBElement<String>(qName, String.class, text);
                        } else if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY) {
                            // empty if block
                        }
                    }
                    if (type.isEnum() && b != null) {
                        if (DEBUG_ENABLED) {
                            log.debug("marshalByType. Marshaling " + type.getName() + " as Enum");
                        }
                        JAXBElement jbe = (JAXBElement)b;
                        String value = XMLRootElementUtil.getEnumValue((Enum)jbe.getValue());
                        jbo = new JAXBElement<String>(jbe.getName(), String.class, value);
                    }
                    if (DEBUG_ENABLED) {
                        log.debug("Invoking marshalByType.  Marshaling to an XMLStreamWriter. Object is " + JAXBBlockImpl.getDebugName(b));
                    }
                    m.marshal((Object)jbo, writer);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
                return null;
            }
        });
    }

    private static Object unmarshalByType(final Unmarshaller u, final XMLStreamReader reader, final Class type, final boolean isList, final JAXBUtils.CONSTRUCTION_TYPE ctype) throws WebServiceException {
        if (DEBUG_ENABLED) {
            log.debug("Invoking unmarshalByType.");
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    JAXBElement<Object> jaxb;
                    if (!isList) {
                        if (type.isArray()) {
                            if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                                jaxb = JAXBBlockImpl.unmarshalAsListOrArray(reader, u, type);
                            } else if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY) {
                                jaxb = u.unmarshal(reader, String[].class);
                                Object typeObj = JAXBBlockImpl.getTypeEnabledObject(jaxb);
                                if (JAXBBlockImpl.getTypeEnabledObject(typeObj) instanceof String[]) {
                                    String[] strArray = (String[])typeObj;
                                    String strTokens = new String();
                                    for (String str : strArray) {
                                        strTokens = strTokens + " " + str;
                                    }
                                    QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(jaxb);
                                    Object obj = XSDListUtils.fromXSDListString(strTokens, type);
                                    jaxb = new JAXBElement<Object>(qName, type, obj);
                                }
                            } else {
                                jaxb = u.unmarshal(reader, type);
                            }
                        } else if (type.isEnum()) {
                            JAXBElement<String> enumValue;
                            if (DEBUG_ENABLED) {
                                log.debug("unmarshalByType. Unmarshalling " + type.getName() + " as Enum");
                            }
                            if ((enumValue = u.unmarshal(reader, String.class)) != null) {
                                Method m = type.getMethod("fromValue", String.class);
                                jaxb = m.invoke(null, enumValue.getValue());
                            } else {
                                jaxb = null;
                            }
                        } else {
                            jaxb = u.unmarshal(reader, type);
                        }
                    } else {
                        jaxb = JAXBBlockImpl.unmarshalAsListOrArray(reader, u, type);
                    }
                    return jaxb;
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
            }
        });
    }

    private static Object unmarshalAsListOrArray(XMLStreamReader reader, Unmarshaller u, Class type) throws IllegalAccessException, ParseException, NoSuchMethodException, InstantiationException, DatatypeConfigurationException, InvocationTargetException, JAXBException {
        JAXBElement<String> jaxb = u.unmarshal(reader, String.class);
        if (JAXBBlockImpl.getTypeEnabledObject(jaxb) instanceof String) {
            QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(jaxb);
            Object obj = XSDListUtils.fromXSDListString((String)JAXBBlockImpl.getTypeEnabledObject(jaxb), type);
            return new JAXBElement<Object>(qName, type, obj);
        }
        return jaxb;
    }

    private static boolean isXSDList(Class t) {
        return t.isArray() || List.class.isAssignableFrom(t);
    }

    public boolean isElementData() {
        return true;
    }

    static Object getTypeEnabledObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    private static OutputStream getOutputStream(XMLStreamWriter writer) throws XMLStreamException {
        if (writer.getClass() == MTOMXMLStreamWriter.class) {
            return ((MTOMXMLStreamWriter)writer).getOutputStream();
        }
        if (writer.getClass() == XMLStreamWriterWithOS.class) {
            return ((XMLStreamWriterWithOS)writer).getOutputStream();
        }
        return null;
    }

    private static String getDebugName(Object o) {
        return o == null ? "null" : o.getClass().getCanonicalName();
    }

    public void close() {
    }

    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        try {
            byte[] bytes = this._getBytesFromBO(this.getBusinessObject(false), this.busContext, encoding);
            return new ByteArrayInputStream(bytes);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Object getObject() {
        try {
            return this.getBusinessObject(false);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        try {
            return this._getBytesFromBO(this.getBusinessObject(false), this.busContext, encoding);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }
}

