/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.attachments;

import javax.activation.DataHandler;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePartDataSource;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBAttachmentMarshaller
extends AttachmentMarshaller {
    private static final Log log = LogFactory.getLog(JAXBAttachmentMarshaller.class);
    private Message message;
    private XMLStreamWriter writer;
    private final String APPLICATION_OCTET = "application/octet-stream";

    public JAXBAttachmentMarshaller(Message message, XMLStreamWriter writer) {
        this.message = message;
        this.writer = writer;
    }

    public boolean isXOPPackage() {
        boolean value = false;
        if (this.message != null) {
            value = this.message.isMTOMEnabled();
        }
        if (!(this.writer instanceof MTOMXMLStreamWriter)) {
            if (log.isDebugEnabled()) {
                log.debug("The writer is not enabled for MTOM.  MTOM values will not be optimized");
            }
            value = false;
        }
        if (log.isDebugEnabled()) {
            log.debug("isXOPPackage returns " + value);
        }
        return value;
    }

    public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String namespace, String localPart) {
        String cid;
        if (offset != 0 || length != data.length) {
            int len = length - offset;
            byte[] newData = new byte[len];
            System.arraycopy(data, offset, newData, 0, len);
            data = newData;
        }
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = "application/octet-stream";
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding MTOM/XOP byte array attachment for element: {" + namespace + "}" + localPart);
        }
        try {
            InternetHeaders ih = new InternetHeaders();
            ih.setHeader("Content-Type", mimeType);
            MimeBodyPart mbp = new MimeBodyPart(ih, data);
            MimePartDataSource mpds = new MimePartDataSource(mbp);
            DataHandler dataHandler = new DataHandler(mpds);
            cid = this.addDataHandler(dataHandler);
            mbp.setHeader("Content-Id", cid);
        }
        catch (Throwable t) {
            throw ExceptionFactory.makeWebServiceException(t);
        }
        return "cid:" + cid;
    }

    public String addMtomAttachment(DataHandler data, String namespace, String localPart) {
        String cid;
        if (log.isDebugEnabled()) {
            log.debug("Adding MTOM/XOP datahandler attachment for element: {" + namespace + "}" + localPart);
        }
        return (cid = this.addDataHandler(data)) == null ? null : "cid:" + cid;
    }

    public String addSwaRefAttachment(DataHandler data) {
        if (log.isDebugEnabled()) {
            log.debug("Adding SWAREF attachment");
        }
        String cid = this.addDataHandler(data);
        this.message.setDoingSWA(true);
        return cid == null ? null : "cid:" + cid;
    }

    private String addDataHandler(DataHandler dh) {
        String cid = null;
        OMTextImpl textNode = null;
        if (this.writer instanceof MTOMXMLStreamWriter) {
            textNode = new OMTextImpl(dh, null);
            cid = textNode.getContentID();
            ((MTOMXMLStreamWriter)this.writer).writeOptimized(textNode);
            this.message.addDataHandler(dh, cid);
        }
        if (log.isDebugEnabled()) {
            log.debug("   content id=" + cid);
            log.debug("   dataHandler  =" + dh);
        }
        return cid;
    }
}

