/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerUtils {
    private static Log log = LogFactory.getLog(HandlerUtils.class);

    public static void registerSOAPHandlerHeaders(MessageContext msgContext, List<Handler> handlers) {
        if (msgContext == null) {
            return;
        }
        AxisOperation axisOperation = msgContext.getAxisOperation();
        AxisService axisService = msgContext.getAxisService();
        if (handlers == null || axisService == null) {
            return;
        }
        ArrayList understoodHeaderNames = axisOperation.getUnderstoodHeaderQNames();
        for (Handler handler : handlers) {
            Set<QName> headers;
            if (!(handler instanceof SOAPHandler)) continue;
            SOAPHandler soapHandler = (SOAPHandler)handler;
            if (log.isDebugEnabled()) {
                log.debug("Invoking getHeader() on SOAPHandler");
            }
            if ((headers = soapHandler.getHeaders()) == null) continue;
            for (QName header : headers) {
                if (understoodHeaderNames.contains(header)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Adding Header QName" + header + " to uderstoodHeaderQName List");
                }
                understoodHeaderNames.add(header);
            }
        }
    }

    public static void checkMustUnderstand(MessageContext msgContext) throws AxisFault {
        Parameter param;
        if (msgContext == null || !msgContext.isHeaderPresent()) {
            return;
        }
        SOAPEnvelope envelope = msgContext.getEnvelope();
        if (envelope.getHeader() == null) {
            return;
        }
        AxisService axisService = msgContext.getAxisService();
        if (axisService == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Reading faultyHeaderQNames from axisService Parameter");
        }
        if ((param = axisService.getParameter("faultyHeaderQNames")) == null) {
            if (log.isDebugEnabled()) {
                log.debug("axisService Parameter FAULTY_HEADER_QNAMES is null");
            }
            return;
        }
        ArrayList headerQNames = (ArrayList)param.getValue();
        if (headerQNames == null) {
            if (log.isDebugEnabled()) {
                log.debug("axisService Parameter FAULTY_HEADER_QNAMES has no faulty qNames");
            }
            return;
        }
        AxisOperation axisOperation = msgContext.getAxisOperation();
        for (QName headerQName : headerQNames) {
            ArrayList understoodHeaderList;
            if (axisOperation != null && (understoodHeaderList = axisOperation.getUnderstoodHeaderQNames()) != null && !understoodHeaderList.isEmpty() && understoodHeaderList.contains(headerQName)) {
                if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) continue;
                log.debug("MustUnderstand header registered as understood on AxisOperation: " + headerQName);
                continue;
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug("MustUnderstand header not processed or registered as understood " + headerQName);
            }
            String prefix = envelope.getNamespace().getPrefix();
            if (!msgContext.isSOAP11()) {
                if (prefix == null || "".equals(prefix)) {
                    prefix = "soapenv";
                }
                throw new AxisFault(Messages.getMessage("mustunderstandfailed", prefix, headerQName.toString()), "MustUnderstand");
            }
            throw new AxisFault(Messages.getMessage("mustunderstandfailed", prefix, headerQName.toString()), "MustUnderstand");
        }
        param.setValue(null);
    }
}

