/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.injection.impl.ResourceInjectionServiceRuntimeDescriptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
implements HandlerResolver {
    static final Map<String, String> protocolBindingsMap = new HashMap<String, String>(5);
    private static Log log;
    private ServiceDescription serviceDesc;

    public HandlerResolverImpl(ServiceDescription sd) {
        this.serviceDesc = sd;
    }

    public ArrayList<Handler> getHandlerChain(PortInfo portinfo) {
        return this.resolveHandlers(portinfo);
    }

    private ArrayList<Handler> resolveHandlers(PortInfo portinfo) throws WebServiceException {
        Iterator<HandlerChainType> it;
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        HandlerChainsType handlerCT = this.serviceDesc.getHandlerChain();
        EndpointDescription ed = null;
        if (portinfo != null) {
            ed = this.serviceDesc.getEndpointDescription(portinfo.getPortName());
        }
        if (ed != null) {
            HandlerChainsType handlerCT_fromEndpointDesc = ed.getHandlerChain();
            if (handlerCT == null) {
                handlerCT = handlerCT_fromEndpointDesc;
            }
        }
        Iterator<HandlerChainType> iterator = it = handlerCT == null ? null : handlerCT.getHandlerChain().iterator();
        while (it != null && it.hasNext()) {
            HandlerChainType handlerChainType = it.next();
            if (!HandlerResolverImpl.chainResolvesToPort(handlerChainType, portinfo)) continue;
            List<HandlerType> handlerTypeList = handlerChainType.getHandler();
            for (HandlerType handlerType : handlerTypeList) {
                Handler handler;
                String portHandler = handlerType.getHandlerClass().getValue();
                try {
                    handler = (Handler)HandlerResolverImpl.loadClass(portHandler).newInstance();
                    HandlerResolverImpl.callHandlerPostConstruct(handler, this.serviceDesc);
                }
                catch (ClassNotFoundException e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
                catch (InstantiationException ie) {
                    throw ExceptionFactory.makeWebServiceException(ie);
                }
                catch (IllegalAccessException e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
                if (LogicalHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((LogicalHandler)handler);
                    continue;
                }
                if (SOAPHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((SOAPHandler)handler);
                    continue;
                }
                if (Handler.class.isAssignableFrom(handler.getClass())) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("handlerChainErr1", handler.getClass().getName()));
                }
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("handlerChainErr2", handler.getClass().getName()));
            }
        }
        return handlers;
    }

    private static Class loadClass(String clazz) throws ClassNotFoundException {
        return HandlerResolverImpl.forName(clazz, true, HandlerResolverImpl.getContextClassLoader());
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classLoader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("HandlerResolverImpl attempting to load Class: " + className);
                        }
                        return Class.forName(className, initialize, classLoader);
                    }
                    catch (Throwable e) {
                        if (log.isDebugEnabled()) {
                            log.debug("HandlerResolverImpl cannot load the following class Throwable Exception Occured: " + className);
                        }
                        throw new ClassNotFoundException("HandlerResolverImpl cannot load the following class Throwable Exception Occured:" + className);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (RuntimeException)e.getException();
        }
        return cl;
    }

    private static void callHandlerPostConstruct(Handler handler, ServiceDescription serviceDesc) throws WebServiceException {
        Method pcMethod;
        ResourceInjectionServiceRuntimeDescription resInj = ResourceInjectionServiceRuntimeDescriptionBuilder.create(serviceDesc, handler.getClass());
        if (resInj != null && (pcMethod = resInj.getPostConstructMethod()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Invoking Method with @PostConstruct annotation");
            }
            HandlerResolverImpl.invokeMethod(handler, pcMethod, null);
            if (log.isDebugEnabled()) {
                log.debug("Completed invoke on Method with @PostConstruct annotation");
            }
        }
    }

    private static void callHandlerPreDestroy(Handler handler, ServiceDescription serviceDesc) throws WebServiceException {
        Method pcMethod;
        ResourceInjectionServiceRuntimeDescription resInj = ResourceInjectionServiceRuntimeDescriptionBuilder.create(serviceDesc, handler.getClass());
        if (resInj != null && (pcMethod = resInj.getPreDestroyMethod()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Invoking Method with @PostConstruct annotation");
            }
            HandlerResolverImpl.invokeMethod(handler, pcMethod, null);
            if (log.isDebugEnabled()) {
                log.debug("Completed invoke on Method with @PostConstruct annotation");
            }
        }
    }

    private static void invokeMethod(Handler handlerInstance, Method m, Object[] params) throws WebServiceException {
        try {
            m.invoke((Object)handlerInstance, params);
        }
        catch (InvocationTargetException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    private static boolean chainResolvesToPort(HandlerChainType handlerChainType, PortInfo portinfo) {
        List<String> protocolBindings = handlerChainType.getProtocolBindings();
        if (protocolBindings != null) {
            boolean match = true;
            Iterator<String> it = protocolBindings.iterator();
            while (it.hasNext()) {
                match = false;
                String protocolBinding = it.next();
                protocolBinding = protocolBinding.startsWith("##") ? protocolBindingsMap.get(protocolBinding) : protocolBinding;
                if (protocolBinding == null || !protocolBinding.equals(portinfo.getBindingID())) continue;
                match = true;
                break;
            }
            if (!match) {
                return match;
            }
        }
        if (!HandlerResolverImpl.doesPatternMatch(portinfo.getPortName(), handlerChainType.getPortNamePattern())) {
            return false;
        }
        return HandlerResolverImpl.doesPatternMatch(portinfo.getServiceName(), handlerChainType.getServiceNamePattern());
    }

    private static boolean doesPatternMatch(QName portInfoQName, QName pattern) {
        if (pattern == null) {
            return true;
        }
        HandlerResolverImpl.validatePattern(pattern);
        String portInfoPrefix = portInfoQName.getNamespaceURI();
        String portInfoLocalPart = portInfoQName.getLocalPart();
        String portInfoString = portInfoPrefix == null || portInfoPrefix.equals("") ? "" : portInfoPrefix + ":";
        portInfoString = portInfoString + portInfoLocalPart;
        String patternStringPrefix = pattern.getNamespaceURI();
        String patternInfoLocalPart = pattern.getLocalPart();
        String patternString = patternStringPrefix == null || patternStringPrefix.equals("") ? "" : patternStringPrefix + ":";
        patternString = patternString + patternInfoLocalPart;
        Pattern userp = Pattern.compile(patternString.replace("*", "(\\w|\\.|-|_)*"));
        Matcher userm = userp.matcher(portInfoString);
        boolean match = userm.matches();
        if (log.isDebugEnabled()) {
            if (!match) {
                log.debug("Pattern match failed: \"" + portInfoString + "\" does not match \"" + patternString + "\"");
            } else {
                log.debug("Pattern match succeeded: \"" + portInfoString + "\" matches \"" + patternString + "\"");
            }
        }
        return match;
    }

    private static void validatePattern(QName pattern) {
        String patternStringPrefix = pattern.getPrefix();
        String patternInfoLocalPart = pattern.getLocalPart();
        String patternString = patternStringPrefix == null || patternStringPrefix.equals("") ? "" : patternStringPrefix + ":";
        patternString = patternString + patternInfoLocalPart;
        Pattern p = Pattern.compile("\\*|((\\w|_)(\\w|\\.|-|_)*:)?(\\w|_)(\\w|\\.|-|_)*\\*?");
        Matcher m = p.matcher(patternString);
        if (!m.matches()) {
            log.warn("Pattern defined by user is illegal:  \"" + patternString + "\" does not match regular expression in schema http://java.sun.com/xml/ns/javaee/javaee_web_services_1_2.xsd.  Pattern matching should now be considered \"best-effort.\"");
        }
    }

    static {
        protocolBindingsMap.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
        protocolBindingsMap.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        protocolBindingsMap.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        protocolBindingsMap.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        protocolBindingsMap.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
        log = LogFactory.getLog(HandlerResolverImpl.class);
    }
}

