/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.dispatchers;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MustUnderstandValidationDispatcher
extends AbstractDispatcher {
    private static final Log log = LogFactory.getLog(MustUnderstandValidationDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
    }

    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        AxisService axisService = msgctx.getAxisService();
        AxisOperation axisOperation = msgctx.getAxisOperation();
        if (log.isDebugEnabled()) {
            log.debug("JAXWS MustUnderstandValidationDispatcher.invoke on AxisService " + axisService + "; AxisOperation " + axisOperation);
        }
        if (axisService != null && axisOperation == null) {
            this.checkMustUnderstand(msgctx);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private boolean checkMustUnderstand(MessageContext msgContext) throws AxisFault {
        boolean checksPass = true;
        if (log.isDebugEnabled()) {
            log.debug("Checking for JAXWS-specific understood headers");
        }
        if (!msgContext.isHeaderPresent()) {
            return checksPass;
        }
        SOAPEnvelope envelope = msgContext.getEnvelope();
        if (envelope.getHeader() == null) {
            return checksPass;
        }
        Iterator headerBlocks = envelope.getHeader().examineAllHeaderBlocks();
        ArrayList understoodHeaderList = this.getUnderstoodHeaderList(msgContext);
        while (headerBlocks.hasNext()) {
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)headerBlocks.next();
            QName headerQName = headerBlock.getQName();
            if (headerBlock.isProcessed() || !headerBlock.getMustUnderstand() || !this.checkThisHeader(headerBlock, msgContext)) continue;
            if (understoodHeaderList != null && !understoodHeaderList.isEmpty() && understoodHeaderList.contains(headerQName)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("MustUnderstand header registered as understood on Operation: " + headerQName);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("MustUnderstand header not processed or registered as understood " + headerQName);
            }
            String prefix = envelope.getNamespace().getPrefix();
            if (!msgContext.isSOAP11()) {
                if (prefix == null || "".equals(prefix)) {
                    prefix = "soapenv";
                }
                throw new AxisFault("MustUnderstand header check failed " + prefix + headerQName.toString(), "MustUnderstand");
            }
            throw new AxisFault("MustUnderstand header check failed " + prefix + headerQName.toString(), "MustUnderstand");
        }
        return checksPass;
    }

    private ArrayList getUnderstoodHeaderList(MessageContext msgContext) {
        Iterator operationIterator;
        ArrayList returnList = new ArrayList();
        AxisService axisService = msgContext.getAxisService();
        if (log.isDebugEnabled()) {
            log.debug("Building list of understood headers for all operations under " + axisService);
        }
        if (axisService != null && (operationIterator = axisService.getOperations()) != null) {
            while (operationIterator.hasNext()) {
                AxisOperation operation = (AxisOperation)operationIterator.next();
                ArrayList understoodHeaders = operation.getUnderstoodHeaderQNames();
                if (log.isDebugEnabled()) {
                    log.debug("Adding headers from operation " + operation + "; headers = " + understoodHeaders);
                }
                if (understoodHeaders == null || understoodHeaders.isEmpty()) continue;
                returnList.addAll(understoodHeaders);
            }
        }
        return returnList;
    }

    private boolean checkThisHeader(SOAPHeaderBlock headerBlock, MessageContext msgContext) {
        boolean checkIt = true;
        AxisService axisService = msgContext.getAxisService();
        if (axisService.isClientSide()) {
            String role = headerBlock.getRole();
            checkIt = false;
            if (log.isDebugEnabled()) {
                log.debug("Client-side MustUnderstand header checking: " + checkIt + "; for header role: " + role + "; header QName: " + headerBlock.getQName());
            }
        }
        return checkIt;
    }
}

