/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.validator;

import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.validator.EndpointInterfaceDescriptionValidator;
import org.apache.axis2.jaxws.description.validator.Validator;

public class EndpointDescriptionValidator
extends Validator {
    EndpointDescription endpointDesc;
    EndpointDescriptionJava endpointDescJava;
    EndpointDescriptionWSDL endpointDescWSDL;

    public EndpointDescriptionValidator(EndpointDescription toValidate) {
        this.endpointDesc = toValidate;
        this.endpointDescJava = (EndpointDescriptionJava)((Object)this.endpointDesc);
        this.endpointDescWSDL = (EndpointDescriptionWSDL)((Object)this.endpointDesc);
    }

    public boolean validate() {
        if (this.getValidationLevel() == Validator.ValidationLevel.OFF) {
            return true;
        }
        if (this.endpointDesc.getServiceDescription().isServerSide()) {
            if (!this.validateWSDLPort()) {
                return false;
            }
            if (!this.validateWSDLBindingType()) {
                return false;
            }
        }
        return this.validateEndpointInterface();
    }

    private boolean validateWSDLBindingType() {
        boolean isBindingValid = false;
        String bindingType = this.endpointDesc.getBindingType();
        String wsdlBindingType = this.endpointDescWSDL.getWSDLBindingType();
        if (bindingType == null) {
            this.addValidationFailure(this, "Annotation binding type is null and did not have a default");
            isBindingValid = false;
        } else if (!("http://schemas.xmlsoap.org/wsdl/soap/http".equals(bindingType) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(bindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bindingType) || "http://www.w3.org/2004/08/wsdl/http".equals(bindingType))) {
            this.addValidationFailure(this, "Invalid annotation binding value specified: " + bindingType);
            isBindingValid = false;
        } else if (wsdlBindingType == null) {
            isBindingValid = true;
        } else if (!("http://schemas.xmlsoap.org/wsdl/soap/http".equals(wsdlBindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(wsdlBindingType) || "http://www.w3.org/2004/08/wsdl/http".equals(wsdlBindingType))) {
            this.addValidationFailure(this, "Invalid wsdl binding value specified: " + wsdlBindingType);
            isBindingValid = false;
        } else if (wsdlBindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") && (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true"))) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && (bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2004/08/wsdl/http") && bindingType.equals("http://www.w3.org/2004/08/wsdl/http")) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2004/08/wsdl/http") && this.endpointDesc.isEndpointBased()) {
            this.addValidationFailure(this, "The HTTPBinding can not be specified for SEI-based endpoints");
            isBindingValid = false;
        } else {
            this.addValidationFailure(this, "Invalid binding; wsdl = " + wsdlBindingType + ", annotation = " + bindingType);
            isBindingValid = false;
        }
        return isBindingValid;
    }

    private boolean validateWSDLPort() {
        Port wsdlPort;
        Service wsdlService = this.endpointDescWSDL.getWSDLService();
        if (wsdlService != null && (wsdlPort = this.endpointDescWSDL.getWSDLPort()) == null) {
            this.addValidationFailure(this, "Service exists in WSDL, but Port does not.  Not a valid Partial WSDL.  Service: " + this.endpointDesc.getServiceQName() + "; Port: " + this.endpointDesc.getPortQName());
            return false;
        }
        return true;
    }

    private boolean validateEndpointInterface() {
        EndpointInterfaceDescriptionValidator eidValidator;
        boolean isEndpointInterfaceValid;
        EndpointInterfaceDescription eid = this.endpointDesc.getEndpointInterfaceDescription();
        if (eid != null && !(isEndpointInterfaceValid = (eidValidator = new EndpointInterfaceDescriptionValidator(eid)).validate())) {
            this.addValidationFailure(eidValidator, "Invalid Endpoint Interface");
            return false;
        }
        return true;
    }
}

