/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class URIResolverImpl
implements URIResolver {
    private final String HTTP_PROTOCOL = "http";
    private final String HTTPS_PROTOCOL = "https";
    private final String FILE_PROTOCOL = "file";
    private final String JAR_PROTOCOL = "jar";
    private final String WS_JAR_PROTOCOL = "wsjar";
    private ClassLoader classLoader;
    private static final Log log = LogFactory.getLog(URIResolverImpl.class);

    public URIResolverImpl() {
    }

    public URIResolverImpl(ClassLoader cl) {
        this.classLoader = cl;
    }

    public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
        String pathURIStr;
        InputStream is;
        block27: {
            is = null;
            URI pathURI = null;
            pathURIStr = null;
            if (log.isDebugEnabled()) {
                log.debug("Import location: " + schemaLocation + " parent document: " + baseUri);
            }
            if (baseUri != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Base URI not null");
                    }
                    if (this.isAbsolute(schemaLocation)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Retrieving input stream for absolute schema location: " + schemaLocation);
                        }
                        is = this.getInputStreamForURI(schemaLocation);
                        break block27;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("schemaLocation not in absolute path");
                    }
                    try {
                        pathURI = new URI(baseUri);
                    }
                    catch (URISyntaxException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Got URISyntaxException. Exception Message = " + e.getMessage());
                            log.debug("Implementing alternate way to create URI");
                        }
                        pathURI = new URI(null, null, baseUri, null);
                    }
                    pathURIStr = schemaLocation;
                    if (pathURI.isAbsolute()) {
                        URL url;
                        if (log.isDebugEnabled()) {
                            log.debug("Parent document is at absolute location: " + pathURI.toString());
                        }
                        if ((url = new URL(baseUri)) != null) {
                            URI tempURI;
                            try {
                                tempURI = new URI(url.getPath());
                            }
                            catch (URISyntaxException e) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Got URISyntaxException. Exception Message = " + e.getMessage());
                                    log.debug("Implementing alternate way to create URI");
                                }
                                tempURI = new URI(null, null, url.getPath(), null);
                            }
                            URI resolvedURI = tempURI.resolve(schemaLocation);
                            if (log.isDebugEnabled()) {
                                log.debug("resolveEntity() before call to constructPath()");
                            }
                            pathURIStr = this.constructPath(url, resolvedURI);
                            if (log.isDebugEnabled()) {
                                log.debug("resolveEntity() after call to constructPath()");
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("Resolved this path to imported document: " + pathURIStr);
                            }
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Parent document is at relative location: " + pathURI.toString());
                        }
                        pathURI = pathURI.resolve(schemaLocation);
                        pathURIStr = pathURI.toString();
                        if (log.isDebugEnabled()) {
                            log.debug("Resolved this path to imported document: " + pathURIStr);
                        }
                    }
                    is = this.isAbsolute(pathURIStr) ? this.getInputStreamForURI(pathURIStr) : this.classLoader.getResourceAsStream(pathURI.toString());
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block27;
                    log.debug("Exception occured in resolveEntity, ignoring exception continuing processing " + e.getMessage());
                }
            }
        }
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debug("XSD input stream is null after resolving import for: " + schemaLocation + " from parent document: " + baseUri);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("XSD input stream is not null after resolving import for: " + schemaLocation + " from parent document: " + baseUri);
        }
        InputSource returnInputSource = new InputSource(is);
        returnInputSource.setSystemId(pathURIStr != null ? pathURIStr : schemaLocation);
        return returnInputSource;
    }

    private boolean isAbsolute(String location) {
        boolean absolute = false;
        if (location.indexOf(":/") != -1) {
            absolute = true;
        } else if (location.indexOf(":\\") != -1) {
            absolute = true;
        } else if (location.indexOf("file:") != -1) {
            absolute = true;
        }
        return absolute;
    }

    private InputStream getInputStreamForURI(String uri) {
        URL streamURL = null;
        InputStream is = null;
        URI pathURI = null;
        try {
            streamURL = new URL(uri);
            is = streamURL.openStream();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (is == null) {
            try {
                pathURI = new URI(uri);
                streamURL = pathURI.toURL();
                is = streamURL.openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                File file = new File(uri);
                streamURL = file.toURL();
                is = streamURL.openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return is;
    }

    private String constructPath(URL baseURL, URI resolvedURI) {
        String importLocation = null;
        URL url = null;
        try {
            if (baseURL.getProtocol() != null && (baseURL.getProtocol().equals("http") || baseURL.getProtocol().equals("https"))) {
                if (log.isDebugEnabled()) {
                    log.debug("Constructing path with http/https protocol");
                }
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), resolvedURI.toString());
                if (log.isDebugEnabled()) {
                    log.debug("URL = " + url);
                }
            } else if (baseURL.getProtocol() != null && baseURL.getProtocol().equals("file")) {
                if (log.isDebugEnabled()) {
                    log.debug("Constructing path with file protocol");
                }
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), resolvedURI.toString());
            } else if (baseURL.getProtocol() != null && baseURL.getProtocol().equals("jar")) {
                if (log.isDebugEnabled()) {
                    log.debug("Constructing path with jar protocol");
                }
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), resolvedURI.toString());
            } else if (baseURL.getProtocol() != null && baseURL.getProtocol().equals("wsjar")) {
                if (log.isDebugEnabled()) {
                    log.debug("Constructing path with wsjar protocol");
                }
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), resolvedURI.toString());
            } else if (log.isDebugEnabled()) {
                if (baseURL != null) {
                    log.debug("unknown protocol in url " + baseURL.getProtocol());
                } else {
                    log.debug("baseURL is NULL");
                }
            }
        }
        catch (MalformedURLException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("schemaImportError", resolvedURI.toString(), baseURL.toString()), e);
        }
        if (url == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("schemaImportError", resolvedURI.toString(), baseURL.toString()));
        }
        importLocation = url.toString();
        return importLocation;
    }
}

