/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.xml.ws.WebFault;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.FaultDescriptionJava;
import org.apache.axis2.jaxws.description.FaultDescriptionWSDL;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;

class FaultDescriptionImpl
implements FaultDescription,
FaultDescriptionJava,
FaultDescriptionWSDL {
    private Class exceptionClass;
    private DescriptionBuilderComposite composite;
    private WebFault annotation;
    private OperationDescription parent;
    private String name = "";
    private String faultBean = "";
    private String targetNamespace = "";
    private String faultInfo = null;
    private static final String FAULT = "Fault";

    FaultDescriptionImpl(Class exceptionClass, WebFault annotation2, OperationDescription parent) {
        this.exceptionClass = exceptionClass;
        this.annotation = annotation2;
        this.parent = parent;
    }

    FaultDescriptionImpl(DescriptionBuilderComposite faultDBC, OperationDescription parent) {
        this.composite = faultDBC;
        this.parent = parent;
    }

    public WebFault getAnnoWebFault() {
        if (this.annotation == null && this.isDBC()) {
            this.annotation = this.composite.getWebFaultAnnot();
        }
        return this.annotation;
    }

    public String getExceptionClassName() {
        if (!this.isDBC()) {
            return this.exceptionClass.getCanonicalName();
        }
        return this.composite.getClassName();
    }

    public String getFaultInfo() {
        if (this.faultInfo != null) {
            return this.faultInfo;
        }
        if (!this.isDBC()) {
            try {
                Method method = this.exceptionClass.getMethod("getFaultInfo", null);
                this.faultInfo = method.getReturnType().getCanonicalName();
            }
            catch (Exception e) {
                this.faultInfo = "";
            }
        } else {
            MethodDescriptionComposite mdc = this.composite.getMethodDescriptionComposite("getFaultInfo", 1);
            this.faultInfo = mdc != null ? mdc.getReturnType() : "";
        }
        return this.faultInfo;
    }

    public String getFaultBean() {
        if (this.faultBean != null && this.faultBean.length() > 0) {
            return this.faultBean;
        }
        WebFault annotation2 = this.getAnnoWebFault();
        this.faultBean = annotation2 != null && annotation2.faultBean() != null && annotation2.faultBean().length() > 0 ? annotation2.faultBean() : this.getFaultInfo();
        return this.faultBean;
    }

    public String getName() {
        if (this.name.length() > 0) {
            return this.name;
        }
        WebFault annotation2 = this.getAnnoWebFault();
        if (annotation2 != null && annotation2.name().length() > 0) {
            this.name = annotation2.name();
        }
        return this.name;
    }

    public String getTargetNamespace() {
        if (this.targetNamespace.length() > 0) {
            return this.targetNamespace;
        }
        WebFault annotation2 = this.getAnnoWebFault();
        if (annotation2 != null && annotation2.targetNamespace().length() > 0) {
            this.targetNamespace = annotation2.targetNamespace();
        }
        return this.targetNamespace;
    }

    public OperationDescription getOperationDescription() {
        return this.parent;
    }

    private static String getSimpleName(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        String out = null;
        StringTokenizer tokenizer = new StringTokenizer(in, ".");
        if (tokenizer.countTokens() == 0) {
            out = in;
        } else {
            while (tokenizer.hasMoreTokens()) {
                out = tokenizer.nextToken();
            }
        }
        return out;
    }

    private boolean isDBC() {
        return this.composite != null;
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("Exception class: " + this.getExceptionClassName());
            string.append("\n");
            string.append("Name: " + this.getName());
            string.append("\n");
            string.append("Namespace: " + this.getName());
            string.append("\n");
            string.append("FaultBean: " + this.getFaultBean());
            string.append("\n");
            string.append("FaultInfo Type Name  : " + this.getFaultInfo());
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Debug information for the FaultDescription cannot be completed at this time.");
            return string.toString();
        }
        return string.toString();
    }
}

