/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.PortInfo;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.impl.EndpointInterfaceDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.PortInfoImpl;
import org.apache.axis2.jaxws.description.impl.ServiceDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.URIResolverImpl;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.axis2.wsdl.util.WSDLDefinitionWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class EndpointDescriptionImpl
implements EndpointDescription,
EndpointDescriptionJava,
EndpointDescriptionWSDL {
    private ServiceDescriptionImpl parentServiceDescription;
    private AxisService axisService;
    private QName portQName;
    private QName serviceQName;
    private boolean isDynamicPort;
    private boolean isAxisServiceBuiltFromWSDL;
    private String serviceImplName;
    private EndpointInterfaceDescription endpointInterfaceDescription;
    private Class implOrSEIClass = null;
    private ServiceClient serviceClient = null;
    DescriptionBuilderComposite composite = null;
    TreeSet<String> packages = null;
    private PortInfo portInfo;
    private String clientBindingID;
    private String endpointAddress;
    private String wsdlSOAPAddress;
    private static final Log log = LogFactory.getLog(EndpointDescriptionImpl.class);
    private WebService webServiceAnnotation;
    private WebServiceProvider webServiceProviderAnnotation;
    private HandlerChain handlerChainAnnotation;
    private HandlerChainsType handlerChainsType;
    private String annotation_WsdlLocation;
    private String annotation_ServiceName;
    private String annotation_PortName;
    private String annotation_TargetNamespace;
    private String webService_EndpointInterface;
    private String webService_Name;
    private ServiceMode serviceModeAnnotation;
    private Service.Mode serviceModeValue;
    public static final Service.Mode ServiceMode_DEFAULT = Service.Mode.PAYLOAD;
    private BindingType bindingTypeAnnotation;
    private String bindingTypeValue;
    public static final String BindingType_DEFAULT = "http://schemas.xmlsoap.org/wsdl/soap/http";

    EndpointDescriptionImpl(Class theClass, QName portName, ServiceDescriptionImpl parent) {
        this(theClass, portName, false, parent);
    }

    EndpointDescriptionImpl(Class theClass, QName portName, boolean dynamicPort, ServiceDescriptionImpl parent) {
        this.parentServiceDescription = parent;
        this.implOrSEIClass = theClass;
        if (this.implOrSEIClass != null) {
            this.webServiceAnnotation = (WebService)EndpointDescriptionImpl.getAnnotation(this.implOrSEIClass, WebService.class);
            this.webServiceProviderAnnotation = (WebServiceProvider)EndpointDescriptionImpl.getAnnotation(this.implOrSEIClass, WebServiceProvider.class);
        }
        this.isDynamicPort = dynamicPort;
        this.portQName = DescriptionUtils.isEmpty(portName) ? this.selectPortToUse() : portName;
        if (this.portQName == null) {
            if (log.isDebugEnabled()) {
                log.debug("PortQName was null and could not be determined by runtime.  Class: " + theClass + "; ServiceDescription: " + parent);
            }
            throw ExceptionFactory.makeWebServiceException("EndpointDescription: portQName could not be determined for class " + theClass);
        }
        this.setupAxisService();
        this.addToAxisService();
        this.buildDescriptionHierachy();
        this.addAnonymousAxisOperations();
        this.getServiceClient();
        try {
            this.getServiceDescriptionImpl().getClientConfigurationFactory().completeAxis2Configuration(this.axisService);
        }
        catch (DeploymentException e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught DeploymentException attempting to complete configuration on AxisService: " + this.axisService + " for ServiceDesription: " + parent, e);
            }
            throw ExceptionFactory.makeWebServiceException("Unable to complete configuration due to exception " + e, e);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught Exception attempting to complete configuration on AxisService: " + this.axisService + " for ServiceDesription: " + parent, e);
            }
            throw ExceptionFactory.makeWebServiceException("Unable to complete configuration due to exception " + e, e);
        }
        this.setup();
        this.releaseAxisServiceResources();
    }

    EndpointDescriptionImpl(ServiceDescriptionImpl parent, String serviceImplName) {
        boolean isSOAP11;
        this.parentServiceDescription = parent;
        this.serviceImplName = serviceImplName;
        this.implOrSEIClass = null;
        this.composite = this.getServiceDescriptionImpl().getDescriptionBuilderComposite();
        if (this.composite == null) {
            throw ExceptionFactory.makeWebServiceException("EndpointDescription.EndpointDescription: parents DBC is null");
        }
        if (this.composite.getWebServiceAnnot() != null) {
            this.webServiceAnnotation = this.composite.getWebServiceAnnot();
        } else {
            this.webServiceProviderAnnotation = this.composite.getWebServiceProviderAnnot();
        }
        if (DescriptionUtils.isEmpty(this.getServiceDescription().getServiceQName())) {
            this.getServiceDescriptionImpl().setServiceQName(this.getServiceQName());
        }
        this.getPortQName();
        this.setupAxisServiceFromDBL();
        this.addToAxisService();
        this.buildDescriptionHierachy();
        WsdlComposite wsdlComposite = null;
        String bindingType = this.getBindingType();
        boolean bl = isSOAP11 = bindingType.equals(BindingType_DEFAULT) || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        if (isSOAP11) {
            DescriptionBuilderComposite seic;
            if (this.isEndpointBased() && DescriptionUtils.isEmpty(this.getAnnoWebServiceEndpointInterface()) || !this.isEndpointBased()) {
                wsdlComposite = this.generateWSDL(this.composite);
            } else if (this.isEndpointBased() && this.getServiceDescriptionImpl().isDBCMap() && (seic = this.getServiceDescriptionImpl().getDBCforKey(this.composite.getWebServiceAnnot().endpointInterface())).getWsdlDefinition() == null) {
                wsdlComposite = this.generateWSDL(this.composite);
            }
        } else if (this.composite.getWsdlDefinition() == null) {
            log.warn("This implementation does not contain a WSDL definition is not a SOAP 1.1 based binding. Per JAXWS spec. - a WSDL definition cannot be generated for this implementation. Name: " + this.composite.getClassName());
        }
        if (isSOAP11) {
            Parameter wsdlLocationParameter = new Parameter();
            wsdlLocationParameter.setName("WSDL_LOCATION");
            Parameter wsdlDefParameter = new Parameter();
            wsdlDefParameter.setName("wsdl4jDefinition");
            Parameter wsdlCompositeParameter = new Parameter();
            wsdlCompositeParameter.setName("WSDL_COMPOSITE");
            if (wsdlComposite != null) {
                wsdlCompositeParameter.setValue(wsdlComposite);
                wsdlLocationParameter.setValue(wsdlComposite.getWsdlFileName());
                Definition def = this.getServiceDescriptionImpl().getGeneratedWsdlWrapper().getDefinition();
                URL wsdlUrl = this.getServiceDescriptionImpl().getGeneratedWsdlWrapper().getWSDLLocation();
                if (def instanceof WSDLDefinitionWrapper) {
                    wsdlDefParameter.setValue(def);
                } else {
                    WSDLDefinitionWrapper wrap = new WSDLDefinitionWrapper(def, wsdlUrl);
                    wsdlDefParameter.setValue(wrap);
                }
            } else if (this.getServiceDescriptionImpl().getWSDLWrapper() != null) {
                wsdlLocationParameter.setValue(this.getAnnoWebServiceWSDLLocation());
                Definition def = this.getServiceDescriptionImpl().getWSDLWrapper().getDefinition();
                URL wsdlUrl = this.getServiceDescriptionImpl().getWSDLWrapper().getWSDLLocation();
                if (def instanceof WSDLDefinitionWrapper) {
                    wsdlDefParameter.setValue(def);
                } else {
                    WSDLDefinitionWrapper wrap = new WSDLDefinitionWrapper(def, wsdlUrl);
                    wsdlDefParameter.setValue(wrap);
                }
            } else {
                wsdlLocationParameter.setValue(null);
                wsdlDefParameter.setValue(null);
            }
            try {
                if (wsdlComposite != null) {
                    this.axisService.addParameter(wsdlCompositeParameter);
                }
                this.axisService.addParameter(wsdlDefParameter);
                this.axisService.addParameter(wsdlLocationParameter);
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException("EndpointDescription: Unable to add parameters to AxisService");
            }
        }
        Parameter wsdlDefParameter = new Parameter();
        wsdlDefParameter.setName("wsdl4jDefinition");
        Parameter wsdlLocationParameter = new Parameter();
        wsdlLocationParameter.setName("WSDL_LOCATION");
        if (this.getServiceDescriptionImpl().getWSDLWrapper() != null) {
            wsdlLocationParameter.setValue(this.getAnnoWebServiceWSDLLocation());
            Definition def = this.getServiceDescriptionImpl().getWSDLWrapper().getDefinition();
            URL wsdlUrl = this.getServiceDescriptionImpl().getWSDLWrapper().getWSDLLocation();
            if (def instanceof WSDLDefinitionWrapper) {
                wsdlDefParameter.setValue(def);
            } else {
                WSDLDefinitionWrapper wrap = new WSDLDefinitionWrapper(def, wsdlUrl);
                wsdlDefParameter.setValue(wrap);
            }
        } else {
            wsdlLocationParameter.setValue(null);
            wsdlDefParameter.setValue(null);
        }
        try {
            this.axisService.addParameter(wsdlDefParameter);
            this.axisService.addParameter(wsdlLocationParameter);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException("EndpointDescription: Unable to add parameters to AxisService");
        }
        this.setup();
        this.releaseAxisServiceResources();
    }

    EndpointDescriptionImpl(Class theClass, QName portName, AxisService axisService, ServiceDescriptionImpl parent) {
        this.parentServiceDescription = parent;
        this.portQName = portName;
        this.implOrSEIClass = theClass;
        this.axisService = axisService;
        this.addToAxisService();
        this.buildEndpointDescriptionFromAnnotations();
        this.setup();
        this.releaseAxisServiceResources();
    }

    private void addToAxisService() {
        if (this.axisService != null) {
            Parameter parameter = new Parameter();
            parameter.setName("org.apache.axis2.jaxws.description.EndpointDescription");
            parameter.setValue(this);
            try {
                this.axisService.addParameter(parameter);
            }
            catch (AxisFault e) {
                e.printStackTrace();
                throw new UnsupportedOperationException("Can't add AxisService param: " + e);
            }
        }
    }

    private void buildEndpointDescriptionFromAnnotations() {
        if (!this.useComposite()) {
            this.webServiceAnnotation = (WebService)EndpointDescriptionImpl.getAnnotation(this.implOrSEIClass, WebService.class);
            this.webServiceProviderAnnotation = (WebServiceProvider)EndpointDescriptionImpl.getAnnotation(this.implOrSEIClass, WebServiceProvider.class);
            if (this.webServiceAnnotation == null && this.webServiceProviderAnnotation == null) {
                throw ExceptionFactory.makeWebServiceException("Either WebService or WebServiceProvider annotation must be present on " + this.implOrSEIClass);
            }
            if (this.webServiceAnnotation != null && this.webServiceProviderAnnotation != null) {
                throw ExceptionFactory.makeWebServiceException("Both WebService or WebServiceProvider annotations cannot be presenton " + this.implOrSEIClass);
            }
        }
        if (this.webServiceAnnotation != null) {
            String seiClassName = this.getAnnoWebServiceEndpointInterface();
            if (!this.useComposite()) {
                Class seiClass = null;
                if (DescriptionUtils.isEmpty(seiClassName)) {
                    seiClass = this.implOrSEIClass;
                } else {
                    try {
                        seiClass = EndpointDescriptionImpl.forName(seiClassName, false, EndpointDescriptionImpl.getContextClassLoader());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        throw new UnsupportedOperationException("Can't create SEI class: " + e);
                    }
                }
                this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(seiClass, this);
            } else if (DescriptionUtils.isEmpty(this.getAnnoWebServiceEndpointInterface())) {
                this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.composite, true, this);
            } else if (this.getServiceDescriptionImpl().isDBCMap()) {
                this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.getServiceDescriptionImpl().getDBCforKey(seiClassName), false, this);
            }
        } else {
            String bindingType;
            if (log.isDebugEnabled()) {
                log.debug("WebServiceProvider without WSDL encountered");
            }
            if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingType = this.getBindingType()) || BindingType_DEFAULT.equals(bindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingType)) {
                this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.composite, this);
            }
        }
    }

    public QName getPortQName() {
        if (this.portQName == null) {
            String name = this.getAnnoWebServicePortName();
            String tns = this.getAnnoWebServiceTargetNamespace();
            this.portQName = new QName(tns, name);
        }
        return this.portQName;
    }

    public QName getServiceQName() {
        if (this.serviceQName == null) {
            QName serviceDescQName = this.getServiceDescription().getServiceQName();
            if (!DescriptionUtils.isEmpty(serviceDescQName)) {
                this.serviceQName = serviceDescQName;
            } else {
                String localPart = this.getAnnoWebServiceServiceName();
                String tns = this.getAnnoWebServiceTargetNamespace();
                this.serviceQName = new QName(tns, localPart);
            }
        }
        return this.serviceQName;
    }

    public ServiceDescription getServiceDescription() {
        return this.parentServiceDescription;
    }

    ServiceDescriptionImpl getServiceDescriptionImpl() {
        return this.parentServiceDescription;
    }

    public EndpointInterfaceDescription getEndpointInterfaceDescription() {
        return this.endpointInterfaceDescription;
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    boolean isDynamicPort() {
        return this.isDynamicPort;
    }

    void updateWithSEI(Class sei) {
        if (this.isDynamicPort()) {
            throw ExceptionFactory.makeWebServiceException("Can not update an SEI on a dynamic port.  PortQName:" + this.portQName);
        }
        if (sei == null) {
            throw ExceptionFactory.makeWebServiceException("EndpointDescription.updateWithSEI was passed a null SEI.  PortQName:" + this.portQName);
        }
        if (this.endpointInterfaceDescription != null) {
            ((EndpointInterfaceDescriptionImpl)this.endpointInterfaceDescription).updateWithSEI(sei);
        } else {
            this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(sei, this);
        }
    }

    private void setupAxisService() {
        if (!this.isDynamicPort && this.getServiceDescriptionImpl().getWSDLWrapper() != null) {
            this.isAxisServiceBuiltFromWSDL = this.buildAxisServiceFromWSDL();
        } else {
            this.buildAxisServiceFromAnnotations();
        }
        if (this.axisService == null) {
            throw ExceptionFactory.makeWebServiceException("Unable to create AxisService for " + this.createAxisServiceName());
        }
        Parameter serviceNameParameter = new Parameter();
        serviceNameParameter.setName("WSDL_SERVICE_QNAME");
        serviceNameParameter.setValue(this.getServiceDescription().getServiceQName());
        Parameter portParameter = new Parameter();
        portParameter.setName("WSDL_PORT");
        portParameter.setValue(this.portQName.getLocalPart());
        try {
            this.axisService.addParameter(serviceNameParameter);
            this.axisService.addParameter(portParameter);
        }
        catch (AxisFault e) {
            e.printStackTrace();
        }
    }

    private void setupAxisServiceFromDBL() {
        this.isAxisServiceBuiltFromWSDL = false;
        if (this.getServiceDescriptionImpl().getWSDLWrapper() != null) {
            this.isAxisServiceBuiltFromWSDL = this.buildAxisServiceFromWSDL();
        }
        if (!this.isAxisServiceBuiltFromWSDL) {
            this.buildAxisServiceFromAnnotations();
        }
        if (this.axisService == null) {
            throw ExceptionFactory.makeWebServiceException("Unable to create AxisService for " + this.createAxisServiceName());
        }
        Parameter portTypeNameParameter = new Parameter();
        portTypeNameParameter.setName("WSDL_PORTTYPE_NAME");
        portTypeNameParameter.setValue(this.getName());
        Parameter serviceNameParameter = new Parameter();
        serviceNameParameter.setName("WSDL_SERVICE_QNAME");
        serviceNameParameter.setValue(this.getServiceDescription().getServiceQName());
        Parameter portParameter = new Parameter();
        portParameter.setName("WSDL_PORT");
        portParameter.setValue(this.getPortQName().getLocalPart());
        Parameter serviceClassNameParameter = new Parameter();
        serviceClassNameParameter.setName("ServiceClass");
        serviceClassNameParameter.setValue(DescriptionUtils.javifyClassName(this.composite.getClassName()));
        try {
            this.axisService.addParameter(portTypeNameParameter);
            this.axisService.addParameter(serviceNameParameter);
            this.axisService.addParameter(portParameter);
            this.axisService.addParameter(serviceClassNameParameter);
        }
        catch (AxisFault e) {
            e.printStackTrace();
        }
    }

    private boolean buildAxisServiceFromWSDL() {
        boolean isBuiltFromWSDL = false;
        try {
            Definition def = this.getServiceDescriptionImpl().getWSDLWrapper().getUnwrappedDefinition();
            WSDL11ToAxisServiceBuilder serviceBuilder = new WSDL11ToAxisServiceBuilder(def, this.getServiceDescription().getServiceQName(), this.getPortQName().getLocalPart());
            if (this.useComposite()) {
                URIResolverImpl uriResolver = new URIResolverImpl(this.composite.getClassLoader());
                serviceBuilder.setCustomResolver(uriResolver);
            } else {
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                URIResolverImpl uriResolver = new URIResolverImpl(classLoader);
                serviceBuilder.setCustomResolver(uriResolver);
            }
            if (this.getServiceDescriptionImpl().isServerSide()) {
                serviceBuilder.setServerSide(true);
            } else {
                serviceBuilder.setServerSide(false);
            }
            this.axisService = serviceBuilder.populateService();
            this.axisService.setName(this.createAxisServiceName());
            isBuiltFromWSDL = true;
        }
        catch (AxisFault e) {
            String wsdlLocation = this.getServiceDescriptionImpl().getWSDLLocation() != null ? this.getServiceDescriptionImpl().getWSDLLocation().toString() : null;
            String implClassName = null;
            implClassName = this.useComposite() ? this.composite.getClassName() : (this.implOrSEIClass != null ? this.implOrSEIClass.getName() : null);
            log.warn("The WSDL file could not be used due to an exception.  The WSDL will be ignored and annotations will be used.  Implementation class: " + implClassName + "; WSDL Location: " + wsdlLocation);
            isBuiltFromWSDL = false;
            return isBuiltFromWSDL;
        }
        return isBuiltFromWSDL;
    }

    private void buildAxisServiceFromAnnotations() {
        String serviceName = null;
        serviceName = this.portQName != null ? this.createAxisServiceName() : "anonService" + this.hashCode() + System.currentTimeMillis();
        this.axisService = new AxisService(serviceName);
    }

    private void releaseAxisServiceResources() {
        if (this.axisService != null) {
            this.axisService.releaseSchemaList();
        }
    }

    private void buildDescriptionHierachy() {
        if (this.useComposite()) {
            if (!this.isDynamicPort && this.isWSDLFullySpecified()) {
                this.buildEndpointDescriptionFromWSDL();
            } else {
                this.buildEndpointDescriptionFromAnnotations();
            }
        } else if (!this.isDynamicPort && this.isWSDLFullySpecified()) {
            this.buildEndpointDescriptionFromWSDL();
        } else if (this.implOrSEIClass != null) {
            this.buildEndpointDescriptionFromAnnotations();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildEndpointDescriptionFromWSDL() {
        Definition wsdlDefinition = this.getServiceDescriptionImpl().getWSDLWrapper().getDefinition();
        Service wsdlService = wsdlDefinition.getService(this.getServiceDescription().getServiceQName());
        if (wsdlService == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr2", this.createAxisServiceName()));
        }
        Map wsdlPorts = wsdlService.getPorts();
        boolean wsdlPortFound = false;
        if (wsdlPorts != null && wsdlPorts.size() > 0) {
            Iterator wsdlPortIterator = wsdlPorts.values().iterator();
            while (wsdlPortIterator.hasNext() && !wsdlPortFound) {
                Port wsdlPort = (Port)wsdlPortIterator.next();
                if (!wsdlPort.getName().equals(this.portQName.getLocalPart())) continue;
                if (this.useComposite()) {
                    String seiClassName = this.getAnnoWebServiceEndpointInterface();
                    if (DescriptionUtils.isEmpty(seiClassName)) {
                        this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.composite, true, this);
                    } else {
                        if (!this.getServiceDescriptionImpl().isDBCMap()) throw ExceptionFactory.makeWebServiceException("Unable to create an EndpointInterfaceDescriptionImpl. DescripitonBuilderComposite map is not available from ServiceDescripition. ");
                        this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.getServiceDescriptionImpl().getDBCforKey(seiClassName), false, this);
                    }
                } else {
                    this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this);
                    ((EndpointInterfaceDescriptionImpl)this.endpointInterfaceDescription).updateWithSEI(this.implOrSEIClass);
                }
                wsdlPortFound = true;
            }
        }
        if (wsdlPortFound) return;
        throw ExceptionFactory.makeWebServiceException("WSDL Port not found for port " + this.portQName.getLocalPart());
    }

    private void addAnonymousAxisOperations() {
        if (this.axisService != null) {
            OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ServiceClient.ANON_OUT_ONLY_OP);
            this.axisService.addOperation(outOnlyOperation);
            OutInAxisOperation outInOperation = new OutInAxisOperation(ServiceClient.ANON_OUT_IN_OP);
            this.axisService.addOperation(outInOperation);
        }
    }

    public ServiceClient getServiceClient() {
        try {
            if (this.serviceClient == null) {
                ConfigurationContext configCtx = this.getServiceDescription().getAxisConfigContext();
                AxisService axisSvc = this.getAxisService();
                AxisConfiguration axisCfg = configCtx.getAxisConfiguration();
                if (axisCfg.getService(axisSvc.getName()) != null) {
                    axisSvc.setName(axisSvc.getName() + this.hashCode());
                }
                this.serviceClient = new ServiceClient(configCtx, axisSvc);
            }
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceClientCreateError"), e);
        }
        return this.serviceClient;
    }

    private String createAxisServiceName() {
        String portName = null;
        portName = this.portQName != null ? this.portQName.getLocalPart() : "NoPortNameSpecified";
        return this.getServiceDescription().getServiceQName().getLocalPart() + "." + portName;
    }

    public boolean isWSDLFullySpecified() {
        return this.isAxisServiceBuiltFromWSDL;
    }

    public boolean isProviderBased() {
        return this.webServiceProviderAnnotation != null;
    }

    public boolean isEndpointBased() {
        return this.webServiceAnnotation != null;
    }

    private boolean useComposite() {
        return this.composite != null;
    }

    private void setup() {
        this.getAnnoWebServiceWSDLLocation();
        this.getAnnoWebServiceServiceName();
        this.getAnnoWebServicePortName();
        this.getAnnoWebServiceTargetNamespace();
        this.getAnnoWebServiceName();
        this.getAnnoWebServiceEndpointInterface();
        this.getAnnoServiceMode();
        this.getAnnoServiceModeValue();
        this.getAnnoBindingType();
        this.getAnnoBindingTypeValue();
        this.getAnnoHandlerChainAnnotation();
        this.getHandlerChain();
    }

    public String getAnnoWebServiceWSDLLocation() {
        if (this.annotation_WsdlLocation == null) {
            if (this.getAnnoWebService() != null) {
                DescriptionBuilderComposite seic;
                this.annotation_WsdlLocation = this.getAnnoWebService().wsdlLocation();
                if (this.useComposite() && !DescriptionUtils.isEmpty(this.getAnnoWebServiceEndpointInterface()) && this.getServiceDescriptionImpl().isDBCMap() && !DescriptionUtils.isEmpty((seic = this.getServiceDescriptionImpl().getDBCforKey(this.composite.getWebServiceAnnot().endpointInterface())).getWebServiceAnnot().wsdlLocation())) {
                    this.annotation_WsdlLocation = seic.getWebServiceAnnot().wsdlLocation();
                }
            } else {
                this.annotation_WsdlLocation = this.getAnnoWebServiceProvider() != null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceProvider().wsdlLocation()) ? this.getAnnoWebServiceProvider().wsdlLocation() : "";
            }
        }
        return this.annotation_WsdlLocation;
    }

    public String getAnnoWebServiceServiceName() {
        if (this.annotation_ServiceName == null) {
            this.annotation_ServiceName = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().serviceName()) ? this.getAnnoWebService().serviceName() : (this.getAnnoWebServiceProvider() != null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceProvider().serviceName()) ? this.getAnnoWebServiceProvider().serviceName() : (this.useComposite() ? DescriptionUtils.getSimpleJavaClassName(this.composite.getClassName()) + "Service" : DescriptionUtils.getSimpleJavaClassName(this.implOrSEIClass) + "Service"));
        }
        return this.annotation_ServiceName;
    }

    public String getAnnoWebServicePortName() {
        if (this.annotation_PortName == null) {
            this.annotation_PortName = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().portName()) ? this.getAnnoWebService().portName() : (this.getAnnoWebServiceProvider() != null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceProvider().portName()) ? this.getAnnoWebServiceProvider().portName() : (this.isProviderBased() ? (this.useComposite() ? DescriptionUtils.getSimpleJavaClassName(this.composite.getClassName()) + "Port" : DescriptionUtils.getSimpleJavaClassName(this.implOrSEIClass) + "Port") : this.getAnnoWebServiceName() + "Port"));
        }
        return this.annotation_PortName;
    }

    public String getAnnoWebServiceTargetNamespace() {
        if (this.annotation_TargetNamespace == null) {
            this.annotation_TargetNamespace = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().targetNamespace()) ? this.getAnnoWebService().targetNamespace() : (this.getAnnoWebServiceProvider() != null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceProvider().targetNamespace()) ? this.getAnnoWebServiceProvider().targetNamespace() : (this.useComposite() ? DescriptionUtils.makeNamespaceFromPackageName(DescriptionUtils.getJavaPackageName(this.composite.getClassName()), "http") : DescriptionUtils.makeNamespaceFromPackageName(DescriptionUtils.getJavaPackageName(this.implOrSEIClass), "http")));
        }
        return this.annotation_TargetNamespace;
    }

    public WebServiceProvider getAnnoWebServiceProvider() {
        return this.webServiceProviderAnnotation;
    }

    public WebService getAnnoWebService() {
        return this.webServiceAnnotation;
    }

    public String getAnnoWebServiceEndpointInterface() {
        if (this.webService_EndpointInterface == null) {
            this.webService_EndpointInterface = !this.isProviderBased() && this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().endpointInterface()) ? this.getAnnoWebService().endpointInterface() : "";
        }
        return this.webService_EndpointInterface;
    }

    public String getAnnoWebServiceName() {
        if (this.webService_Name == null) {
            this.webService_Name = !this.isProviderBased() ? (this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().name()) ? this.getAnnoWebService().name() : (this.useComposite() ? DescriptionUtils.getSimpleJavaClassName(this.composite.getClassName()) : DescriptionUtils.getSimpleJavaClassName(this.implOrSEIClass))) : "";
        }
        return this.webService_Name;
    }

    public ServiceMode getAnnoServiceMode() {
        if (this.serviceModeAnnotation == null) {
            if (this.useComposite()) {
                this.serviceModeAnnotation = this.composite.getServiceModeAnnot();
            } else if (this.implOrSEIClass != null) {
                this.serviceModeAnnotation = (ServiceMode)EndpointDescriptionImpl.getAnnotation(this.implOrSEIClass, ServiceMode.class);
            }
        }
        return this.serviceModeAnnotation;
    }

    public Service.Mode getServiceMode() {
        return this.getAnnoServiceModeValue();
    }

    public Service.Mode getAnnoServiceModeValue() {
        if (this.isProviderBased() && this.serviceModeValue == null) {
            this.serviceModeValue = this.getAnnoServiceMode() != null ? this.getAnnoServiceMode().value() : ServiceMode_DEFAULT;
        }
        return this.serviceModeValue;
    }

    public BindingType getAnnoBindingType() {
        if (this.bindingTypeAnnotation == null) {
            if (this.useComposite()) {
                this.bindingTypeAnnotation = this.composite.getBindingTypeAnnot();
            } else if (this.implOrSEIClass != null) {
                this.bindingTypeAnnotation = (BindingType)EndpointDescriptionImpl.getAnnotation(this.implOrSEIClass, BindingType.class);
            }
        }
        return this.bindingTypeAnnotation;
    }

    public String getBindingType() {
        return this.getAnnoBindingTypeValue();
    }

    public String getAnnoBindingTypeValue() {
        if (this.bindingTypeValue == null) {
            this.bindingTypeValue = this.getAnnoBindingType() != null && !DescriptionUtils.isEmpty(this.getAnnoBindingType().value()) ? this.getAnnoBindingType().value() : BindingType_DEFAULT;
        }
        return this.bindingTypeValue;
    }

    public HandlerChainsType getHandlerChain() {
        if (this.handlerChainsType == null) {
            this.getAnnoHandlerChainAnnotation();
            if (this.handlerChainAnnotation != null) {
                String handlerFileName = this.handlerChainAnnotation.file();
                if (log.isDebugEnabled()) {
                    if (this.composite != null) {
                        log.debug("EndpointDescriptionImpl.getHandlerChain: fileName: " + handlerFileName + " className: " + this.composite.getClassName());
                    } else {
                        log.debug("EndpointDescriptionImpl.getHandlerChain: fileName: " + handlerFileName + " className: " + this.implOrSEIClass.getName());
                    }
                }
                String className = this.composite != null ? this.composite.getClassName() : this.implOrSEIClass.getName();
                ClassLoader classLoader = this.composite != null ? this.composite.getClassLoader() : this.getClass().getClassLoader();
                InputStream is = DescriptionUtils.openHandlerConfigStream(handlerFileName, className, classLoader);
                try {
                    JAXBContext jc = JAXBContext.newInstance("org.apache.axis2.jaxws.description.xml.handler", this.getClass().getClassLoader());
                    Unmarshaller u = jc.createUnmarshaller();
                    JAXBElement o = (JAXBElement)u.unmarshal(is);
                    this.handlerChainsType = (HandlerChainsType)o.getValue();
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException("EndpointDescriptionImpl: getHandlerChain: thrown when attempting to unmarshall JAXB content");
                }
            }
        }
        return this.handlerChainsType;
    }

    public HandlerChain getAnnoHandlerChainAnnotation() {
        if (this.handlerChainAnnotation == null) {
            if (this.useComposite()) {
                DescriptionBuilderComposite seic;
                this.handlerChainAnnotation = this.composite.getHandlerChainAnnot();
                if (this.handlerChainAnnotation == null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceEndpointInterface()) && this.getServiceDescriptionImpl().isDBCMap() && (seic = this.getServiceDescriptionImpl().getDBCforKey(this.composite.getWebServiceAnnot().endpointInterface())) != null) {
                    this.handlerChainAnnotation = seic.getHandlerChainAnnot();
                }
            } else if (this.implOrSEIClass != null) {
                this.handlerChainAnnotation = (HandlerChain)EndpointDescriptionImpl.getAnnotation(this.implOrSEIClass, HandlerChain.class);
            }
        }
        return this.handlerChainAnnotation;
    }

    private Definition getWSDLDefinition() {
        return ((ServiceDescriptionWSDL)((Object)this.getServiceDescription())).getWSDLDefinition();
    }

    public Service getWSDLService() {
        Definition defn = this.getWSDLDefinition();
        if (defn != null) {
            return defn.getService(this.getServiceQName());
        }
        return null;
    }

    public Port getWSDLPort() {
        Service service = this.getWSDLService();
        if (service != null) {
            return service.getPort(this.getPortQName().getLocalPart());
        }
        return null;
    }

    public Binding getWSDLBinding() {
        Binding wsdlBinding = null;
        Port wsdlPort = this.getWSDLPort();
        Definition wsdlDef = this.getWSDLDefinition();
        if (wsdlPort != null && wsdlDef != null) {
            wsdlBinding = wsdlPort.getBinding();
        }
        return wsdlBinding;
    }

    public String getWSDLBindingType() {
        String wsdlBindingType = null;
        Binding wsdlBinding = this.getWSDLBinding();
        if (wsdlBinding != null) {
            List elements = wsdlBinding.getExtensibilityElements();
            for (ExtensibilityElement e : elements) {
                if (SOAPBinding.class.isAssignableFrom(e.getClass())) {
                    SOAPBinding soapBnd = (SOAPBinding)e;
                    wsdlBindingType = soapBnd.getElementType().getNamespaceURI();
                    break;
                }
                if (SOAP12Binding.class.isAssignableFrom(e.getClass())) {
                    SOAP12Binding soapBnd = (SOAP12Binding)e;
                    wsdlBindingType = soapBnd.getElementType().getNamespaceURI();
                    break;
                }
                if (!HTTPBinding.class.isAssignableFrom(e.getClass())) continue;
                HTTPBinding httpBnd = (HTTPBinding)e;
                wsdlBindingType = httpBnd.getElementType().getNamespaceURI();
                break;
            }
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(wsdlBindingType)) {
                wsdlBindingType = BindingType_DEFAULT;
            } else if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(wsdlBindingType)) {
                wsdlBindingType = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
            } else if ("http://schemas.xmlsoap.org/wsdl/http/".equals(wsdlBindingType)) {
                wsdlBindingType = "http://www.w3.org/2004/08/wsdl/http";
            }
        }
        return wsdlBindingType;
    }

    public String getName() {
        return this.getAnnoWebServiceName();
    }

    public String getTargetNamespace() {
        return this.getAnnoWebServiceTargetNamespace();
    }

    public PortInfo getPortInfo() {
        if (this.portInfo == null) {
            this.portInfo = new PortInfoImpl(this.getServiceQName(), this.getPortQName(), this.getBindingType());
        }
        return this.portInfo;
    }

    public void setClientBindingID(String clientBindingID) {
        if (clientBindingID == null) {
            this.clientBindingID = BindingType_DEFAULT;
        } else if (this.validateClientBindingID(clientBindingID)) {
            this.clientBindingID = clientBindingID;
        } else {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortErr0", this.getPortQName().toString()));
        }
    }

    private boolean validateClientBindingID(String bindingId) {
        boolean isValid = true;
        if (!(bindingId == null || bindingId.equals(BindingType_DEFAULT) || bindingId.equals("http://www.w3.org/2004/08/wsdl/http") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortErr0", this.getPortQName().toString()));
        }
        return isValid;
    }

    public String getClientBindingID() {
        if (this.clientBindingID == null) {
            if (this.getWSDLDefinition() != null) {
                this.clientBindingID = this.getWSDLBindingType();
                if (this.clientBindingID == null) {
                    this.clientBindingID = BindingType_DEFAULT;
                }
            } else {
                this.clientBindingID = BindingType_DEFAULT;
            }
        }
        return this.clientBindingID;
    }

    public void setEndpointAddress(String endpointAddress) {
        if (!DescriptionUtils.isEmpty(endpointAddress)) {
            this.endpointAddress = endpointAddress;
        } else if (log.isDebugEnabled()) {
            log.debug("A null or empty endpoint address was attempted to be set", new Throwable("Stack Traceback"));
        }
    }

    public String getEndpointAddress() {
        if (this.endpointAddress == null) {
            this.endpointAddress = this.getWSDLSOAPAddress();
        }
        return this.endpointAddress;
    }

    public String getWSDLSOAPAddress() {
        Port wsdlPort;
        if (this.wsdlSOAPAddress == null && (wsdlPort = this.getWSDLPort()) != null) {
            List extElementList = wsdlPort.getExtensibilityElements();
            for (Object listElement : extElementList) {
                String soapAddress;
                ExtensibilityElement extElement = (ExtensibilityElement)listElement;
                if (!EndpointDescriptionImpl.isSOAPAddressElement(extElement) || DescriptionUtils.isEmpty(soapAddress = EndpointDescriptionImpl.getSOAPAddressFromElement(extElement))) continue;
                this.wsdlSOAPAddress = soapAddress;
            }
        }
        return this.wsdlSOAPAddress;
    }

    static boolean isSOAPAddressElement(ExtensibilityElement exElement) {
        boolean isAddress = false;
        if (exElement != null) {
            isAddress = SOAP_11_ADDRESS_ELEMENT.equals(exElement.getElementType()) || SOAP_12_ADDRESS_ELEMENT.equals(exElement.getElementType());
        }
        return isAddress;
    }

    static String getSOAPAddressFromElement(ExtensibilityElement extElement) {
        String returnAddress = null;
        if (extElement != null) {
            if (SOAP_11_ADDRESS_ELEMENT.equals(extElement.getElementType())) {
                returnAddress = ((SOAPAddress)extElement).getLocationURI();
            } else if (SOAP_12_ADDRESS_ELEMENT.equals(extElement.getElementType())) {
                returnAddress = ((SOAP12Address)extElement).getLocationURI();
            }
        }
        return returnAddress;
    }

    private QName selectPortToUse() {
        QName portToUse = null;
        portToUse = this.getWSDLService() != null ? this.selectWSDLPortToUse() : this.getPortQName();
        return portToUse;
    }

    private QName selectWSDLPortToUse() {
        List<Port> wsdlPortsUsingPortType;
        QName wsdlPortToUse = null;
        String portTypeLP = this.getName();
        String portTypeTNS = this.getTargetNamespace();
        QName portTypeQN = new QName(portTypeTNS, portTypeLP);
        ServiceDescriptionWSDL serviceDescWSDL = (ServiceDescriptionWSDL)((Object)this.getServiceDescription());
        List<Port> wsdlPortsUsingSOAPAddresses = serviceDescWSDL.getWSDLPortsUsingSOAPAddress(wsdlPortsUsingPortType = serviceDescWSDL.getWSDLPortsUsingPortType(portTypeQN));
        if (wsdlPortsUsingSOAPAddresses != null && !wsdlPortsUsingSOAPAddresses.isEmpty()) {
            Port portToUse = (Port)wsdlPortsUsingSOAPAddresses.toArray()[0];
            String portLocalPart = portToUse.getName();
            String portNamespace = serviceDescWSDL.getWSDLService().getQName().getNamespaceURI();
            wsdlPortToUse = new QName(portNamespace, portLocalPart);
        }
        return wsdlPortToUse;
    }

    private WsdlComposite generateWSDL(DescriptionBuilderComposite dbc) {
        WsdlComposite wsdlComposite = null;
        Definition defn = dbc.getWsdlDefinition();
        if (defn == null || !this.isAxisServiceBuiltFromWSDL) {
            if (dbc.getCustomWsdlGenerator() != null) {
                String implName = null;
                implName = this.axisService == null ? DescriptionUtils.javifyClassName(this.composite.getClassName()) : (String)this.axisService.getParameterValue("ServiceClass");
                wsdlComposite = dbc.getCustomWsdlGenerator().generateWsdl(implName, this.getBindingType());
                if (wsdlComposite != null) {
                    wsdlComposite.setWsdlFileName((this.getAnnoWebServiceServiceName() + ".wsdl").toLowerCase());
                    EndpointDescriptionImpl.wrapWsdlDefinitions(wsdlComposite);
                    Definition wsdlDef = wsdlComposite.getRootWsdlDefinition();
                    try {
                        WSDL4JWrapper wsdl4jWrapper = new WSDL4JWrapper(dbc.getWsdlURL(), wsdlDef);
                        this.getServiceDescriptionImpl().setGeneratedWsdlWrapper(wsdl4jWrapper);
                    }
                    catch (Exception e) {
                        throw ExceptionFactory.makeWebServiceException("EndpointDescriptionImpl: WSDLException thrown when attempting to instantiate WSDL4JWrapper ");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("The custom WSDL generator returned null, so no generated WSDL is available");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("No custom WSDL generator was supplied, so WSDL can not be generated");
            }
        }
        return wsdlComposite;
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (RuntimeException)e.getException();
        }
        return cl;
    }

    private static void wrapWsdlDefinitions(WsdlComposite wsdlComposite) {
        if (wsdlComposite.getWsdlDefinitionsMap() != null && !wsdlComposite.getWsdlDefinitionsMap().isEmpty()) {
            for (String key : wsdlComposite.getWsdlDefinitionsMap().keySet()) {
                Definition def = wsdlComposite.getWsdlDefinitionsMap().get(key);
                WSDLDefinitionWrapper wrapper = new WSDLDefinitionWrapper(def);
                wsdlComposite.getWsdlDefinitionsMap().put(key, wrapper);
            }
        }
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("Name: " + this.getName());
            string.append("; ");
            string.append("Endpoint Address: " + this.getEndpointAddress());
            string.append("\n");
            string.append("ServiceQName: " + this.getServiceQName());
            string.append("; ");
            string.append("PortQName: " + this.getPortQName());
            string.append("; ");
            string.append("TargetNamespace: " + this.getTargetNamespace());
            string.append("\n");
            string.append("Service Mode: " + (Object)((Object)this.getServiceMode()));
            string.append("; ");
            string.append("Binding Type: " + this.getBindingType());
            string.append("; ");
            string.append("Client Binding Type: " + this.getClientBindingID());
            string.append("\n");
            string.append("Is provider-based: " + this.isProviderBased());
            string.append("; ");
            string.append("Is proxy-based: " + this.isEndpointBased());
            string.append("; ");
            string.append("Is WSDL fully specified: " + this.isWSDLFullySpecified());
            string.append("\n");
            string.append("AxisService: " + this.getAxisService());
            string.append("\n");
            EndpointInterfaceDescription endpointInterfaceDesc = this.getEndpointInterfaceDescription();
            if (endpointInterfaceDesc != null) {
                string.append("EndpointInterfaceDescription: " + endpointInterfaceDesc.toString());
            } else {
                string.append("EndpointInterfaceDescription is null.");
            }
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Debug information for the EndpointDescription cannot be completed at this time.");
            return string.toString();
        }
        return string.toString();
    }

    private static Annotation getAnnotation(final Class cls, final Class annotation2) {
        return (Annotation)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cls.getAnnotation(annotation2);
            }
        });
    }
}

