/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.xml.namespace.QName;
import javax.xml.ws.Response;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.AttachmentType;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebMethodAnnot;
import org.apache.axis2.jaxws.description.impl.AttachmentDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.OperationDescriptionImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DescriptionUtils {
    private static final Log log = LogFactory.getLog(DescriptionUtils.class);
    static final String NO_PACKAGE_HOST_NAME = "DefaultNamespace";

    DescriptionUtils() {
    }

    static boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    static boolean isEmpty(QName qname2) {
        return qname2 == null || DescriptionUtils.isEmpty(qname2.getLocalPart());
    }

    static boolean falseExclusionsExist(DescriptionBuilderComposite dbc) {
        MethodDescriptionComposite mdc2 = null;
        for (MethodDescriptionComposite mdc2 : dbc.getMethodDescriptionsList()) {
            WebMethodAnnot wma = mdc2.getWebMethodAnnot();
            if (wma == null || wma.exclude()) continue;
            return true;
        }
        return false;
    }

    static ArrayList<MethodDescriptionComposite> getMethodsWithFalseExclusions(DescriptionBuilderComposite dbc) {
        ArrayList<MethodDescriptionComposite> mdcList = new ArrayList<MethodDescriptionComposite>();
        Iterator<MethodDescriptionComposite> iter = dbc.getMethodDescriptionsList().iterator();
        if (DescriptionUtils.falseExclusionsExist(dbc)) {
            while (iter.hasNext()) {
                MethodDescriptionComposite mdc = iter.next();
                if (mdc.getWebMethodAnnot() == null || mdc.getWebMethodAnnot().exclude()) continue;
                mdc.setDeclaringClass(dbc.getClassName());
                mdcList.add(mdc);
            }
        }
        return mdcList;
    }

    static boolean isExcludeTrue(MethodDescriptionComposite mdc) {
        return mdc.getWebMethodAnnot() != null && mdc.getWebMethodAnnot().exclude();
    }

    static String javifyClassName(String className) {
        if (className.indexOf("/") != -1) {
            return className.replaceAll("/", ".");
        }
        return className;
    }

    static String getSimpleJavaClassName(Class theClass) {
        String returnName = null;
        if (theClass != null) {
            String fqName = theClass.getName();
            int endOfPackageIndex = fqName.lastIndexOf(46);
            int startOfClassIndex = endOfPackageIndex + 1;
            returnName = fqName.substring(startOfClassIndex);
        }
        return returnName;
    }

    static String getSimpleJavaClassName(String name) {
        String returnName = null;
        if (name != null) {
            String fqName = name;
            int endOfPackageIndex = fqName.lastIndexOf(46);
            int startOfClassIndex = endOfPackageIndex + 1;
            returnName = fqName.substring(startOfClassIndex);
        }
        return returnName;
    }

    static String getJavaPackageName(Class theClass) {
        String fqName;
        int endOfPackageIndex;
        String returnPackage = null;
        if (theClass != null && (endOfPackageIndex = (fqName = theClass.getName()).lastIndexOf(46)) >= 0) {
            returnPackage = fqName.substring(0, endOfPackageIndex);
        }
        return returnPackage;
    }

    static String getJavaPackageName(String theClassName) {
        String fqName;
        int endOfPackageIndex;
        String returnPackage = null;
        if (theClassName != null && (endOfPackageIndex = (fqName = theClassName).lastIndexOf(46)) >= 0) {
            returnPackage = fqName.substring(0, endOfPackageIndex);
        }
        return returnPackage;
    }

    static String makeNamespaceFromPackageName(String packageName, String protocol) {
        if (DescriptionUtils.isEmpty(protocol)) {
            protocol = "http";
        }
        if (DescriptionUtils.isEmpty(packageName)) {
            return protocol + "://" + NO_PACKAGE_HOST_NAME;
        }
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString() + "/";
    }

    static boolean createOperationDescription(String methodName) {
        return !methodName.equals("<init>");
    }

    public static InputStream openHandlerConfigStream(String configFile, String className, ClassLoader classLoader) {
        InputStream configStream = null;
        if (log.isDebugEnabled()) {
            log.debug("Attempting to load @HandlerChain configuration file: " + configFile + " relative to class: " + className);
        }
        try {
            URL configURL = new URL(configFile);
            if (configURL != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found absolute @HandlerChain configuration file: " + configFile);
                }
                configStream = configURL.openStream();
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("hcConfigLoadFail", configFile, className, e.toString()));
        }
        if (configStream == null) {
            if (log.isDebugEnabled()) {
                log.debug("@HandlerChain.file attribute referes to a relative location: " + configFile);
            }
            className = className.replace(".", "/");
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Resolving @HandlerChain configuration file: " + configFile + " relative to class file: " + className);
                }
                URI uri = new URI(className);
                uri = uri.resolve(configFile);
                String resolvedPath = uri.toString();
                if (log.isDebugEnabled()) {
                    log.debug("@HandlerChain.file resolved file path location: " + resolvedPath);
                }
                configStream = classLoader.getResourceAsStream(resolvedPath);
            }
            catch (URISyntaxException e) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("hcConfigLoadFail", configFile, className, e.toString()));
            }
        }
        if (configStream == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("handlerChainNS", configFile, className));
        }
        if (log.isDebugEnabled()) {
            log.debug("@HandlerChain configuration file: " + configFile + " in class: " + className + " was successfully loaded.");
        }
        return configStream;
    }

    public static boolean isAsync(Method method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        Class<Future> returnType = method.getReturnType();
        return methodName.endsWith("Async") && (returnType.isAssignableFrom(Response.class) || returnType.isAssignableFrom(Future.class));
    }

    public static void getAttachmentFromBinding(OperationDescriptionImpl opDesc, Binding binding) {
        if (binding != null) {
            for (BindingOperation bindingOp : binding.getBindingOperations()) {
                if (log.isDebugEnabled()) {
                    log.debug("Processing binding operation: " + bindingOp.getName());
                }
                if (!bindingOp.getName().equals(opDesc.getName().getLocalPart())) continue;
                if (bindingOp.getBindingInput() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Processing binding opertion input");
                    }
                    DescriptionUtils.processBindingForMIME(bindingOp.getBindingInput().getExtensibilityElements(), opDesc, bindingOp.getOperation(), true);
                }
                if (bindingOp.getBindingOutput() == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Processing binding operation output");
                }
                DescriptionUtils.processBindingForMIME(bindingOp.getBindingOutput().getExtensibilityElements(), opDesc, bindingOp.getOperation(), false);
            }
        }
    }

    private static void processBindingForMIME(List extensibilityElements, OperationDescriptionImpl opDesc, Operation operation, boolean isRequest) {
        for (Object obj : extensibilityElements) {
            if (!(obj instanceof MIMEMultipartRelated)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found a mime:multipartRelated extensiblity element.");
            }
            MIMEMultipartRelated mime = (MIMEMultipartRelated)obj;
            Iterator partIter = mime.getMIMEParts().iterator();
            while (partIter.hasNext()) {
                if (log.isDebugEnabled()) {
                    log.debug("Found a mime:part child element.");
                }
                MIMEPart mimePart = (MIMEPart)partIter.next();
                for (Object part : mimePart.getExtensibilityElements()) {
                    if (part instanceof MIMEContent) {
                        MIMEContent mimeContent = (MIMEContent)part;
                        String partName = mimeContent.getPart();
                        String type = mimeContent.getType();
                        if (opDesc.getPartAttachmentDescription(partName) == null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Adding new AttachmentDescription for part: " + partName + " on operation: " + opDesc.getOperationName());
                            }
                            AttachmentDescriptionImpl attachmentDesc = new AttachmentDescriptionImpl(AttachmentType.SWA, new String[]{type});
                            opDesc.addPartAttachmentDescription(partName, attachmentDesc);
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Already created AttachmentDescription for part: " + partName + " of type: " + type);
                        continue;
                    }
                    if (!(part instanceof SOAPBody) && !(part instanceof SOAP12Body)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Found a body element with potential nested mime content");
                    }
                    if (isRequest) {
                        opDesc.setHasRequestSwaRefAttachments(true);
                        continue;
                    }
                    opDesc.setHasResponseSwaRefAttachments(true);
                }
            }
        }
    }

    public static String getNamespaceFromSOAPElement(List extElements) {
        for (Object extObj : extElements) {
            MIMEMultipartRelated mime;
            List mimeParts;
            Iterator itr;
            if (extObj instanceof SOAPBody) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning SOAPBody namespace: " + ((SOAPBody)extObj).getNamespaceURI());
                }
                return ((SOAPBody)extObj).getNamespaceURI();
            }
            if (extObj instanceof SOAP12Body) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning SOAP12Body namespace: " + ((SOAP12Body)extObj).getNamespaceURI());
                }
                return ((SOAP12Body)extObj).getNamespaceURI();
            }
            if (extObj instanceof SOAPHeader) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning SOAPHeader namespace: " + ((SOAPHeader)extObj).getNamespaceURI());
                }
                return ((SOAPHeader)extObj).getNamespaceURI();
            }
            if (extObj instanceof SOAP12Header) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning SOAP12Header namespace: " + ((SOAP12Header)extObj).getNamespaceURI());
                }
                return ((SOAP12Header)extObj).getNamespaceURI();
            }
            if (!(extObj instanceof MIMEMultipartRelated)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found a MIMEMultipartRelated element.  Unwrapping to get SOAP binding.");
            }
            if (!(itr = (mimeParts = (mime = (MIMEMultipartRelated)extObj).getMIMEParts()).iterator()).hasNext()) continue;
            MIMEPart mimePart = (MIMEPart)itr.next();
            List elements = mimePart.getExtensibilityElements();
            String ns = DescriptionUtils.getNamespaceFromSOAPElement(elements);
            return ns;
        }
        return null;
    }
}

