/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder;

import org.apache.axis2.jaxws.description.builder.DescriptionBuilderUtils;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebParamAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceContextAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;

public class ParameterDescriptionComposite {
    private String parameterType;
    private Class parameterTypeClass;
    private WebParamAnnot webParamAnnot;
    private WebServiceRefAnnot webServiceRefAnnot;
    private WebServiceContextAnnot webServiceContextAnnot;
    private int listOrder;
    private boolean isListType;
    private MethodDescriptionComposite parentMDC;

    public ParameterDescriptionComposite() {
    }

    public ParameterDescriptionComposite(String parameterType, Class parameterTypeClass, WebParamAnnot webParamAnnot, WebServiceRefAnnot webServiceRefAnnot, WebServiceContextAnnot webServiceContextAnnot) {
        this.parameterType = parameterType;
        this.parameterTypeClass = parameterTypeClass;
        this.webParamAnnot = webParamAnnot;
        this.webServiceRefAnnot = webServiceRefAnnot;
        this.webServiceContextAnnot = webServiceContextAnnot;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public Class getParameterTypeClass() {
        if (this.parameterTypeClass == null && this.getParameterType() != null) {
            this.parameterTypeClass = DescriptionBuilderUtils.getPrimitiveClass(this.getParameterType());
            if (this.parameterTypeClass == null) {
                String classToLoad = null;
                classToLoad = DescriptionBuilderUtils.getRawType(this.parameterType) != null ? DescriptionBuilderUtils.getRawType(this.parameterType) : this.parameterType;
                this.parameterTypeClass = this.loadClassFromPDC(classToLoad);
            }
        }
        return this.parameterTypeClass;
    }

    public Class getHolderActualTypeClass() {
        Class returnClass = null;
        if (DescriptionBuilderUtils.isHolderType(this.parameterType)) {
            String classToLoad = DescriptionBuilderUtils.getHolderActualType(this.parameterType);
            returnClass = this.loadClassFromPDC(classToLoad);
        }
        return returnClass;
    }

    private Class loadClassFromPDC(String classToLoad) {
        Class returnClass = null;
        ClassLoader classLoader = null;
        if (this.getMethodDescriptionCompositeRef() != null && this.getMethodDescriptionCompositeRef().getDescriptionBuilderCompositeRef() != null) {
            classLoader = this.getMethodDescriptionCompositeRef().getDescriptionBuilderCompositeRef().getClassLoader();
        }
        returnClass = DescriptionBuilderUtils.loadClassFromComposite(classToLoad, classLoader);
        return returnClass;
    }

    public WebParamAnnot getWebParamAnnot() {
        return this.webParamAnnot;
    }

    public WebServiceRefAnnot getWebServiceRefAnnot() {
        return this.webServiceRefAnnot;
    }

    public WebServiceContextAnnot getWebServiceContextAnnot() {
        return this.webServiceContextAnnot;
    }

    public int getListOrder() {
        return this.listOrder;
    }

    public MethodDescriptionComposite getMethodDescriptionCompositeRef() {
        return this.parentMDC;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    private void setParameterTypeClass(Class parameterTypeClass) {
        this.parameterTypeClass = parameterTypeClass;
    }

    public void setWebParamAnnot(WebParamAnnot webParamAnnot) {
        this.webParamAnnot = webParamAnnot;
    }

    public void setWebServiceRefAnnot(WebServiceRefAnnot webServiceRefAnnot) {
        this.webServiceRefAnnot = webServiceRefAnnot;
    }

    public void setWebServiceContextAnnot(WebServiceContextAnnot webServiceContextAnnot) {
        this.webServiceContextAnnot = webServiceContextAnnot;
    }

    public void setListOrder(int listOrder) {
        this.listOrder = listOrder;
    }

    public void setMethodDescriptionCompositeRef(MethodDescriptionComposite mdc) {
        this.parentMDC = mdc;
    }

    public boolean compare(Object obj) {
        if (obj instanceof ParameterDescriptionComposite) {
            ParameterDescriptionComposite pdc = (ParameterDescriptionComposite)obj;
            return this.parameterType.equals(pdc.getParameterType());
        }
        return super.equals(obj);
    }

    public void setIsListType(boolean isListType) {
        this.isListType = isListType;
    }

    public boolean isListType() {
        return this.isListType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String newLine = "\n";
        String sameLine = "; ";
        sb.append(super.toString());
        sb.append("; ");
        sb.append("ParameterType: " + this.parameterType);
        if (this.webParamAnnot != null) {
            sb.append("\n");
            sb.append("WebParam: ");
            sb.append(this.webParamAnnot.toString());
        }
        if (this.webServiceRefAnnot != null) {
            sb.append("\n");
            sb.append("WebServiceRef: ");
            sb.append(this.webServiceRefAnnot.toString());
        }
        return sb.toString();
    }

    public String getRawType() {
        return DescriptionBuilderUtils.getRawType(this.parameterType);
    }

    public String getHolderActualType() {
        return DescriptionBuilderUtils.getHolderActualType(this.parameterType);
    }

    public boolean isHolderType() {
        return DescriptionBuilderUtils.isHolderType(this.parameterType);
    }
}

