/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.core;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.util.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContext {
    private InvocationContext invocationCtx;
    private org.apache.axis2.context.MessageContext axisMsgCtx;
    private Map<String, Object> properties;
    private EndpointDescription endpointDesc;
    private OperationDescription operationDesc;
    private QName operationName;
    private Message message;
    private Service.Mode mode;
    private boolean isOutbound;
    private boolean DELEGATE_TO_OPTIONS = true;
    private MEPContext mepCtx;
    private Throwable localException = null;
    private AxisFault causedByException = null;

    public MessageContext() {
        this.axisMsgCtx = new org.apache.axis2.context.MessageContext();
        this.isOutbound = true;
        if (!this.DELEGATE_TO_OPTIONS) {
            this.properties = new HashMap<String, Object>();
        }
    }

    public MessageContext(org.apache.axis2.context.MessageContext mc) throws WebServiceException {
        if (!this.DELEGATE_TO_OPTIONS) {
            this.properties = new HashMap<String, Object>();
        }
        this.isOutbound = false;
        if (mc != null) {
            this.axisMsgCtx = mc;
            this.message = MessageUtils.getMessageFromMessageContext(mc);
            if (this.message != null) {
                this.message.setMessageContext(this);
            }
        } else {
            this.axisMsgCtx = new org.apache.axis2.context.MessageContext();
        }
    }

    public InvocationContext getInvocationContext() {
        return this.invocationCtx;
    }

    public void setInvocationContext(InvocationContext ic) {
        this.invocationCtx = ic;
    }

    public boolean isOutbound() {
        return this.isOutbound;
    }

    public void setOutbound(boolean isOutbound) {
        this.isOutbound = isOutbound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        if (this.DELEGATE_TO_OPTIONS) {
            Options opts;
            Options options = opts = this.axisMsgCtx.getOptions();
            synchronized (options) {
                return new ReadOnlyProperties(opts.getProperties());
            }
        }
        return this.properties;
    }

    public void setProperties(Map<String, Object> _properties) {
        if (this.DELEGATE_TO_OPTIONS) {
            this.axisMsgCtx.getOptions().setProperties(_properties);
        } else {
            this.getProperties().putAll(_properties);
        }
    }

    public Object getProperty(String key) {
        if (this.DELEGATE_TO_OPTIONS) {
            return this.axisMsgCtx.getOptions().getProperty(key);
        }
        return this.getProperties().get(key);
    }

    public Object setProperty(String key, Object value) {
        if (this.DELEGATE_TO_OPTIONS) {
            Object retval = this.axisMsgCtx.getOptions().getProperty(key);
            this.axisMsgCtx.getOptions().setProperty(key, value);
            return retval;
        }
        return this.getProperties().put(key, value);
    }

    public EndpointDescription getEndpointDescription() {
        return this.endpointDesc;
    }

    public void setEndpointDescription(EndpointDescription ed) {
        this.endpointDesc = ed;
    }

    public OperationDescription getOperationDescription() {
        return this.operationDesc;
    }

    public void setOperationDescription(OperationDescription od) {
        this.operationDesc = od;
    }

    public Service.Mode getMode() {
        return this.mode;
    }

    public void setMode(Service.Mode m) {
        this.mode = m;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName op) {
        this.operationName = op;
    }

    public void setMessage(Message msg) {
        this.message = msg;
        msg.setMessageContext(this);
    }

    public Message getMessage() {
        return this.message;
    }

    public org.apache.axis2.context.MessageContext getAxisMessageContext() {
        return this.axisMsgCtx;
    }

    public ClassLoader getClassLoader() {
        AxisService svc = this.axisMsgCtx.getAxisService();
        if (svc != null) {
            return svc.getClassLoader();
        }
        return null;
    }

    public boolean isMaintainSession() {
        boolean maintainSession = false;
        Boolean value = (Boolean)this.getProperty("javax.xml.ws.session.maintain");
        if (value != null && value.booleanValue()) {
            maintainSession = true;
        }
        return maintainSession;
    }

    public Throwable getLocalException() {
        return this.localException;
    }

    public void setLocalException(Throwable t) {
        this.localException = t;
    }

    public void setCausedByException(AxisFault t) {
        this.causedByException = t;
    }

    public AxisFault getCausedByException() {
        return this.causedByException;
    }

    public void setMEPContext(MEPContext mepCtx) {
        if (this.mepCtx == null) {
            this.mepCtx = mepCtx;
            this.mepCtx.setResponseMessageContext(this);
        }
    }

    public MEPContext getMEPContext() {
        if (this.mepCtx == null) {
            this.setMEPContext(new MEPContext(this));
        }
        return this.mepCtx;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReadOnlyProperties
    extends AbstractMap<String, Object> {
        private Map<String, Object> containedProps;

        public ReadOnlyProperties(Map containedProps) {
            this.containedProps = containedProps;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new ReadOnlySet(this.containedProps.entrySet());
        }

        @Override
        public Set<String> keySet() {
            return new ReadOnlySet(this.containedProps.keySet());
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            return new ReadOnlyCollection(this.containedProps.values());
        }

        class ReadOnlySet
        implements Set {
            private Set containedSet;

            private ReadOnlySet(Set containedSet) {
                this.containedSet = containedSet;
            }

            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public boolean contains(Object o) {
                return this.containedSet.contains(o);
            }

            public boolean containsAll(Collection c) {
                return this.containedSet.containsAll(c);
            }

            public boolean isEmpty() {
                return this.containedSet.isEmpty();
            }

            public Iterator iterator() {
                return new ReadOnlyIterator(this.containedSet.iterator());
            }

            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean removeAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public int size() {
                return this.containedSet.size();
            }

            public Object[] toArray() {
                return this.containedSet.toArray();
            }

            public Object[] toArray(Object[] a) {
                return this.containedSet.toArray(a);
            }
        }

        class ReadOnlyIterator
        implements Iterator {
            private Iterator containedIterator;

            private ReadOnlyIterator(Iterator containedIterator) {
                this.containedIterator = containedIterator;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.containedIterator.hasNext();
            }

            public Object next() {
                return this.containedIterator.next();
            }
        }

        class ReadOnlyCollection
        implements Collection {
            private Collection containedCollection;

            private ReadOnlyCollection(Collection containedCollection) {
                this.containedCollection = containedCollection;
            }

            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public boolean contains(Object o) {
                return this.containedCollection.contains(o);
            }

            public boolean containsAll(Collection c) {
                return this.containedCollection.containsAll(c);
            }

            public boolean isEmpty() {
                return this.containedCollection.isEmpty();
            }

            public Iterator iterator() {
                return new ReadOnlyIterator(this.containedCollection.iterator());
            }

            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean removeAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public int size() {
                return this.containedCollection.size();
            }

            public Object[] toArray() {
                return this.containedCollection.toArray();
            }

            public Object[] toArray(Object[] a) {
                return this.containedCollection.toArray(a);
            }
        }
    }
}

