/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextUtils {
    private static final Log log = LogFactory.getLog(ContextUtils.class);
    private static final String WEBSERVICE_MESSAGE_CONTEXT = "javax.xml.ws.WebServiceContext";

    public static void addProperties(SOAPMessageContext soapMessageContext, MessageContext jaxwsMessageContext) {
        HttpServletResponse res;
        HttpServletRequest req;
        org.apache.axis2.context.MessageContext axisMsgContext = jaxwsMessageContext.getAxisMessageContext();
        Map props = axisMsgContext.getOptions().getProperties();
        soapMessageContext.putAll(props);
        ServiceDescription sd = jaxwsMessageContext.getEndpointDescription().getServiceDescription();
        if (sd != null) {
            URL wsdlLocation = ((ServiceDescriptionWSDL)((Object)sd)).getWSDLLocation();
            if (wsdlLocation != null && !"".equals(wsdlLocation)) {
                URI wsdlLocationURI = null;
                try {
                    wsdlLocationURI = wsdlLocation.toURI();
                }
                catch (URISyntaxException ex) {
                    log.warn("Unable to convert WSDL location URL to URI.  URL: " + wsdlLocation.toString() + "; Service: " + sd.getServiceQName(), ex);
                }
                soapMessageContext.put("javax.xml.ws.wsdl.description", wsdlLocationURI);
                soapMessageContext.setScope("javax.xml.ws.wsdl.description", MessageContext.Scope.APPLICATION);
            }
            soapMessageContext.put("javax.xml.ws.wsdl.service", sd.getServiceQName());
            soapMessageContext.setScope("javax.xml.ws.wsdl.service", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug("WSDL_SERVICE :" + sd.getServiceQName());
            }
        }
        soapMessageContext.put("javax.xml.ws.servlet.context", axisMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT));
        soapMessageContext.setScope("javax.xml.ws.servlet.context", MessageContext.Scope.APPLICATION);
        if (log.isDebugEnabled()) {
            if (axisMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT) != null) {
                log.debug("Servlet Context Set");
            } else {
                log.debug("Servlet Context not found");
            }
        }
        if ((req = (HttpServletRequest)axisMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)) == null && log.isDebugEnabled()) {
            log.debug("HTTPServletRequest not found");
        }
        if (req != null) {
            soapMessageContext.put("javax.xml.ws.servlet.request", req);
            soapMessageContext.setScope("javax.xml.ws.servlet.request", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug("SERVLET_REQUEST Set");
            }
            String pathInfo = req.getPathInfo();
            soapMessageContext.put("javax.xml.ws.http.request.pathinfo", pathInfo);
            soapMessageContext.setScope("javax.xml.ws.http.request.pathinfo", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                if (pathInfo != null) {
                    log.debug("HTTP_REQUEST_PATHINFO Set");
                } else {
                    log.debug("HTTP_REQUEST_PATHINFO not found");
                }
            }
            String queryString = req.getQueryString();
            soapMessageContext.put("javax.xml.ws.http.request.querystring", queryString);
            soapMessageContext.setScope("javax.xml.ws.http.request.querystring", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                if (queryString != null) {
                    log.debug("HTTP_REQUEST_QUERYSTRING Set");
                } else {
                    log.debug("HTTP_REQUEST_QUERYSTRING not found");
                }
            }
            String method = req.getMethod();
            soapMessageContext.put("javax.xml.ws.http.request.method", method);
            soapMessageContext.setScope("javax.xml.ws.http.request.method", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                if (method != null) {
                    log.debug("HTTP_REQUEST_METHOD Set");
                } else {
                    log.debug("HTTP_REQUEST_METHOD not found");
                }
            }
        }
        if ((res = (HttpServletResponse)axisMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) == null && log.isDebugEnabled()) {
            log.debug("Servlet Response not found");
        }
        if (res != null) {
            soapMessageContext.put("javax.xml.ws.servlet.response", res);
            soapMessageContext.setScope("javax.xml.ws.servlet.response", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug("SERVLET_RESPONSE Set");
            }
        }
    }

    public static void addWSDLProperties(MessageContext jaxwsMessageContext) {
        OperationDescription op;
        WebServiceContext wsc;
        org.apache.axis2.context.MessageContext msgContext = jaxwsMessageContext.getAxisMessageContext();
        ServiceContext serviceContext = msgContext.getServiceContext();
        SOAPMessageContext soapMessageContext = null;
        if (serviceContext != null && (wsc = (WebServiceContext)serviceContext.getProperty(WEBSERVICE_MESSAGE_CONTEXT)) != null) {
            soapMessageContext = (SOAPMessageContext)wsc.getMessageContext();
        }
        if ((op = jaxwsMessageContext.getOperationDescription()) != null && soapMessageContext != null) {
            EndpointInterfaceDescription eid;
            soapMessageContext.put("javax.xml.ws.wsdl.operation", op.getName());
            soapMessageContext.setScope("javax.xml.ws.wsdl.operation", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug("WSDL_OPERATION :" + op.getName());
            }
            if ((eid = op.getEndpointInterfaceDescription()) != null) {
                EndpointDescription ed = eid.getEndpointDescription();
                QName portType = eid.getPortType();
                if ((portType == null || portType.getLocalPart() == "") && log.isDebugEnabled()) {
                    log.debug("Did not get port type from EndpointInterfaceDescription, attempting to get PortType from EndpointDescription");
                }
                if (ed != null) {
                    soapMessageContext.put("javax.xml.ws.wsdl.port", ed.getPortQName());
                    soapMessageContext.setScope("javax.xml.ws.wsdl.port", MessageContext.Scope.APPLICATION);
                    if (log.isDebugEnabled()) {
                        log.debug("WSDL_PORT :" + ed.getPortQName());
                    }
                }
                soapMessageContext.put("javax.xml.ws.wsdl.interface", portType);
                soapMessageContext.setScope("javax.xml.ws.wsdl.interface", MessageContext.Scope.APPLICATION);
                if (log.isDebugEnabled()) {
                    log.debug("WSDL_INTERFACE :" + portType);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Unable to read WSDL operation, port and interface properties");
        }
    }
}

